/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.lookandfeel;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalToolTipUI;

public class HuaweiToolTipUI
extends MetalToolTipUI {
    private static HuaweiToolTipUI sharedInstance = new HuaweiToolTipUI();
    private Font smallFont = null;
    private JToolTip tip = null;
    private String acceleratorDelimiter = null;

    public static ComponentUI createUI(JComponent jcomponent) {
        return sharedInstance;
    }

    @Override
    public void installUI(JComponent jcomponent) {
        super.installUI(jcomponent);
        this.tip = (JToolTip)jcomponent;
        Font font = jcomponent.getFont();
        this.smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "-";
        }
    }

    @Override
    public void uninstallUI(JComponent jcomponent) {
        super.uninstallUI(jcomponent);
        this.tip = null;
    }

    @Override
    public void paint(Graphics g, JComponent jcomponent) {
        JToolTip jtooltip = (JToolTip)jcomponent;
        super.paint(g, jcomponent);
        String s = this.getAcceleratorString(jtooltip);
        String s1 = jtooltip.getTipText();
        if (s1 == null) {
            s1 = "";
        }
        if (!"".equals(s)) {
            g.setFont(this.smallFont);
            if (jtooltip.getComponent() != null && jtooltip.getComponent().isEnabled()) {
                g.setColor(UIManager.getColor("ToolTip.acceleratorForeground"));
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            Font font = jcomponent.getFont();
            FontMetrics fontmetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            if (System.getProperty("java.version").indexOf("1.6") != -1) {
                this.drawAccelString(g, jcomponent, fontmetrics);
            } else {
                g.drawString(s, fontmetrics.stringWidth(s1) + 12, 2 + fontmetrics.getAscent());
            }
        }
    }

    private void drawAccelString(Graphics g, JComponent jcomponent, FontMetrics fontmetrics) {
        JToolTip jtooltip = (JToolTip)jcomponent;
        int i = fontmetrics.getAscent();
        String s = this.getAcceleratorString(jtooltip);
        FontMetrics fontmetrics1 = g.getFontMetrics(this.smallFont);
        int j = this.calcAccelSpacing(fontmetrics1, s);
        Insets insets = jtooltip.getInsets();
        Dimension dimension = jcomponent.getSize();
        Rectangle rectangle = new Rectangle(insets.left + 3, insets.top, dimension.width - (insets.left + insets.right) - 6 - j, dimension.height - (insets.top + insets.bottom));
        g.drawString(s, jtooltip.getWidth() - 1 - insets.right - j + 12 - 3, rectangle.y + i);
    }

    private int calcAccelSpacing(FontMetrics fontmetrics, String s) {
        return "".equals(s) ? 0 : 12 + fontmetrics.stringWidth(s);
    }

    private String getAcceleratorString(JToolTip jtooltip) {
        this.tip = jtooltip;
        String s = this.getAcceleratorString();
        this.tip = null;
        return s;
    }

    @Override
    public String getAcceleratorString() {
        int j;
        if (this.tip == null || this.isAcceleratorHidden()) {
            return "";
        }
        JComponent jcomponent = this.tip.getComponent();
        if (jcomponent == null) {
            return "";
        }
        KeyStroke[] akeystroke = jcomponent.getRegisteredKeyStrokes();
        String s = "";
        for (int i = 0; i < akeystroke.length; ++i) {
            int k = akeystroke[i].getModifiers();
            int l = jcomponent.getConditionForKeyStroke(akeystroke[i]);
            if (l != 2 || (k & 8) == 0 && (k & 2) == 0 && (k & 1) == 0 && (k & 4) == 0) continue;
            s = KeyEvent.getKeyModifiersText(k) + this.acceleratorDelimiter + KeyEvent.getKeyText(akeystroke[i].getKeyCode());
            break;
        }
        if (s.equals("") && jcomponent instanceof JMenuItem && (j = ((JMenuItem)jcomponent).getMnemonic()) != 0) {
            s = KeyEvent.getKeyModifiersText(8) + this.acceleratorDelimiter + (char)j;
        }
        return s;
    }
}

