/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.lookandfeel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class HuaweiScrollBarUI
extends BasicScrollBarUI {
    private ImageIcon thumVertIcon;
    private ImageIcon thumHorzIcon;
    private boolean isDragged = false;
    private Color thumBorderOutColor = UIManager.getColor("ScrollBar.thumbNormalHighlight");
    private Color thumBorderInnerColor = UIManager.getColor("ScrollBar.thumbNormalDark");
    private int scrollBarWidth;

    public static ComponentUI createUI(JComponent jcomponent) {
        return new HuaweiScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        super.installDefaults();
    }

    private void drawBorder(Graphics g, Rectangle rectangle, Color color, Color color1) {
        Color color2 = g.getColor();
        int i = rectangle.x;
        int j = rectangle.y;
        int k = rectangle.width;
        int l = rectangle.height;
        g.setColor(color);
        g.drawLine(i + 2, j, i + k - 3, j);
        g.drawLine(i + 2, j + l - 1, i + k - 3, j + l - 1);
        g.drawLine(i, j + 2, i, j + l - 3);
        g.drawLine(i + k - 1, j + 2, i + k - 1, j + l - 3);
        g.drawLine(i + 1, j + 1, i + 1, j + 1);
        g.drawLine(i + k - 2, j + 1, i + k - 2, j + 1);
        g.drawLine(i + 1, j + l - 2, i + 1, j + l - 2);
        g.drawLine(i + k - 2, j + l - 2, i + k - 2, j + l - 2);
        g.setColor(color1);
        g.drawLine(i + 2, j + 1, i + k - 3, j + 1);
        g.drawLine(i + 2, j + l - 2, i + k - 3, j + l - 2);
        g.drawLine(i + 1, j + 2, i + 1, j + l - 3);
        g.drawLine(i + k - 2, j + 2, i + k - 2, j + l - 3);
        g.setColor(color2);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent jcomponent, Rectangle rectangle) {
        int i = rectangle.x;
        int j = rectangle.y;
        int k = rectangle.width;
        int l = rectangle.height;
        Color color = this.thumBorderOutColor;
        Color color1 = this.thumBorderInnerColor;
        if (!jcomponent.isEnabled()) {
            super.paintThumb(g, jcomponent, rectangle);
            return;
        }
        if (this.scrollbar.getOrientation() == 1) {
            this.drawBorder(g, new Rectangle(i, j, k, l), color, color1);
        } else {
            this.drawBorder(g, new Rectangle(i, j, k, l), color, color1);
        }
    }

    @Override
    protected void paintTrack(Graphics g, JComponent jcomponent, Rectangle rectangle) {
        int i = rectangle.x;
        int j = rectangle.y;
        int k = rectangle.width;
        int l = rectangle.height;
        if (this.scrollbar.getOrientation() == 1) {
            if (jcomponent.isEnabled()) {
                g.setColor(UIManager.getColor("ScrollBar.darkShadow"));
                g.drawRect(i, j, k, l);
            } else {
                g.setColor(UIManager.getColor("ScrollBar.darkShadow"));
                g.drawRect(i, j, k, l);
            }
        } else if (jcomponent.isEnabled()) {
            g.setColor(UIManager.getColor("ScrollBar.darkShadow"));
            g.drawRect(i, j, k, l);
        } else {
            g.setColor(UIManager.getColor("ScrollBar.darkShadow"));
            g.drawRect(i, j, k, l);
        }
    }
}

