/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.legend;

import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.common.colorselect.TEColorChooserUtil;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalTable;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalTableModel;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendChangeGraphColorEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedEvent;
import com.huawei.nglct.otdr.appletgraph.legend.TEOTDRLegendCellRender;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphGraphInterface;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TEOTDRLegendTable
extends TENormalTable {
    private static final long serialVersionUID = 1L;
    private static final int LEGEND_COLOR_COLUMN = 0;
    private static final int FILE_FULL_NAME_COLUMN = 2;
    private static TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance("res" + File.separator + "stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    private String selectedFileName = null;
    protected transient TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;

    public String getSelectedFileName() {
        return this.selectedFileName;
    }

    public void setSelectedFileName(String selectedFileName) {
        this.selectedFileName = selectedFileName;
    }

    public TEOTDRLegendTable(TENormalTableModel model, TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        super(model);
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TENormalTableModel model = (TENormalTableModel)this.getModel();
        Color curColor = null;
        if (column == 0) {
            curColor = (Color)model.getValueAt(row, column);
        }
        String fileName = (String)model.getValueAt(row, 2);
        return new TEOTDRLegendCellRender(curColor, fileName.equals(this.selectedFileName));
    }

    @Override
    public TableCellEditor getCellEditor(final int row, final int column) {
        final String fileName = (String)this.getModel().getValueAt(row, 2);
        final TENormalTableModel model = (TENormalTableModel)this.getModel();
        if (column == 0) {
            Frame p = TECommonUtil.getTopFrame(this);
            final TEColorChooserUtil colorChooser = new TEColorChooserUtil();
            ActionListener okLis = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color newColor = colorChooser.getColor();
                    if (TEOTDRLegendTable.this.isUsedColor(newColor)) {
                        InmOptionPane.showMessageDialog(null, resUtil.getString("usedcolor"));
                        return;
                    }
                    if (null == newColor) {
                        return;
                    }
                    TEOTDRLegendTable.this.teCommonUtil.setFileColor(fileName, newColor);
                    model.setValueAt(newColor, row, column);
                    model.fireTableDataChanged();
                    TEOTDRLegendTable.this.fireLegendChangeGraphColorEvent(fileName, newColor);
                }
            };
            JDialog jc = TEColorChooserUtil.createDialog(p, resUtil.getString("CHANGE_FILE_COLOR_DIALOG"), true, okLis);
            jc.setVisible(true);
            return null;
        }
        this.selectedFileName = fileName;
        this.fireLegendMakeFileSelectedEvent(fileName);
        model.fireTableDataChanged();
        return null;
    }

    private boolean isUsedColor(Color color) {
        TEOTDRGraphGraphInterface ginf;
        boolean isUsed = false;
        ArrayList<String> openedFileList = this.teCommonUtil.getOpenedFileList();
        ArrayList<Color> usedColors = new ArrayList<Color>();
        if (null != openedFileList) {
            int openFileLen = openedFileList.size();
            for (int i = 0; i < openFileLen; ++i) {
                usedColors.add(this.teCommonUtil.getFileColor(openedFileList.get(i)));
            }
        }
        if (null != (ginf = this.teOTDRGraphModuleMgr.getGraphInteractor()) && null != ginf.getBackgroundColor()) {
            usedColors.add(ginf.getBackgroundColor());
        }
        if (usedColors.contains(color)) {
            isUsed = true;
        }
        return isUsed;
    }

    private void fireLegendChangeGraphColorEvent(String fileName, Color newColor) {
        System.out.println("TEOTDRLegendTable: \u00b4\u00a5\u00b7\u00a2\u00cd\u00bc\u00c0\u00fd\u00d1\u00d5\u00c9\u00ab\u00b8\u00c4\u00b1\u00e4\u00ca\u00c2\u00bc\u00fe");
        TEOTDRGraphLegendChangeGraphColorEvent event = TEOTDRGraphLegendChangeGraphColorEvent.getEvent();
        event.setFileName(fileName);
        event.setNewColor(newColor);
        this.teOTDRGraphEventManager.triggerEvent(event);
    }

    public void fireLegendMakeFileSelectedEvent(String fileName) {
        System.out.println("TEOTDRLegendTable: \u00b4\u00a5\u00b7\u00a2\u00ce\u00c4\u00bc\u00fe\u00d1\u00a1\u00d4\u00f1\u00ca\u00c2\u00bc\u00fe");
        TEOTDRGraphLegendMakeFileSelectedEvent event = TEOTDRGraphLegendMakeFileSelectedEvent.getEvent();
        event.setFileName(fileName);
        this.teOTDRGraphEventManager.triggerEvent(event);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }
}

