/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.legend;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphViewTestRecordView;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalTableModel;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventNotInitException;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedListener;
import com.huawei.nglct.otdr.appletgraph.legend.TEOTDRLegendTable;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModule;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphFileTreeIntegerface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class TEOTDRLegendPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int FILE_FULL_NAME_COLUMN = 2;
    private TEOTDRLegendTable legendTable = null;
    private TENormalTableModel legendTableModel = null;
    private transient TEOTDRGraphFileTreeFileOpenedListener fileOpenListener = null;
    private transient TEOTDRGraphFileTreeFileClosedListener fileClosedListener = null;
    private transient TEOTDRGraphFileTreeFileDeletedListener fileDeletedListener = null;
    private String selectedFileName = null;
    private TEMarineResourceUtil menuResUtil = TEMarineResourceUtil.getInstance("res/filetreemenu_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    public static final String LEGEND_TABLE_PROFILE = "conf/legendtable_" + TESystemMgr.getInstance().getLanguage() + ".ini";
    private TEMarineResourceUtil strResUtil = TEMarineResourceUtil.getInstance("res/stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    protected transient TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;

    public TEOTDRLegendPanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
        this.initModel();
        this.initTable();
        this.jbInit();
        this.initListener();
    }

    private void initModel() {
        if (null == this.legendTableModel) {
            this.legendTableModel = new TENormalTableModel("LEGEND_TABLE", LEGEND_TABLE_PROFILE);
        }
    }

    private void initTable() {
        if (null != this.legendTable) {
            return;
        }
        this.legendTable = new TEOTDRLegendTable(this.legendTableModel, this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager, this.teCommonUtil);
        this.legendTable.setAutoResizeMode(2);
        this.legendTable.setSelectionMode(0);
        this.legendTable.setSortable(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TEOTDRLegendPanel.this.handleTableMouseReleasedEvent(e);
            }
        };
        this.legendTable.addMouseListener(mouseAdapter);
    }

    private void handleTableMouseReleasedEvent(MouseEvent e) {
        if (4 != e.getModifiers()) {
            return;
        }
        Point point = e.getPoint();
        int x = e.getX();
        int y = e.getY();
        int row = this.legendTable.rowAtPoint(point);
        int col = this.legendTable.columnAtPoint(point);
        if (-1 == row || -1 == col) {
            return;
        }
        String fileName = (String)this.legendTableModel.getValueAt(row, 2);
        JPopupMenu popupMenu = this.getPopupMenu(fileName);
        popupMenu.show(this.legendTable, x, y);
    }

    private JPopupMenu getPopupMenu(final String fileName) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem closeItem = new JMenuItem();
        closeItem.setText(this.menuResUtil.getString("CLOSE"));
        closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRLegendPanel.this.handleLegendCloseFileEvent(fileName);
            }
        });
        popupMenu.add(closeItem);
        return popupMenu;
    }

    private void handleLegendCloseFileEvent(String fileName) {
        String classMethodName = "TEOTDRLegendPanel.handleLegendCloseFileEvent() ";
        String logInfo = "\u00b7\u00a2\u00cb\u00cd\u00cd\u00bc\u00c0\u00fd\u00c9\u00cf\u00b9\u00d8\u00b1\u00d5\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe. fileName: " + fileName;
        TECommonUtil.log(classMethodName, logInfo);
        TEOTDRGraphFileTreeIntegerface fileTreeInf = this.teOTDRGraphModuleMgr.getFileTreeInteractor();
        fileTreeInf.closeGraphFromFileTree(fileName);
        if (this.legendTable.getRowCount() > 0) {
            String fileNameNew;
            this.selectedFileName = fileNameNew = (String)this.legendTableModel.getValueAt(0, 2);
            this.legendTable.setSelectedFileName(fileNameNew);
            this.legendTable.fireLegendMakeFileSelectedEvent(fileNameNew);
        }
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(180, 100));
        this.setMinimumSize(new Dimension(180, 100));
        this.setMaximumSize(new Dimension(180, 100));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.legendTable);
        this.add((Component)scrollPane, "Center");
    }

    private void initListener() {
        this.fileOpenListener = new TEOTDRGraphFileTreeFileOpenedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRLegendPanel.this.handleFileTreeFileOpenedEvent(event);
            }
        };
        this.fileClosedListener = new TEOTDRGraphFileTreeFileClosedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRLegendPanel.this.handleFileTreeFileClosedEvent(event);
            }
        };
        this.fileDeletedListener = new TEOTDRGraphFileTreeFileDeletedListener(){

            @Override
            public void handleEvent(TEOTDRGraphEvent event) {
                TEOTDRLegendPanel.this.handleFileTreeFileDeletedEvent(event);
            }
        };
        this.teOTDRGraphEventManager.addListener(this.fileOpenListener);
        this.teOTDRGraphEventManager.addListener(this.fileClosedListener);
        this.teOTDRGraphEventManager.addListener(this.fileDeletedListener);
    }

    private void handleFileTreeFileOpenedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileOpenedEvent theEvent = (TEOTDRGraphFileTreeFileOpenedEvent)event;
        try {
            String fileName = theEvent.getFileName();
            String classMethodName = "TEOTDRLegendPanel.handleFileTreeFileOpenedEvent() ";
            String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00ce\u00c4\u00bc\u00fe\u00ca\u00f7\u00c9\u00cf\u00b4\u00f2\u00bf\u00aa\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe. fileName: " + fileName;
            TECommonUtil.log(classMethodName, logInfo);
            this.selectedFileName = fileName;
            this.legendTable.setSelectedFileName(this.selectedFileName);
            if (!this.hasFileOpened(this.selectedFileName)) {
                this.addLegend(this.selectedFileName);
            } else {
                this.legendTableModel.fireTableDataChanged();
            }
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEOTDRLegendPanel.handleFileTreeFileOpenedEvent() fail!", e);
        }
    }

    private boolean hasFileOpened(String fileFullName) {
        int len = this.legendTableModel.getRowCount();
        for (int i = 0; i < len; ++i) {
            if (!fileFullName.equals(this.legendTableModel.getValueAt(i, 2))) continue;
            return true;
        }
        return false;
    }

    private void addLegend(String fileName) {
        Color color = this.teCommonUtil.getFileColor(fileName);
        String classMethodName = "TEOTDRLegendPanel.addLegend() ";
        String logInfo = "fileName: " + fileName + " color: " + color;
        TECommonUtil.log(classMethodName, logInfo);
        String showName = "";
        if (0 > this.selectedFileName.indexOf("mid")) {
            HashMap<String, String> fileNameParamMap = null;
            fileNameParamMap = TECommonUtil.getParamMapFromFileName(fileName, false);
            boolean isBaseline = "1".equals(fileNameParamMap.get("baseline"));
            showName = this.teCommonUtil.getParamFromFileName(this.selectedFileName, "showName", this.isViewTestRecordView());
            showName = isBaseline ? this.strResUtil.getString("BASELINE_NAME") : showName;
        } else {
            showName = this.selectedFileName;
        }
        Vector<Object> rowVector = new Vector<Object>();
        rowVector.add(color);
        rowVector.add(showName);
        rowVector.add(fileName);
        this.legendTableModel.getDataVector().add(rowVector);
        this.legendTableModel.fireTableDataChanged();
    }

    private void handleFileTreeFileClosedEvent(TEOTDRGraphEvent event) {
        TEOTDRGraphFileTreeFileClosedEvent theEvent = (TEOTDRGraphFileTreeFileClosedEvent)event;
        try {
            String fileName = theEvent.getFileName();
            String classMethodName = "TEOTDRLegendPanel.handleFileTreeFileClosedEvent() ";
            String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00b4\u00d3\u00ce\u00c4\u00bc\u00fe\u00ca\u00f7\u00c9\u00cf\u00b9\u00d8\u00b1\u00d5\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe. fileName: " + fileName;
            TECommonUtil.log(classMethodName, logInfo);
            this.removeLegend(fileName);
            if (fileName.equals(this.selectedFileName)) {
                this.selectedFileName = null;
                this.legendTable.setSelectedFileName(null);
            }
            if (this.legendTable.getRowCount() > 0) {
                String fileNameNew;
                this.selectedFileName = fileNameNew = (String)this.legendTableModel.getValueAt(0, 2);
                this.legendTable.setSelectedFileName(fileNameNew);
                this.legendTable.fireLegendMakeFileSelectedEvent(fileNameNew);
            }
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEOTDRLegendPanel.handleFileTreeFileClosedEvent() fail!", e);
        }
    }

    private void removeLegend(String fileFullName) {
        String fileName = null;
        int len = this.legendTableModel.getRowCount();
        for (int i = 0; i < len; ++i) {
            fileName = (String)this.legendTableModel.getValueAt(i, 2);
            if (!fileFullName.equals(fileName)) continue;
            this.legendTableModel.removeRow(i);
            this.legendTableModel.fireTableDataChanged();
            break;
        }
    }

    private void handleFileTreeFileDeletedEvent(TEOTDRGraphEvent event) {
        String classMethodName = "TEOTDRLegendPanel.handleFileTreeFileDeletedEvent() ";
        String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00c9\u00be\u00b3\u00fd\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe.";
        TECommonUtil.log(classMethodName, logInfo);
        TEOTDRGraphFileTreeFileDeletedEvent theEvent = (TEOTDRGraphFileTreeFileDeletedEvent)event;
        try {
            List<String> fileNameList = theEvent.getFileNameList();
            for (String fileName : fileNameList) {
                this.removeLegend(fileName);
                if (!fileName.equals(this.selectedFileName)) continue;
                this.selectedFileName = null;
                this.legendTable.setSelectedFileName(null);
            }
            if (null == this.selectedFileName && this.legendTable.getRowCount() > 0) {
                String fileNameNew;
                this.selectedFileName = fileNameNew = (String)this.legendTableModel.getValueAt(0, 2);
                this.legendTable.setSelectedFileName(fileNameNew);
                this.legendTable.fireLegendMakeFileSelectedEvent(fileNameNew);
            }
        }
        catch (TEOTDRGraphEventNotInitException e) {
            TEAppletLogMgr.error("TEOTDRLegendPanel.handleFileTreeFileDeletedEvent() fail!", e);
        }
    }

    private boolean isViewTestRecordView() {
        TEOTDRGraphModule module = this.teOTDRGraphModuleMgr.getModuleByModuleName("mainframemodule");
        return module instanceof TEOTDRGraphViewTestRecordView;
    }
}

