/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.io.File;
import javax.swing.JLabel;

public class TEOTDRRptTimeAxis
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static final int AXISOFFSET = 27;
    private static final int EDGLENGTH = 1;
    private static final double TEXT_ROTATE_DEGREE = 0.35;
    private TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance("res" + File.separator + "stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    private static final int MASK_LENGTH = 6;
    private static final int HIGHT = 57;
    private int width;
    private int height;
    private Point startPoint;
    private String[] rptInfos;

    public TEOTDRRptTimeAxis(int graphWidth, int graphHeight, String[] rptInfos) {
        this.setAxisBasicInfo(graphWidth, graphHeight, rptInfos);
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
        this.setBackground(TEOTDRGraphicConstants.GAPCOLOR);
        this.setOpaque(true);
    }

    private void setAxisBasicInfo(int graphWidth, int graphHeight, String[] rptInfos) {
        this.width = graphWidth;
        this.height = 57;
        this.startPoint = new Point(1, graphHeight - 57);
        this.rptInfos = rptInfos;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawRepeaterAxis(g);
        this.drawAxisHead(g);
        this.drawAxisDetail(g);
    }

    private void drawRepeaterAxis(Graphics g) {
        int startx = 27;
        int starty = 6;
        g.drawLine(startx, starty, startx + this.width, starty);
    }

    private void drawAxisHead(Graphics g) {
        String REPEATERID = this.resUtil.getString("dateTimeStamp");
        int ANGLE_NUM = 3;
        int TRIHEIGHT = 12;
        int TRBOTTOMLEN = 8;
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        int nPoints = 3;
        int xi = this.width;
        int yi = 6;
        xPoints[0] = xi;
        yPoints[0] = yi;
        xPoints[1] = xi -= 12;
        yPoints[1] = yi += 4;
        xPoints[2] = xi;
        yPoints[2] = yi -= 8;
        g.drawPolygon(xPoints, yPoints, nPoints);
        g.fillPolygon(xPoints, yPoints, nPoints);
        g.drawString(REPEATERID, this.width - 65, 22);
    }

    private void drawAxisDetail(Graphics g) {
        if (null == this.rptInfos || 0 == this.rptInfos.length) {
            return;
        }
        int dateCount = this.rptInfos.length;
        int modNum = dateCount % 9;
        int labelRange = (dateCount + modNum) / 9;
        if (labelRange == 1) {
            ++labelRange;
        }
        if (dateCount <= 10) {
            labelRange = 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tx = new AffineTransform();
        tx.rotate(0.35);
        Font dateStrFont = TEOTDRGraphicConstants.FONT;
        g2.setFont(dateStrFont.deriveFont(tx));
        int timeAxisLen = this.width - 165;
        for (int i = 0; i < dateCount; ++i) {
            int xPos = i * timeAxisLen / dateCount + 5;
            if (i != 0 && i != dateCount - 1 && (0 != i % labelRange || dateCount > 10 && i == dateCount - 2)) continue;
            String rptDateStr = this.getRptDateStr(this.rptInfos[i]);
            g2.drawString(rptDateStr, xPos += 40, 18);
            g2.drawLine(xPos, 0, xPos, 6);
        }
    }

    public String getRptDateStr(String rptInfo) {
        rptInfo = rptInfo.split(",")[0];
        String year = rptInfo.substring(0, 4);
        String month = rptInfo.substring(4, 6);
        String day = rptInfo.substring(6, 8);
        String hour = rptInfo.substring(8, 10);
        String minute = rptInfo.substring(10, 12);
        String second = rptInfo.substring(12);
        return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
    }

    public void changeAxisRpt(Point startPoint, int graphWidth, int viewHeigth) {
        this.width = graphWidth - 3;
        this.startPoint = new Point(1, startPoint.y + viewHeigth - 57 - 2);
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
        this.repaint();
    }

    public void setStartPoint(Point point, int viewHeight) {
        this.startPoint = new Point(1, this.startPoint.y + viewHeight - 57 - 2);
        this.setLocation(this.startPoint);
        this.repaint();
    }
}

