/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartLeftAxis;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRRepeaterChart;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRRptPopupMenu;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRRptTimeAxis;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphInteractor;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModule;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphRepeaterInfoInterface;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class TEOTDRRepeaterChartCanvas
extends JPanel
implements MouseMotionListener,
MouseListener,
TEOTDRGraphRepeaterInfoInterface,
TEOTDRGraphModule,
AncestorListener {
    private static final long serialVersionUID = 1L;
    private static final int EDGE = 3;
    private TEOTDRRptPopupMenu popupMenu = new TEOTDRRptPopupMenu(this);
    private TEOTDRRepeaterChart rptChart;
    private TEOTDRChartLeftAxis leftAxis;
    private TEOTDRRptTimeAxis timeAxis;
    private Dimension size;
    private JScrollPane parent;
    private Point zoomBoxStartP;
    private Dimension zoomBoxSize;
    private Rectangle zoomBox;
    DecimalFormat doubleFormatter = new DecimalFormat("0.000");
    private float gainRange = 40.0f;
    private float maxGain = 40.0f;
    private Point startPoint = new Point(1, 1);
    private Point viewStartPoint = new Point(1, 1);
    protected transient TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;

    public TEOTDRRepeaterChartCanvas(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.setLayout(null);
        this.add(this.popupMenu);
        this.setBackground(TEOTDRGraphicConstants.defaultBGColor);
        this.addEventListeners();
        this.registerModule();
    }

    public void createRptChart(String repeaterStr) {
        String[] rptInfoArr = repeaterStr.split(" ");
        rptInfoArr = this.resortRptInfoArr(rptInfoArr);
        this.parent = (JScrollPane)((JViewport)this.getParent()).getParent();
        this.size = new Dimension(this.getViewWidth(), this.getViewHeight());
        this.setSize(this.size);
        this.setPreferredSize(this.size);
        this.startPoint.setLocation(1, 1);
        this.viewStartPoint = new Point(this.startPoint);
        this.clearCanvas();
        this.leftAxis = new TEOTDRChartLeftAxis(this.startPoint, this.size.height, this.size.height, true);
        this.add(this.leftAxis);
        this.timeAxis = new TEOTDRRptTimeAxis(this.size.width, this.size.height, rptInfoArr);
        this.add(this.timeAxis);
        int width = this.size.width - 165 - 2;
        int height = this.size.height - 25 - 57 - 3;
        this.rptChart = new TEOTDRRepeaterChart(new Dimension(width, height));
        this.rptChart.createNewPath(rptInfoArr);
        this.repaint();
    }

    private void clearCanvas() {
        if (null != this.leftAxis && null != this.timeAxis) {
            this.remove(this.leftAxis);
            this.remove(this.timeAxis);
            this.leftAxis = null;
            this.timeAxis = null;
            this.rptChart = null;
        }
    }

    private String[] resortRptInfoArr(String[] rptInfoArr) {
        String[] newrptInfoArr = new String[rptInfoArr.length];
        String[] timeArr = new String[rptInfoArr.length];
        Date[] dateArr = new Date[rptInfoArr.length];
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        Date date = null;
        int len = rptInfoArr.length;
        for (int i = 0; i < len; ++i) {
            String[] splitArr = rptInfoArr[i].split(",");
            timeArr[i] = splitArr[0];
            year = Integer.parseInt(timeArr[i].substring(0, 4));
            month = Integer.parseInt(timeArr[i].substring(4, 6));
            day = Integer.parseInt(timeArr[i].substring(6, 8));
            hour = Integer.parseInt(timeArr[i].substring(6, 8));
            minute = Integer.parseInt(timeArr[i].substring(8, 10));
            second = Integer.parseInt(timeArr[i].substring(10, 12));
            dateArr[i] = date = new Date(year, month, day, hour, minute, second);
        }
        Date tempDate = null;
        int index = 0;
        int count = dateArr.length;
        for (int k = 0; k < count; ++k) {
            tempDate = dateArr[0];
            index = 0;
            for (int j = 0; j < dateArr.length; ++j) {
                if (null == dateArr[j]) continue;
                if (null == tempDate) {
                    tempDate = dateArr[j];
                    index = j;
                    continue;
                }
                if (tempDate.compareTo(dateArr[j]) <= 0) continue;
                tempDate = dateArr[j];
                index = j;
            }
            dateArr[index] = null;
            newrptInfoArr[k] = rptInfoArr[index];
        }
        return newrptInfoArr;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (null != this.rptChart) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.RED);
            g2d.draw(this.rptChart);
            this.rptChart.drawDot(g);
        }
    }

    private void showToolTip(Point p) {
        String rptStr = this.rptChart.getPointInfo(p);
        if (null == rptStr || "".equals(rptStr)) {
            return;
        }
        float gain = Float.valueOf(rptStr.split(",")[1]).floatValue();
        rptStr = this.timeAxis.getRptDateStr(rptStr) + ", " + this.doubleFormatter.format(gain);
        this.setToolTipText(rptStr);
    }

    public void restore() {
        if (null != this.rptChart && this.size.width != this.getViewWidth() && this.size.height != this.getViewHeight()) {
            this.startPoint = new Point(1, 1);
            this.setLocation(this.startPoint);
            this.viewStartPoint = new Point(1, 1);
            this.size.setSize(this.getViewWidth(), this.getViewHeight());
            this.setSize(this.size);
            this.setPreferredSize(this.size);
            this.leftAxis.changeAxis(this.viewStartPoint, this.size.height, this.size.height, true);
            this.timeAxis.changeAxisRpt(this.startPoint, this.size.width, this.getViewHeight());
            int width = this.size.width - 165 - 2;
            int height = this.size.height - 25 - 57 - 3;
            this.rptChart.restore(new Dimension(width, height));
            this.zoomBoxStartP = null;
            this.zoomBoxSize = null;
            this.zoomBox = null;
            this.repaint();
        }
    }

    private void addEventListeners() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addAncestorListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (4 != e.getModifiers()) {
            Point p = e.getPoint();
            int x = p.x < 46 ? 46 : p.x;
            int y = p.y < 25 ? 26 : p.y;
            this.zoomBoxStartP = new Point(x, y);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getModifiers() == 4) {
            return;
        }
        Point p = e.getPoint();
        Point zoomBoxEndPoint = this.calcZoomBoxEndPoint(p);
        int zoomBoxWidth = Math.abs(zoomBoxEndPoint.x - this.zoomBoxStartP.x);
        int zoomBoxHeight = Math.abs(zoomBoxEndPoint.y - this.zoomBoxStartP.y);
        this.zoomBoxSize = new Dimension(zoomBoxWidth, zoomBoxHeight);
        Point boxRealStartPoint = this.calcZoomBoxStartPoint(zoomBoxEndPoint);
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        g2d.setXORMode(TEOTDRGraphicConstants.defaultBGColor);
        g2d.setColor(Color.RED);
        if (null != this.zoomBox) {
            g2d.draw(this.zoomBox);
            this.zoomBox.setRect(boxRealStartPoint.getX(), boxRealStartPoint.getY(), this.zoomBoxSize.getWidth(), this.zoomBoxSize.getHeight());
        } else {
            this.zoomBox = new Rectangle(this.zoomBoxStartP, this.zoomBoxSize);
        }
        g2d.draw(this.zoomBox);
    }

    private Point calcZoomBoxStartPoint(Point p) {
        int startPX = p.x > this.zoomBoxStartP.x ? this.zoomBoxStartP.x : p.x;
        int startPY = p.y > this.zoomBoxStartP.y ? this.zoomBoxStartP.y : p.y;
        return new Point(startPX, startPY);
    }

    private Point calcZoomBoxEndPoint(Point p) {
        int endPX = p.x;
        int endPY = p.y;
        if (p.x <= 45) {
            endPX = 46;
        }
        if (p.x >= this.getWidth()) {
            endPX = this.getWidth() - 3;
        }
        if (p.y <= 1) {
            endPY = 1;
        }
        if (p.y >= this.getHeight() - 57 - 3) {
            endPY = this.getHeight() - 57 - 3;
        }
        return new Point(endPX, endPY);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (null == this.rptChart) {
            return;
        }
        Point p = e.getPoint();
        boolean isContains = this.rptChart.containsPoint(p);
        if (isContains) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.showToolTip(p);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int modifiers = e.getModifiers();
        Point p = e.getPoint();
        int x = (int)p.getX();
        int y = (int)p.getY();
        if (4 == modifiers) {
            this.popupMenu.show(this, x, y);
            return;
        }
        if (16 == modifiers) {
            if (null == this.rptChart || this.isZoomBoxEmpty(this.zoomBoxSize)) {
                return;
            }
            p = this.calcZoomBoxEndPoint(p);
            this.zoomBoxStartP = this.calcZoomBoxStartPoint(p);
            this.zoomIn(p);
            this.repaint();
            this.clearZoomBox();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        if (this.getX() == this.startPoint.x && this.getY() == this.startPoint.y) {
            return;
        }
        this.scrollCanvas();
    }

    public void scrollCanvas() {
        if (null == this.leftAxis || null == this.timeAxis) {
            return;
        }
        int difx = this.getX() - this.startPoint.x;
        int dify = this.getY() - this.startPoint.y;
        if (difx != 0) {
            this.startPoint.x = this.getX();
            this.viewStartPoint.x = -this.startPoint.x;
            this.leftAxis.setStartPoint(this.viewStartPoint);
        }
        if (dify != 0) {
            this.startPoint.y = this.getY();
            this.viewStartPoint.y = -this.startPoint.y;
            this.timeAxis.changeAxisRpt(this.viewStartPoint, this.size.width, this.getViewHeight());
        }
        this.repaint();
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    private void clearZoomBox() {
        this.zoomBoxStartP = null;
        this.zoomBoxSize = null;
        this.zoomBox = null;
    }

    private void zoomIn(Point p) {
        if (!this.canBeZoomed()) {
            this.clearZoomBox();
            this.repaint();
            return;
        }
        float xZoomMultiple = (float)(this.getViewWidth() - 45) / this.getZoomBoxRealWidth();
        float yZoomMultiple = (float)(this.getViewHeight() - 50) / (float)this.zoomBoxSize.height;
        this.size.setSize((float)this.getCanvasRealWidth() * xZoomMultiple + 165.0f, (float)this.getCanvasRealHeight() * yZoomMultiple + 50.0f);
        this.startPoint.x -= (int)((float)(this.zoomBoxStartP.x - 45) * xZoomMultiple + 45.0f) - this.viewStartPoint.x;
        this.startPoint.y -= (int)((float)(this.zoomBoxStartP.y - 25) * yZoomMultiple + 25.0f) - this.viewStartPoint.y;
        this.setLocation(this.startPoint);
        this.setSize(this.size);
        this.setPreferredSize(this.size);
        this.viewStartPoint.x = -this.startPoint.x;
        this.viewStartPoint.y = -this.startPoint.y;
        this.timeAxis.changeAxisRpt(this.viewStartPoint, this.size.width, this.getViewHeight());
        this.leftAxis.changeAxis(this.viewStartPoint, this.size.height, this.getViewHeight(), true);
        int width = this.size.width - 165 - 2;
        int height = this.size.height - 25 - 57 - 3;
        this.rptChart.zoomIn(new Dimension(width, height));
    }

    private boolean canBeZoomed() {
        String[] zoomInRptGains = this.rptChart.getZoomInRptGains(this.zoomBoxStartP, new Point(this.zoomBoxStartP.x + this.zoomBoxSize.width, this.zoomBoxStartP.y + this.zoomBoxSize.height));
        if (null == zoomInRptGains || 0 == zoomInRptGains.length) {
            return false;
        }
        float zoomDB = this.calcDBLength(this.zoomBoxSize.height);
        return !(zoomDB < 0.3f);
    }

    private float getZoomBoxRealWidth() {
        float boxWidth = this.zoomBoxSize.width;
        int gap = (int)((float)this.zoomBoxStartP.x + boxWidth - (float)(this.getWidth() - 120));
        if (gap > 0) {
            boxWidth -= (float)gap;
        }
        return boxWidth;
    }

    private float calcDBLength(float y) {
        return this.gainRange * y / (float)(this.getHeight() - 50);
    }

    private int getViewWidth() {
        return this.parent.getWidth() - 18 - 1;
    }

    private int getViewHeight() {
        return this.parent.getHeight() - 18 - 1;
    }

    private int getCanvasRealWidth() {
        int tWidth = this.size.width - 165;
        if (tWidth <= 0) {
            tWidth = 1;
        }
        return tWidth;
    }

    private int getCanvasRealHeight() {
        int tHeight = this.size.height - 50;
        if (tHeight <= 0) {
            tHeight = 1;
        }
        return tHeight;
    }

    private float[] getAxisGains(String[] zoomInRptGains, float boxMinGain, float boxMaxGain) {
        float[] axisGains = new float[2];
        axisGains[0] = axisGains[1] = this.getGainFromString(zoomInRptGains[0]);
        int len = zoomInRptGains.length;
        for (int i = 1; i < len; ++i) {
            float tempGain = this.getGainFromString(zoomInRptGains[i]);
            if (tempGain < axisGains[0]) {
                axisGains[0] = tempGain;
            }
            if (!(tempGain > axisGains[1])) continue;
            axisGains[1] = tempGain;
        }
        if (axisGains[1] == -1.0f) {
            axisGains[1] = axisGains[0];
        }
        if (axisGains[0] > boxMinGain) {
            axisGains[0] = boxMinGain;
        }
        if (axisGains[1] < boxMaxGain) {
            axisGains[1] = boxMaxGain;
        }
        return axisGains;
    }

    private float getGainFromString(String rptInfo) {
        float gain = Float.valueOf(rptInfo.split(",")[1]).floatValue();
        return Float.valueOf(this.doubleFormatter.format(gain)).floatValue();
    }

    private int calcY(float gain) {
        return (int)(gain * (float)(this.getHeight() - 25 - 57 - 3) / this.gainRange);
    }

    private float calcGain(int y) {
        return (float)(y - 25) * this.gainRange / (float)(this.getHeight() - 25 - 57 - 3);
    }

    private boolean isZoomBoxEmpty(Dimension zoomBoxSize) {
        if (null == zoomBoxSize) {
            return true;
        }
        return zoomBoxSize.getWidth() == 0.0 || zoomBoxSize.getHeight() == 0.0;
    }

    private void registerModule() {
        this.teOTDRGraphModuleMgr.registerModule("repeaterinfomodule", this);
    }

    @Override
    public void showRepeaterGainChart(String rptGainInfo) {
        this.createRptChart(rptGainInfo);
    }

    @Override
    public TEOTDRGraphInteractor getInteractor() {
        return this;
    }

    @Override
    public void destroy() {
        this.rptChart = null;
        this.leftAxis = null;
        this.timeAxis = null;
        this.zoomBoxStartP = null;
        this.zoomBoxSize = null;
        this.zoomBox = null;
    }
}

