/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class TEOTDRRepeaterChart
implements Shape {
    private static final int POINTRADIUS = 3;
    private GeneralPath chartPath;
    private Dimension viewSize;
    private String[] rptGains;
    private Point[] rptPoints;
    private int startPNum = -1;
    private int endPNum = -1;
    private float gainRange = 40.0f;
    private float maxGain = 40.0f;
    private float minGain = 0.0f;

    public TEOTDRRepeaterChart(Dimension viewSize) {
        this.viewSize = viewSize;
        this.chartPath = new GeneralPath();
    }

    public void createNewPath(String[] rptGains) {
        if (null == rptGains || 0 == rptGains.length) {
            return;
        }
        this.rptGains = rptGains;
        this.rptPoints = new Point[rptGains.length];
        float xStep = (float)this.viewSize.getWidth() / (float)rptGains.length;
        int len = rptGains.length;
        for (int i = 0; i < len; ++i) {
            int x = (int)(xStep * (float)i) + 40 + 5 + 1;
            int tempY = this.calcYPos(this.divGain(rptGains[i])) + 25;
            int y = this.divGain(rptGains[i]) == 0.0f ? tempY - 3 : tempY;
            this.rptPoints[i] = new Point(x, y);
        }
        this.startPNum = 0;
        this.endPNum = rptGains.length - 1;
        this.drawPath();
    }

    private float divGain(String rptInfo) {
        float gain = -1.0f;
        if (null == rptInfo || "".equals(rptInfo) || -1 == rptInfo.indexOf(",")) {
            return gain;
        }
        gain = Float.valueOf(rptInfo.substring(rptInfo.indexOf(",") + 1)).floatValue();
        if (gain > this.maxGain) {
            gain = this.maxGain;
        }
        return gain;
    }

    private String divDate(String rptInfo) {
        String date = "";
        if (null == rptInfo || "".equals(rptInfo) || -1 == rptInfo.indexOf(",")) {
            return date;
        }
        date = rptInfo.substring(0, rptInfo.indexOf(","));
        return date;
    }

    private int calcYPos(float gain) {
        return (int)((float)this.viewSize.height * (this.maxGain - gain) / this.gainRange);
    }

    public void drawPath() {
        if (null == this.rptPoints || 0 == this.rptPoints.length) {
            return;
        }
        this.chartPath.reset();
        this.chartPath.moveTo(this.rptPoints[0].getX(), this.rptPoints[0].getY());
        int len = this.rptPoints.length;
        for (int i = 1; i < len; ++i) {
            this.chartPath.lineTo(this.rptPoints[i].getX(), this.rptPoints[i].getY());
        }
    }

    public void drawDot(Graphics g) {
        if (null == this.rptPoints || 0 == this.rptPoints.length) {
            return;
        }
        int len = this.rptPoints.length;
        for (int i = 0; i < len; ++i) {
            g.fillOval(this.rptPoints[i].x, this.rptPoints[i].y, 3, 3);
            g.drawOval(this.rptPoints[i].x, this.rptPoints[i].y, 3, 3);
        }
    }

    public void zoomIn(Dimension size) {
        this.viewSize = size;
        this.createNewPath(this.rptGains);
    }

    public String[] getZoomInRptGains(Point startP, Point endP) {
        int[] pointNum = this.getZoomInPointNum(startP, endP);
        if (null == pointNum || 2 != pointNum.length) {
            return null;
        }
        String[] tempGains = new String[pointNum[1] - pointNum[0] + 1];
        System.arraycopy(this.rptGains, pointNum[0], tempGains, 0, pointNum[1] - pointNum[0] + 1);
        return tempGains;
    }

    private int[] getZoomInPointNum(Point startP, Point endP) {
        int startNum = -1;
        int endNum = -1;
        ArrayList<String> tempRptPoints = new ArrayList<String>();
        if (null == this.rptPoints || 0 == this.rptPoints.length || null == startP || null == endP) {
            return null;
        }
        int len = this.rptPoints.length;
        for (int i = 0; i < len; ++i) {
            if (this.rptPoints[i].x >= startP.x && this.rptPoints[i].x <= endP.x && this.rptPoints[i].y >= startP.y && this.rptPoints[i].y <= endP.y) {
                tempRptPoints.add(this.rptGains[i]);
            }
            if (this.rptPoints[i].x >= startP.x && startNum == -1) {
                startNum = i;
                continue;
            }
            if (this.rptPoints[i].x < endP.x) continue;
            endNum = i - 1;
            break;
        }
        if (startNum == -1 || null == tempRptPoints || 0 == tempRptPoints.size()) {
            return null;
        }
        if (endNum == -1) {
            endNum = startNum;
        }
        int[] pointNums = new int[]{startNum, endNum};
        return pointNums;
    }

    public String[] getRptGains() {
        return this.rptGains;
    }

    public void restore(Dimension size) {
        this.viewSize = size;
        this.createNewPath(this.rptGains);
    }

    public boolean containsPoint(Point p) {
        return this.getIndexOfPoint(this.rptPoints, p) != -1;
    }

    private int getIndexOfPoint(Point[] rptPoints, Point p) {
        if (null == rptPoints || null == p) {
            return -1;
        }
        int len = rptPoints.length;
        for (int i = 0; i < len; ++i) {
            if (rptPoints[i].x + 3 < p.x || rptPoints[i].x - 3 > p.x || rptPoints[i].y + 3 < p.y || rptPoints[i].y - 3 > p.y) continue;
            return i;
        }
        return -1;
    }

    public String getPointInfo(Point p) {
        int index = this.getIndexOfPoint(this.rptPoints, p);
        if (index < 0 || index > this.rptPoints.length) {
            return "";
        }
        return this.rptGains[index += this.startPNum];
    }

    @Override
    public boolean contains(Point2D p) {
        return this.chartPath.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.chartPath.contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.chartPath.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.chartPath.contains(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return this.chartPath.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.chartPath.getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.chartPath.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.chartPath.getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.chartPath.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.chartPath.intersects(x, y, w, h);
    }
}

