/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmDoubleTextField;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphToolUtil;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphGraphInterface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TEOTDRMaskInfoPanel
extends JPanel {
    private static final float MIN_GAP = 0.0f;
    private static final float MAX_GAP = 1.0f;
    private JLabel maskGapLabel;
    private JLabel firstBadPointLabel;
    private InmDoubleTextField maskGapText;
    private JLabel firstBadPointTxt;
    private JLabel gainUnitLabel;
    private Point startPoint;
    private int[] firstBadPointInfo = new int[2];
    private float maskGap = 0.1f;
    protected TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;

    public TEOTDRMaskInfoPanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, Point startPoint, int[] firstBadPointInfo) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.firstBadPointInfo = firstBadPointInfo;
        this.startPoint = startPoint;
        this.setLocation(startPoint);
        this.setSize(new Dimension(230, 50));
        this.setBackground(TEOTDRGraphicConstants.GAPCOLOR);
        this.initPanel();
        this.setOpaque(true);
    }

    private void initPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.anchor = 17;
        constraint.gridx = 0;
        constraint.gridy = 0;
        this.maskGapLabel = new JLabel(TEOTDRGraphToolUtil.getResString("maskgap"));
        this.add((Component)this.maskGapLabel, constraint);
        layout.setConstraints(this.maskGapLabel, constraint);
        constraint.gridx = 1;
        this.maskGapText = new InmDoubleTextField(0.0, 1.0, 1);
        this.maskGapText.setText(String.valueOf(this.maskGap));
        this.maskGapText.addActionListener(new TextActionList());
        this.maskGapText.addFocusListener(new TextLoseFocusListener());
        this.maskGapText.setPreferredSize(new Dimension(100, 15));
        this.add((Component)this.maskGapText, constraint);
        layout.setConstraints(this.maskGapText, constraint);
        constraint.gridx = 2;
        this.gainUnitLabel = new JLabel("dB");
        this.add((Component)this.gainUnitLabel, constraint);
        layout.setConstraints(this.gainUnitLabel, constraint);
        constraint.gridx = 0;
        constraint.gridy = 1;
        this.firstBadPointLabel = new JLabel(TEOTDRGraphToolUtil.getResString("fistbadpoint"));
        this.add((Component)this.firstBadPointLabel, constraint);
        layout.setConstraints(this.firstBadPointLabel, constraint);
        constraint.gridx = 1;
        constraint.gridwidth = 0;
        this.firstBadPointTxt = new JLabel();
        this.setFirstBadPointTxt();
        this.add((Component)this.firstBadPointTxt, constraint);
        layout.setConstraints(this.firstBadPointTxt, constraint);
    }

    private void setFirstBadPointTxt() {
        String badPointInfo = TEOTDRGraphToolUtil.getResString("ok");
        if (null != this.firstBadPointInfo && 2 == this.firstBadPointInfo.length) {
            badPointInfo = String.valueOf((float)this.firstBadPointInfo[0] / 1000.0f);
            badPointInfo = badPointInfo + "km;";
            badPointInfo = badPointInfo + String.valueOf((float)this.firstBadPointInfo[1] / 1000.0f) + "dB";
        }
        this.firstBadPointTxt.setText(badPointInfo);
    }

    public void setFirstBadPoint(int[] firstBadPoint) {
        this.firstBadPointInfo = firstBadPoint;
        this.setFirstBadPointTxt();
    }

    public void setMaskGapValue(float newGap) {
        this.maskGap = newGap;
        TEOTDRGraphGraphInterface ginf = this.teOTDRGraphModuleMgr.getGraphInteractor();
        if (null != ginf) {
            ginf.resetMaskGap();
        }
    }

    public float getMaskGap() {
        return this.maskGap;
    }

    public void reLocate(Point reStartPoint) {
        this.startPoint = reStartPoint;
        this.setLocation(this.startPoint);
    }

    class TextLoseFocusListener
    implements FocusListener {
        TextLoseFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String txt = ((JTextField)e.getSource()).getText();
            if (null == txt || "".equals(txt)) {
                return;
            }
            if (Float.valueOf(txt).floatValue() != TEOTDRMaskInfoPanel.this.maskGap) {
                TEOTDRMaskInfoPanel.this.maskGapText.setText(String.valueOf(TEOTDRMaskInfoPanel.this.maskGap));
            }
        }
    }

    class TextActionList
    implements ActionListener {
        TextActionList() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String txt = ((JTextField)e.getSource()).getText();
            if (null == txt || "".equals(txt)) {
                return;
            }
            TEOTDRMaskInfoPanel.this.setMaskGapValue(Float.valueOf(txt).floatValue());
        }
    }
}

