/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceReperterInfo;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventNotInitException;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendChangeGraphColorListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedListener;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartInterface;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartLeftAxis;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartRepeaterAxis;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRHistogram;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class TEOTDRHistogramCanvas
extends JPanel
implements TEOTDRChartInterface,
MouseMotionListener,
MouseListener {
    private Color backgroundColor = TEOTDRGraphicConstants.defaultBGColor;
    private static float MAXGAIN = 40.0f;
    private static float MINGAIN = 0.0f;
    private Map<String, TEOTDRHistogram> histogramMap;
    private List<String> openedFileList = new ArrayList<String>();
    private String selectedFileName = "";
    private TEOTDRChartLeftAxis leftAxis;
    private TEOTDRChartRepeaterAxis repeaterAxis;
    private JScrollPane parent;
    private Dimension parentSize;
    private Dimension size;
    private FileColorChangeListener fileColorChangeListener;
    private SelectFileListener selectFileListener;
    private boolean mouseEnter = false;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;

    public TEOTDRHistogramCanvas(TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
        this.setLayout(null);
        this.setBackground(this.backgroundColor);
        this.addEventListeners();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawHistogram(g);
    }

    private void addEventListeners() {
        this.fileColorChangeListener = new FileColorChangeListener();
        this.teOTDRGraphEventManager.addListener(this.fileColorChangeListener);
        this.selectFileListener = new SelectFileListener();
        this.teOTDRGraphEventManager.addListener(this.selectFileListener);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    private void repaintComponents() {
        this.removeAll();
        if (null != this.histogramMap && 0 != this.histogramMap.size()) {
            this.add(this.leftAxis);
            this.add(this.repeaterAxis);
        }
        this.repaint();
    }

    private void drawHistogram(Graphics g) {
        if (this.parent.getWidth() != this.parentSize.width || this.parent.getHeight() != this.parentSize.height) {
            this.parentPnlResize();
            return;
        }
        for (Map.Entry<String, TEOTDRHistogram> entry : this.histogramMap.entrySet()) {
            TEOTDRHistogram histogram = entry.getValue();
            histogram.setColor(this.teCommonUtil.getFileColor(entry.getKey()));
            if (entry.getKey().equals(this.selectedFileName)) {
                histogram.drawHistogram(g, true);
                continue;
            }
            histogram.drawHistogram(g, false);
        }
    }

    private void parentPnlResize() {
        if (null == this.histogramMap || 0 == this.histogramMap.size()) {
            return;
        }
        this.parentSize.setSize(this.parent.getSize());
        this.leftAxis.changeAxis(new Point(0, 0), this.getViewHeight(), this.getViewHeight());
        this.repeaterAxis.changeAxisRpt(this.getViewWidth(), this.getViewHeight());
        for (Map.Entry<String, TEOTDRHistogram> entry : this.histogramMap.entrySet()) {
            TEOTDRHistogram histogram = entry.getValue();
            histogram.resize(this.getViewHeight());
        }
        this.repaint();
    }

    @Override
    public void closeFiles(List<String> fileNameList) {
        if (null == fileNameList || 0 == fileNameList.size() || null == this.histogramMap || 0 == this.histogramMap.size()) {
            return;
        }
        int listLen = fileNameList.size();
        for (int i = 0; i < listLen; ++i) {
            String filename = fileNameList.get(i);
            if (!this.histogramMap.containsKey(filename)) continue;
            this.histogramMap.remove(filename);
            this.openedFileList.remove(filename);
        }
        if (!this.histogramMap.containsKey(this.selectedFileName)) {
            this.selectedFileName = "";
        }
        this.repaintComponents();
    }

    @Override
    public void colorChange(Color color) {
        if (null != color) {
            this.backgroundColor = color;
            this.setBackground(color);
        }
    }

    @Override
    public void openFile(int neid, String fileName) {
        String[] repeaterNames;
        float[] repeaterGains;
        Map<Integer, TEOTDRGraphTraceReperterInfo> repeaterInfoMap;
        if ("".equals(fileName) || null != this.histogramMap && this.histogramMap.containsKey(fileName)) {
            return;
        }
        TEOTDRGraphTraceInfo traceInfo = this.teCommonUtil.getTraceInfo(fileName);
        if (null == traceInfo) {
            return;
        }
        if (null == this.parent) {
            this.parent = (JScrollPane)((JViewport)this.getParent()).getParent();
        }
        if (null == (repeaterInfoMap = traceInfo.getTraceSpanInfo()) || repeaterInfoMap.size() <= 1) {
            repeaterGains = null;
            repeaterNames = null;
        } else {
            repeaterGains = new float[repeaterInfoMap.size() - 1];
            repeaterNames = new String[repeaterInfoMap.size() - 1];
            ArrayList<Integer> repeaterIdList = new ArrayList<Integer>(repeaterInfoMap.keySet());
            Collections.sort(repeaterIdList);
            int len = repeaterInfoMap.size();
            for (int i = 1; i < len; ++i) {
                int curID = (Integer)repeaterIdList.get(i);
                repeaterGains[i - 1] = repeaterInfoMap.get(curID).getRepeatorGain();
                if (i < 1) continue;
                repeaterNames[i - 1] = repeaterInfoMap.get(curID).getRepeaterName();
            }
        }
        int index = this.distributeIndex();
        float[] rangeData = new float[]{MAXGAIN, MINGAIN};
        if (null == this.histogramMap) {
            this.parentSize = new Dimension(this.parent.getWidth(), this.parent.getHeight());
            this.histogramMap = new HashMap<String, TEOTDRHistogram>();
            this.leftAxis = new TEOTDRChartLeftAxis(new Point(0, 0), this.getViewHeight(), this.getViewHeight(), rangeData);
            this.repeaterAxis = new TEOTDRChartRepeaterAxis(this.getViewWidth(), this.getViewHeight(), repeaterGains, repeaterNames);
            this.size = new Dimension(this.repeaterAxis.getWidth() + 40, this.getViewHeight());
            this.setPreferredSize(this.size);
        } else if (null != repeaterGains && repeaterGains.length > this.repeaterAxis.getRepeaterGainNum()) {
            this.repeaterAxis.changeAxisRpt(repeaterGains);
            this.size = new Dimension(this.repeaterAxis.getWidth() + 40, this.getViewHeight());
            this.setSize(this.size);
            this.setPreferredSize(this.size);
        }
        int canvasHeight = this.getViewHeight();
        TEOTDRHistogram histogram = new TEOTDRHistogram(repeaterGains, this.teCommonUtil.getFileColor(fileName), canvasHeight, index, rangeData);
        this.selectedFileName = fileName;
        this.openedFileList.add(fileName);
        this.histogramMap.put(fileName, histogram);
        this.repaintComponents();
    }

    private int getViewWidth() {
        return this.parent.getWidth() - 18;
    }

    private int getViewHeight() {
        return this.parent.getHeight() - 18;
    }

    private int distributeIndex() {
        String[] indexs = new String[3];
        if (null == this.histogramMap) {
            return 0;
        }
        for (Map.Entry<String, TEOTDRHistogram> entry : this.histogramMap.entrySet()) {
            indexs[entry.getValue().getIndex()] = entry.getKey();
        }
        int len = indexs.length;
        for (int i = 0; i < len; ++i) {
            if (null != indexs[i]) continue;
            return i;
        }
        return -1;
    }

    private void selectFile(String fileName) {
        if (null == fileName || "".equals(fileName)) {
            return;
        }
        this.selectedFileName = fileName;
        this.repaint();
    }

    @Override
    public void initOpenFiles(List<String> openedFileList) {
        this.openedFileList = new ArrayList<String>();
        List<String> fileNames = openedFileList;
        int len = fileNames.size();
        for (int i = 0; i < len; ++i) {
            this.openFile(0, fileNames.get(i));
        }
    }

    @Override
    public List<String> getOpenedFileNameList() {
        return this.openedFileList;
    }

    @Override
    public String getSelectedFileName() {
        return this.selectedFileName;
    }

    @Override
    public void dispose() {
        this.histogramMap = null;
        this.openedFileList = null;
        this.teOTDRGraphEventManager.removeListener(this.fileColorChangeListener);
        this.teOTDRGraphEventManager.removeListener(this.selectFileListener);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.mouseEnter) {
            return;
        }
        for (TEOTDRHistogram histogram : this.histogramMap.values()) {
            histogram.contains(e.getPoint());
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseEnter = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseEnter = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    class SelectFileListener
    extends TEOTDRGraphLegendMakeFileSelectedListener {
        SelectFileListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphLegendMakeFileSelectedEvent selectFileEvent = (TEOTDRGraphLegendMakeFileSelectedEvent)event;
            try {
                TEOTDRHistogramCanvas.this.selectFile(selectFileEvent.getFileName());
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRHistogramCanvas.SelectFileListener.handleEvent() fail!", e);
            }
        }
    }

    class FileColorChangeListener
    extends TEOTDRGraphLegendChangeGraphColorListener {
        FileColorChangeListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRHistogramCanvas.this.repaint();
        }
    }
}

