/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.text.DecimalFormat;

public class TEOTDRHistogram {
    private static final int GAINSTRING_BOTTOM_GAP = 3;
    private static final int GAINSTRING_LEFT_GAP = 1;
    private float[] repeaterInfos;
    private Color color;
    private int viewHeight;
    private int index;
    private int tipIndex = -1;
    private float maxGain = 20.0f;
    private Float minGain = Float.valueOf(-40.0f);
    private float gainRange = 60.0f;
    DecimalFormat doubleFormatter = new DecimalFormat("0.0");

    public TEOTDRHistogram(float[] repeaterInfos, Color color, int viewHeight, int index) {
        this.repeaterInfos = repeaterInfos;
        this.color = color;
        this.viewHeight = viewHeight;
        this.index = index;
    }

    public TEOTDRHistogram(float[] repeaterInfos, Color color, int viewHeight, int index, float[] rangeData) {
        this.repeaterInfos = repeaterInfos;
        this.color = color;
        this.viewHeight = viewHeight;
        this.index = index;
        if (null != rangeData && rangeData.length >= 2) {
            this.maxGain = rangeData[0];
            this.minGain = Float.valueOf(rangeData[1]);
            this.gainRange = this.maxGain - this.minGain.floatValue();
        }
    }

    public void drawHistogram(Graphics g, boolean isSelectedFile) {
        if (null == this.repeaterInfos || 0 == this.repeaterInfos.length) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.color);
        int len = this.repeaterInfos.length;
        for (int i = 0; i < len; ++i) {
            int x = 8 + this.index * 20 + this.index * 5 + i * 86 + 40 + 5;
            float tempGain = this.repeaterInfos[i];
            int y = this.calcY(tempGain);
            g2d.drawRect(x, y, 20, this.viewHeight - y);
            g2d.fillRect(x, y, 20, this.viewHeight - y);
            Float tempGainFloat = Float.valueOf(tempGain);
            if (!(isSelectedFile && tempGain > this.maxGain || i == this.tipIndex) && !tempGainFloat.equals(this.minGain)) continue;
            g2d.drawString(this.doubleFormatter.format(tempGain), x - 1, y - 3);
            g2d.setColor(this.color);
        }
    }

    public boolean contains(Point p) {
        boolean containsFlg = false;
        if (null == this.repeaterInfos) {
            this.tipIndex = -1;
            return false;
        }
        int len = this.repeaterInfos.length;
        for (int i = 0; i < len; ++i) {
            int x = 8 + this.index * 20 + this.index * 5 + i * 86 + 40 + 5;
            float tempGain = this.repeaterInfos[i];
            int y = this.calcY(tempGain);
            if (p.x <= x || p.x >= x + 20 || p.y <= y || p.y >= this.viewHeight - 25) continue;
            containsFlg = true;
            this.tipIndex = i;
            break;
        }
        if (!containsFlg) {
            this.tipIndex = -1;
        }
        return containsFlg;
    }

    private int calcY(float gain) {
        gain = gain > this.maxGain ? 0.0f : this.maxGain - gain;
        int y = (int)((float)(this.viewHeight - 50) * gain / this.gainRange) + 25;
        return y;
    }

    public float[] getRepeaterInfos() {
        return this.repeaterInfos;
    }

    public void setRepeaterInfos(float[] repeaterInfos) {
        this.repeaterInfos = repeaterInfos;
    }

    public void resize(int heigth) {
        this.viewHeight = heigth;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getViewHeight() {
        return this.viewHeight;
    }

    public void setViewHeight(int viewHeight) {
        this.viewHeight = viewHeight;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

