/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceDataPtsInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceReperterInfo;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRCurveChart;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRDataPoint;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class TEOTDRGraphToolUtil {
    private static final double LIGHT_SPEED = 2.99792458E8;
    private static TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance("res" + File.separator + "stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");

    private TEOTDRGraphToolUtil() {
    }

    public static TEOTDRDataPoint[] calculateDataPoint(TEOTDRGraphTraceInfo traceInfo) {
        return TEOTDRGraphToolUtil.calculateDataPoint(traceInfo.getTraceDataPtsInfo(), traceInfo);
    }

    public static TEOTDRDataPoint[] calculateDataPoint(List<TEOTDRCurveChart> curveList, String selectedFile) {
        TEOTDRCurveChart subtrahendCurve;
        TEOTDRCurveChart minuendCurve;
        String minuendFile;
        TEOTDRDataPoint[] dataPoints = null;
        if (null == curveList || 2 != curveList.size()) {
            return dataPoints;
        }
        String string = minuendFile = selectedFile.equals("") ? curveList.get(1).getChartName() : selectedFile;
        if (curveList.get(0).getChartName().equals(minuendFile)) {
            minuendCurve = curveList.get(0);
            subtrahendCurve = curveList.get(1);
        } else {
            minuendCurve = curveList.get(1);
            subtrahendCurve = curveList.get(0);
        }
        TEOTDRDataPoint[] minuendDp = minuendCurve.getDataPointArray();
        TEOTDRDataPoint[] subtrahendDp = subtrahendCurve.getDataPointArray();
        int loopCount = minuendDp.length > subtrahendDp.length ? subtrahendDp.length : minuendDp.length;
        dataPoints = new TEOTDRDataPoint[loopCount];
        for (int i = 0; i < loopCount; ++i) {
            dataPoints[i] = new TEOTDRDataPoint();
            dataPoints[i].setGain(minuendDp[i].getGain() - subtrahendDp[i].getGain());
            dataPoints[i].setPos(minuendDp[i].getPos());
        }
        return dataPoints;
    }

    private static TEOTDRDataPoint[] calculateDataPoint(TEOTDRGraphTraceDataPtsInfo traceDataInfo, TEOTDRGraphTraceInfo traceInfo) {
        if (null == traceInfo || null == traceDataInfo || 0 == traceDataInfo.getDptsCount()) {
            return null;
        }
        Map<Integer, TEOTDRGraphTraceReperterInfo> spanInfoMap = traceInfo.getTraceSpanInfo();
        if (null == spanInfoMap || 0 == spanInfoMap.size()) {
            return null;
        }
        float sampleRate = traceInfo.getTraceParamsInfo().getSampleRate();
        double transfertime = 1.0 / ((double)sampleRate * Math.pow(10.0, 6.0)) / 2.0;
        int spanNum = spanInfoMap.size();
        TEOTDRDataPoint[] dataPoints = new TEOTDRDataPoint[traceDataInfo.getDptsCount()];
        ArrayList<Integer> spanInfoKeyList = new ArrayList<Integer>(spanInfoMap.keySet());
        Collections.sort(spanInfoKeyList);
        int spanId = 0;
        TEOTDRGraphTraceReperterInfo tmpSpanInfo = spanInfoMap.get(spanInfoKeyList.get(spanId));
        float refractiveIndex = null != tmpSpanInfo ? tmpSpanInfo.getRefractiveIndex() : 0.0f;
        int repeaterLocation = (int)((null != tmpSpanInfo ? tmpSpanInfo.getRepeaterLocation() : traceInfo.getTraceParamsInfo().getMeasureRangeDistance()) * 1000.0f);
        tmpSpanInfo = ++spanId < spanNum ? spanInfoMap.get(spanInfoKeyList.get(spanId)) : null;
        int nextRepeaterDataIndex = null != tmpSpanInfo ? (int)((double)tmpSpanInfo.getRepeatorTransfertime() * 1.0E-10 / transfertime) : traceDataInfo.getDptsCount() - 1;
        int preRepeaterDataInde = 0;
        int len = traceDataInfo.getDptsCount();
        for (int i = 0; i < len; ++i) {
            TEOTDRDataPoint tmpPoint = new TEOTDRDataPoint();
            tmpPoint.setGain((float)((double)traceDataInfo.getDptsArray()[i] * 1.0E-6));
            if (i > nextRepeaterDataIndex) {
                refractiveIndex = null != tmpSpanInfo ? tmpSpanInfo.getRefractiveIndex() : 0.0f;
                repeaterLocation = (int)((null != tmpSpanInfo ? tmpSpanInfo.getRepeaterLocation() : traceInfo.getTraceParamsInfo().getMeasureRangeDistance()) * 1000.0f);
                tmpSpanInfo = ++spanId < spanNum ? spanInfoMap.get(spanInfoKeyList.get(spanId)) : null;
                preRepeaterDataInde = nextRepeaterDataIndex;
                nextRepeaterDataIndex = null != tmpSpanInfo && 0L != tmpSpanInfo.getRepeatorTransfertime() ? (int)((double)tmpSpanInfo.getRepeatorTransfertime() * 1.0E-10 / transfertime) : traceDataInfo.getDptsCount() - 1;
            }
            tmpPoint.setPos((int)((double)(i - preRepeaterDataInde) * transfertime * 2.99792458E8 / (double)refractiveIndex + (double)repeaterLocation));
            dataPoints[i] = tmpPoint;
        }
        return dataPoints;
    }

    public static boolean compareConfigInfo(List<String> openedFileList, TEOTDRGraphTraceInfo firstTraceInfo, TEOTDRGraphTraceInfo secondTraceInfo) {
        if (null == openedFileList || 2 != openedFileList.size()) {
            return false;
        }
        if (null == firstTraceInfo || null == secondTraceInfo) {
            return false;
        }
        if (firstTraceInfo.getTraceParamsInfo().getPulseWidthsUsed() != secondTraceInfo.getTraceParamsInfo().getPulseWidthsUsed()) {
            return false;
        }
        Map<Integer, TEOTDRGraphTraceReperterInfo> firstSpanInfo = firstTraceInfo.getTraceSpanInfo();
        Map<Integer, TEOTDRGraphTraceReperterInfo> secondSpanInfo = secondTraceInfo.getTraceSpanInfo();
        ArrayList<Integer> firstSpanIDList = new ArrayList<Integer>(firstSpanInfo.keySet());
        Collections.sort(firstSpanIDList);
        ArrayList<Integer> secondSpanIDList = new ArrayList<Integer>(secondSpanInfo.keySet());
        Collections.sort(secondSpanIDList);
        int len = firstSpanIDList.size() <= secondSpanIDList.size() ? firstSpanIDList.size() : secondSpanIDList.size();
        for (int i = 0; i < len; ++i) {
            TEOTDRGraphTraceReperterInfo tmpFirstSpan = firstSpanInfo.get(firstSpanIDList.get(i));
            TEOTDRGraphTraceReperterInfo tmpSecondSpan = secondSpanInfo.get(secondSpanIDList.get(i));
            if (tmpFirstSpan.getRefractiveIndex() == tmpSecondSpan.getRefractiveIndex()) continue;
            return false;
        }
        return true;
    }

    public static String getResString(String resName) {
        return resUtil.getString(resName);
    }

    public static void showMessage(JComponent component, String message) {
        InmOptionPane.showMessageDialog(component, resUtil.getString(message));
    }

    public static void log(String logString) {
        System.out.println(logString);
    }
}

