/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventNotInitException;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphToolbarChgGraphBgColorEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphToolbarChgGraphBgColorListener;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartInterface;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRCursorInfoPanel;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRCurveCanvas;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TEOTDRGraphShowPanel
extends JPanel {
    TEOTDRChartInterface chart;
    JPanel cursorInfoPanel;
    JScrollPane scrollPane;
    protected TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;

    public TEOTDRGraphShowPanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.setDefualtBackGroundColor();
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
    }

    private void setDefualtBackGroundColor() {
        this.setBackground(TEOTDRGraphicConstants.defaultBGColor);
    }

    public void colorChange(Color color) {
        if (null == color) {
            return;
        }
        this.setBackground(color);
        if (null != this.chart) {
            this.chart.colorChange(color);
        }
    }

    public void openFile(int neid, String fileName) {
        if (null == this.chart) {
            this.chart = new TEOTDRCurveCanvas(false);
            this.scrollPane = new JScrollPane(22, 32);
            this.scrollPane.getViewport().add((JPanel)((Object)this.chart));
            this.add((Component)this.scrollPane, "Center");
            this.cursorInfoPanel = new TEOTDRCursorInfoPanel(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager);
            this.add((Component)this.cursorInfoPanel, "South");
            this.validate();
            this.repaint();
        }
        this.chart.openFile(neid, fileName);
        if (null == this.chart.getOpenedFileNameList() || 0 == this.chart.getOpenedFileNameList().size()) {
            this.chart = null;
            this.removeAll();
        }
        this.revalidate();
    }

    public void closeFiles(String fileName) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        fileNameList.add(fileName);
        this.chart.closeFiles(fileNameList);
        if (null == this.chart.getOpenedFileNameList() || 0 == this.chart.getOpenedFileNameList().size()) {
            this.chart = null;
            this.removeAll();
        }
    }

    public Map<String, int[]> getCurrentGraphMoveData() {
        return ((TEOTDRCurveCanvas)this.chart).getCurrentGraphMoveData();
    }

    class BGColorChangeListener
    extends TEOTDRGraphToolbarChgGraphBgColorListener {
        BGColorChangeListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphToolbarChgGraphBgColorEvent bgColorChgEvent = (TEOTDRGraphToolbarChgGraphBgColorEvent)event;
            try {
                TEOTDRGraphShowPanel.this.colorChange(bgColorChgEvent.getColor());
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRGraphShowPanel.BGColorChangeListener.handleEvent() fail!", e);
            }
        }
    }

    class OpenFileListener
    extends TEOTDRGraphFileTreeFileOpenedListener {
        OpenFileListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphFileTreeFileOpenedEvent openFileEvent = (TEOTDRGraphFileTreeFileOpenedEvent)event;
            try {
                TEOTDRGraphShowPanel.this.openFile(openFileEvent.getNeID(), openFileEvent.getFileName());
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRGraphShowPanel.OpenFileListener.handleEvent() fail!", e);
            }
        }
    }
}

