/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventNotInitException;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphCurveStatusChangeEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileClosedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileClosedListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphToolbarChgGraphBgColorEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphToolbarChgGraphBgColorListener;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartInterface;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRCursorInfoPanel;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRCurveCanvas;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphGraphInteractor;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphToolUtil;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRHistogramCanvas;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModule;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphGraphInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TEOTDRGraphPanel
extends JPanel
implements TEOTDRGraphModule {
    private TEOTDRChartInterface chart;
    private String testMode = "";
    private TEOTDRCursorInfoPanel cursorInfoPanel;
    private JScrollPane scrollPane;
    private OpenFileListener openFileListener;
    private CloseFileListener closeFileListener;
    private LegendCloseFile legendCloseListener;
    private DeleteFileListener deleteFileListener;
    protected TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;

    public TEOTDRGraphPanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
        this.initPanel();
        this.registerModule();
        this.registerEventListener();
    }

    private void initPanel() {
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.setDefualtBackGroundColor();
    }

    private void registerModule() {
        this.teOTDRGraphModuleMgr.registerModule("graphmodule", this);
    }

    private void registerEventListener() {
        this.openFileListener = new OpenFileListener();
        this.teOTDRGraphEventManager.addListener(this.openFileListener);
        this.closeFileListener = new CloseFileListener();
        this.teOTDRGraphEventManager.addListener(this.closeFileListener);
        this.legendCloseListener = new LegendCloseFile();
        this.teOTDRGraphEventManager.addListener(this.legendCloseListener);
        this.deleteFileListener = new DeleteFileListener();
        this.teOTDRGraphEventManager.addListener(this.deleteFileListener);
    }

    private void setDefualtBackGroundColor() {
        this.setBackground(TEOTDRGraphicConstants.defaultBGColor);
    }

    public void colorChange(Color color) {
        if (null == color) {
            return;
        }
        this.setBackground(color);
        if (null != this.chart) {
            this.chart.colorChange(color);
        }
    }

    public void openFile(int neid, String fileName) {
        if (null == fileName || "".equals(fileName)) {
            return;
        }
        String mode = this.teCommonUtil.getParamFromFileName(fileName, "testMode");
        if (null == mode || "".equals(mode)) {
            return;
        }
        if (null == this.chart) {
            if ("1".equals(mode)) {
                this.addChartComponent("1");
            } else {
                this.addChartComponent("2");
            }
            this.chart.colorChange(this.getBackground());
        }
        this.chart.openFile(neid, fileName);
        if (null == this.chart.getOpenedFileNameList() || 0 == this.chart.getOpenedFileNameList().size()) {
            this.removeAllChartComponent();
        }
        this.treggerCurveChangeEvent();
    }

    public void closeFiles(List<String> fileNameList) {
        if (null == this.chart) {
            return;
        }
        this.chart.closeFiles(fileNameList);
        if (null == this.chart.getOpenedFileNameList() || 0 == this.chart.getOpenedFileNameList().size()) {
            this.removeAllChartComponent();
            this.repaint();
        }
        this.treggerCurveChangeEvent();
    }

    public void changeGraphType() {
        if (this.testMode.equals("")) {
            return;
        }
        ArrayList<String> openedFileList = new ArrayList<String>();
        if (null != this.chart) {
            openedFileList.addAll(this.chart.getOpenedFileNameList());
        }
        if (this.testMode.equals("1")) {
            this.addChartComponent("2");
        } else {
            this.addChartComponent("1");
        }
        if (0 != openedFileList.size()) {
            this.chart.initOpenFiles(openedFileList);
        }
        this.chart.colorChange(this.getBackground());
        this.treggerCurveChangeEvent();
    }

    private void addChartComponent(String mode) {
        this.removeAllChartComponent();
        if ("1".equals(mode)) {
            this.chart = new TEOTDRHistogramCanvas(this.teOTDRGraphEventManager, this.teCommonUtil);
            this.testMode = "1";
        } else {
            this.chart = new TEOTDRCurveCanvas(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager, this.teCommonUtil);
            JScrollPane bottomScrollPane = new JScrollPane();
            this.cursorInfoPanel = new TEOTDRCursorInfoPanel(this.teOTDRGraphModuleMgr, this.teOTDRGraphEventManager);
            bottomScrollPane.getViewport().add(this.cursorInfoPanel);
            this.add((Component)bottomScrollPane, "South");
            this.testMode = "2";
        }
        this.scrollPane = new JScrollPane(22, 32);
        this.scrollPane.getViewport().add((JPanel)((Object)this.chart));
        this.add((Component)this.scrollPane, "Center");
        this.validate();
        this.repaint();
    }

    private void removeAllChartComponent() {
        this.removeAll();
        if (null != this.chart) {
            this.chart.dispose();
        }
        this.chart = null;
        this.testMode = "";
        if (null != this.cursorInfoPanel) {
            this.cursorInfoPanel.dispose();
        }
        this.cursorInfoPanel = null;
    }

    public void doCoverAtAPole() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).doCoverAtAPole();
    }

    public void doCoverAtBPole() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).doCoverAtBPole();
    }

    public void addMask() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).addMask();
    }

    public void undoMask() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).removeMask();
    }

    public void resetMaskGap() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).resetMaskGap();
    }

    public void doMove(Map<String, int[]> moveData) {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).doMove(moveData);
    }

    public void doRestoreGraph() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).restore();
    }

    public void doZoom(int[] zdata) {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).doZoom(zdata);
    }

    public void zoomOut() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).zoomOut();
    }

    public Map<String, int[]> getCurrentGraphMoveData() {
        if (this.testMode != "2") {
            return null;
        }
        return ((TEOTDRCurveCanvas)this.chart).getCurrentGraphMoveData();
    }

    public List<String> getOpenedFileNameList() {
        if (null == this.chart) {
            return null;
        }
        return this.chart.getOpenedFileNameList();
    }

    public void bindingCursor() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).bindingCursor();
    }

    public void locateEvent(boolean isNextEvent) {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).locateEvent(isNextEvent);
    }

    public void doStartPartZoom() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).startZoomIn();
    }

    public void doStopPartZoom() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).stopZoomIn();
    }

    public void setCursorPos(String curSorStr, int pos) {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).setCursorPos(curSorStr, pos);
    }

    public void unBindingCursor() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).unBindingCursor();
    }

    public int getCurrentLineRange() {
        if (null == this.chart || "1".equals(this.testMode)) {
            return 0;
        }
        return ((TEOTDRCurveCanvas)this.chart).getCurrentMaxLineLength();
    }

    public void doCompareCurve() {
        if (null == this.chart || "1".equals(this.testMode)) {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).createCompareCurve();
    }

    public float[] getZoomRate() {
        if (null == this.chart || "1".equals(this.testMode)) {
            return null;
        }
        return ((TEOTDRCurveCanvas)this.chart).getZoomRate();
    }

    public String getCurrentViewMode() {
        return this.testMode;
    }

    public boolean isCompareNow() {
        if (this.testMode != "2") {
            return false;
        }
        return ((TEOTDRCurveCanvas)this.chart).isCompareNow();
    }

    public void restoreBgColor() {
        this.setBackground(TEOTDRGraphicConstants.defaultBGColor);
        if (null != this.chart) {
            this.chart.colorChange(TEOTDRGraphicConstants.defaultBGColor);
        }
    }

    public void undoCompareCurve() {
        if (this.testMode != "2") {
            return;
        }
        ((TEOTDRCurveCanvas)this.chart).undoCompareCurve();
    }

    public String getSelectedFileName() {
        String selectedFileName = this.chart.getSelectedFileName();
        return null == selectedFileName ? "" : selectedFileName;
    }

    public Map<String, Color> getFileColors() {
        if (null == this.chart) {
            return null;
        }
        HashMap<String, Color> fileColros = new HashMap<String, Color>();
        List<String> fileNames = this.chart.getOpenedFileNameList();
        int len = fileNames.size();
        for (int i = 0; i < len; ++i) {
            String filename = fileNames.get(i);
            fileColros.put(filename, this.teCommonUtil.getFileColor(filename));
        }
        return fileColros;
    }

    public boolean canShowMask() {
        if (null == this.chart || this.testMode != "2") {
            return false;
        }
        return ((TEOTDRCurveCanvas)this.chart).canShowMask();
    }

    @Override
    public TEOTDRGraphGraphInterface getInteractor() {
        return new TEOTDRGraphGraphInteractor(this);
    }

    private void treggerCurveChangeEvent() {
        TEOTDRGraphGraphCurveStatusChangeEvent event = TEOTDRGraphGraphCurveStatusChangeEvent.getEvent();
        this.teOTDRGraphEventManager.triggerEvent(event);
        TEOTDRGraphToolUtil.log("Graph tregger TEOTDRGraphGraphOpenedFileChangeListener!");
    }

    private void writeLog(String logInfo) {
        System.out.println(logInfo);
    }

    @Override
    public void destroy() {
        this.teOTDRGraphEventManager.removeListener(this.openFileListener);
        this.teOTDRGraphEventManager.removeListener(this.closeFileListener);
        this.teOTDRGraphEventManager.removeListener(this.legendCloseListener);
        this.teOTDRGraphEventManager.removeListener(this.deleteFileListener);
        this.removeAllChartComponent();
    }

    class BGColorChangeListener
    extends TEOTDRGraphToolbarChgGraphBgColorListener {
        BGColorChangeListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphToolbarChgGraphBgColorEvent bgColorChgEvent = (TEOTDRGraphToolbarChgGraphBgColorEvent)event;
            try {
                TEOTDRGraphPanel.this.colorChange(bgColorChgEvent.getColor());
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRGraphPanel.BGColorChangeListener.handleEvent() fail!", e);
            }
        }
    }

    class DeleteFileListener
    extends TEOTDRGraphFileTreeFileDeletedListener {
        DeleteFileListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphFileTreeFileDeletedEvent deleteFileEvent = (TEOTDRGraphFileTreeFileDeletedEvent)event;
            try {
                TEOTDRGraphPanel.this.closeFiles(deleteFileEvent.getFileNameList());
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRGraphPanel.DeleteFileListener.handleEvent() fail!", e);
            }
        }
    }

    class LegendCloseFile
    extends TEOTDRGraphLegendMakeFileClosedListener {
        LegendCloseFile() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphLegendMakeFileClosedEvent closeSingleFileEvent = (TEOTDRGraphLegendMakeFileClosedEvent)event;
            ArrayList<String> fileNameList = new ArrayList<String>();
            try {
                fileNameList.add(closeSingleFileEvent.getFileName());
                TEOTDRGraphPanel.this.closeFiles(fileNameList);
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRGraphPanel.LegendCloseFile.handleEvent() fail!", e);
            }
        }
    }

    class CloseFileListener
    extends TEOTDRGraphFileTreeFileClosedListener {
        CloseFileListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphFileTreeFileClosedEvent closeFileEvent = (TEOTDRGraphFileTreeFileClosedEvent)event;
            try {
                ArrayList<String> fileNameList = new ArrayList<String>();
                fileNameList.add(closeFileEvent.getFileName());
                TEOTDRGraphPanel.this.closeFiles(fileNameList);
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRGraphPanel.CloseFileListener.handleEvent() fail!", e);
            }
        }
    }

    class OpenFileListener
    extends TEOTDRGraphFileTreeFileOpenedListener {
        OpenFileListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphFileTreeFileOpenedEvent openFileEvent = (TEOTDRGraphFileTreeFileOpenedEvent)event;
            try {
                TEOTDRGraphPanel.this.openFile(openFileEvent.getNeID(), openFileEvent.getFileName());
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRGraphPanel.OpenFileListener.handleEvent() fail!", e);
            }
        }
    }
}

