/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TEOTDRCurveMask
implements Shape {
    private GeneralPath maskPath;
    private Point[] recPoints = new Point[4];
    private Point[] points;
    private Point firstBadPoint = null;
    private float offset;

    public TEOTDRCurveMask(Point[] points, float offset) {
        this.maskPath = new GeneralPath();
        this.offset = offset;
        this.calcLinearityData(points);
        this.drawPath();
    }

    private void calcLinearityData(Point[] points) {
        if (null == points || points.length < 2) {
            return;
        }
        this.points = points;
        float argX = 0.0f;
        float argY = 0.0f;
        int pointNum = points.length;
        for (int i = 1; i < pointNum; ++i) {
            argX += (float)points[i].x;
            argY += (float)points[i].y;
        }
        argX /= (float)(pointNum - 1);
        argY /= (float)(pointNum - 1);
        float tempDividend = 0.0f;
        float tempDivisor = 0.0f;
        for (int i = 1; i < pointNum; ++i) {
            tempDividend += ((float)points[i].x - argX) * ((float)points[i].y - argY);
            if (i > pointNum - 1) continue;
            tempDivisor += ((float)points[i].x - argX) * ((float)points[i].x - argX);
        }
        float slope = tempDividend / tempDivisor;
        float offsetup = argY - slope * argX + this.offset;
        this.recPoints[0] = new Point(points[1].x, (int)(slope * (float)points[1].x + offsetup));
        this.recPoints[1] = new Point(points[pointNum - 1].x, (int)(slope * (float)points[pointNum - 1].x + offsetup));
        this.recPoints[2] = new Point(this.recPoints[0].x, (int)((float)this.recPoints[0].y - 2.0f * this.offset));
        this.recPoints[3] = new Point(this.recPoints[1].x, (int)((float)this.recPoints[1].y - 2.0f * this.offset));
        this.findFirstBadPoint(slope, offsetup, points, this.offset);
    }

    private void findFirstBadPoint(float slope, float offsetup, Point[] points, float offset) {
        this.firstBadPoint = null;
        for (int i = 1; i < points.length; ++i) {
            float tempUp = slope * (float)points[i].x + offsetup;
            float tempDown = tempUp - 2.0f * offset;
            if (!((float)points[i].y > tempUp) && !((float)points[i].y < tempDown)) continue;
            this.firstBadPoint = points[i];
            break;
        }
    }

    public void drawPath() {
        this.maskPath.reset();
        if (null == this.recPoints) {
            return;
        }
        this.maskPath.moveTo(this.recPoints[0].getX(), this.recPoints[0].getY());
        this.maskPath.lineTo(this.recPoints[1].getX(), this.recPoints[1].getY());
        this.maskPath.moveTo(this.recPoints[2].getX(), this.recPoints[2].getY());
        this.maskPath.lineTo(this.recPoints[3].getX(), this.recPoints[3].getY());
    }

    public void zoom(float[] ZoomMultiple) {
        float xZoomMultiple = ZoomMultiple[0];
        float yZoomMultiple = ZoomMultiple[1];
        for (int i = 0; i < this.recPoints.length; ++i) {
            this.recPoints[i].x = (int)((float)(this.recPoints[i].x - 45) * xZoomMultiple + 45.0f);
            this.recPoints[i].y = (int)((float)(this.recPoints[i].y - 25) * yZoomMultiple + 25.0f);
        }
        this.drawPath();
    }

    public void zoom(Point[] points, float offset) {
        if (null != points && points.length > 2) {
            this.offset = offset;
            this.calcLinearityData(points);
            this.drawPath();
            return;
        }
        float dif = offset - offset;
        this.recPoints[0].y = (int)((float)this.recPoints[0].y + dif);
        this.recPoints[1].y = (int)((float)this.recPoints[1].y + dif);
        this.recPoints[2].y = (int)((float)this.recPoints[2].y - dif);
        this.recPoints[3].y = (int)((float)this.recPoints[3].y - dif);
        this.offset = offset;
        this.drawPath();
    }

    private boolean canBeReset(Point[] points) {
        return this.recPoints[0].x >= points[0].x && this.recPoints[1].x <= points[points.length - 1].x;
    }

    public Point getFirstBadPoint() {
        return this.firstBadPoint;
    }

    public Color getColor() {
        if (null == this.firstBadPoint) {
            return Color.GREEN;
        }
        return Color.RED;
    }

    public void resetMaskGap(float newOffset, Point[] points) {
        if (null != points && points.length > 1) {
            this.offset = newOffset;
            this.calcLinearityData(points);
            this.drawPath();
            return;
        }
        float dif = newOffset - this.offset;
        this.recPoints[0].y = (int)((float)this.recPoints[0].y + dif);
        this.recPoints[1].y = (int)((float)this.recPoints[1].y + dif);
        this.recPoints[2].y = (int)((float)this.recPoints[2].y - dif);
        this.recPoints[3].y = (int)((float)this.recPoints[3].y - dif);
        this.offset = newOffset;
        this.drawPath();
    }

    public int getStartPos() {
        if (null == this.points || 0 == this.points.length) {
            return 0;
        }
        return this.points[0].x;
    }

    public int getEndPos() {
        if (null == this.points || 0 == this.points.length) {
            return 0;
        }
        return this.points[0].y;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.maskPath.contains(x, y, w, h);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.maskPath.contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.maskPath.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.maskPath.contains(r);
    }

    @Override
    public Rectangle getBounds() {
        return this.maskPath.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.maskPath.getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.maskPath.getPathIterator(at, flatness);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.maskPath.getPathIterator(at);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.maskPath.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.maskPath.intersects(r);
    }
}

