/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;

public class TEOTDRCurveCursor {
    private static final int WIDTH = 2;
    private static final int CURSORSTR_TOP_GAP = 3;
    private static final int CURSORSTR_LEFT_GAP = 3;
    private static final int CURSOR_GAP = 16;
    private Point startPoint;
    private int height;
    private String cursorName = "";
    private int offset;
    private int cursorPos = 0;

    public TEOTDRCurveCursor(String cursorName, int height, int offset) {
        this.cursorName = cursorName;
        this.height = height;
        this.offset = offset;
        this.setDefaultStartPoint(offset);
    }

    public void setDefaultStartPoint(int offset) {
        this.startPoint = new Point(56 + offset, 25);
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setXORMode(TEOTDRGraphicConstants.defaultBGColor);
        float[] dashArray = new float[]{20.0f, 5.0f};
        BasicStroke stroke = new BasicStroke(2.0f, 0, 2, 0.0f, dashArray, 0.0f);
        g2.setStroke(stroke);
        g2.setColor(Color.BLACK);
        g2.drawLine(this.startPoint.x, this.startPoint.y, this.startPoint.x, this.startPoint.y + this.height);
        int strX = this.startPoint.x + 3;
        int strY = this.startPoint.y + 25 + 3;
        g2.drawString(this.cursorName, strX, strY);
        stroke = new BasicStroke();
        g2.setStroke(stroke);
        g2.setPaintMode();
    }

    public void move(Point moveTo, Graphics g) {
        Point newPoint;
        this.startPoint = newPoint = new Point(moveTo.x, this.startPoint.y);
        this.draw(g);
    }

    public void resize(int height, Graphics g) {
        this.height = height;
        this.draw(g);
    }

    public void reset(int height, int x, int viewStartPointY) {
        this.startPoint.x = x;
        this.startPoint.y = viewStartPointY + 25;
        this.height = height;
    }

    public void recoverDefaultPosition(Graphics g) {
        this.setDefaultStartPoint(this.offset);
        this.draw(g);
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(Point point) {
        this.startPoint = point;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int heigth) {
        this.height = heigth;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    public void setCursorPos(int cursorPos) {
        this.cursorPos = cursorPos;
    }
}

