/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRCurveUsefulInfo;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRDataPoint;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class TEOTDRCurveChart
implements Shape {
    private static final int MAXPOINTNUM = 30000;
    private String chartName;
    private TEOTDRDataPoint[] dataPointArray = null;
    private Point[] pointCollection;
    private GeneralPath curvePath;
    private float dBOffset = 0.0f;
    private int lengthOffset = 0;
    private int viewAxisLen;
    private String unit;
    private boolean needCutPoints = false;
    private int width;
    private int height;
    private int lineLength;

    public float[] getDptsArray() {
        if (null == this.dataPointArray || 0 == this.dataPointArray.length) {
            return null;
        }
        float[] dptsArray = new float[this.dataPointArray.length];
        int len = this.dataPointArray.length;
        for (int i = 0; i < len; ++i) {
            dptsArray[i] = this.dataPointArray[i].getGain();
        }
        return dptsArray;
    }

    public TEOTDRCurveChart(String chartName, TEOTDRCurveUsefulInfo usefulInfo) {
        this.chartName = chartName;
        this.initParams(usefulInfo);
        this.setPointArray();
        this.curvePath = new GeneralPath();
    }

    private void initParams(TEOTDRCurveUsefulInfo usefulInfo) {
        this.width = usefulInfo.getCanvasWidth();
        this.height = usefulInfo.getCanvasHeight();
        this.dBOffset = usefulInfo.getDBOffset();
        this.viewAxisLen = usefulInfo.getViewAxisLength();
        this.unit = usefulInfo.getUnit();
        this.dataPointArray = usefulInfo.getDataPoints();
    }

    private void setPointArray() {
        if (null == this.dataPointArray || 0 == this.dataPointArray.length || 0 == this.width) {
            return;
        }
        int dBOffsetLength = this.calcDBWidth(this.dBOffset);
        int lengthOffsetLength = this.calcLengthWidth(this.lengthOffset);
        int dataNum = this.dataPointArray.length;
        this.pointCollection = new Point[dataNum];
        for (int i = 0; i < dataNum; ++i) {
            int x = (int)((double)this.dataPointArray[i].getPos() * (double)this.width / (double)this.viewAxisLen) + 45 + lengthOffsetLength;
            int y = (int)((double)(20.0f - this.dataPointArray[i].getGain()) * (double)this.height / 60.0) - dBOffsetLength + 25;
            this.pointCollection[i] = new Point(x, y);
        }
    }

    public void adjustWidth(int viewAxisLength) {
        this.viewAxisLen = viewAxisLength;
        this.setPointArray();
    }

    public String getChartName() {
        return this.chartName;
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public Point[] getPointCollection() {
        return this.pointCollection;
    }

    public GeneralPath getCurvePath() {
        return this.curvePath;
    }

    public void drawCurvePath(int xleft, int xright, int ytop, int ybottom) {
        Point prep;
        if (null == this.pointCollection || 0 == this.pointCollection.length) {
            return;
        }
        this.curvePath.reset();
        Point preShowp = null;
        Point p = prep = this.pointCollection[0];
        int x0 = p.x;
        int y0 = p.y;
        boolean preshow = x0 >= xleft && x0 <= xright && y0 >= ytop && y0 <= ybottom;
        boolean first = false;
        if (preshow) {
            first = true;
            this.curvePath.moveTo(p.x, p.y);
        }
        int pointcounter = 0;
        int pointCount = this.pointCollection.length;
        for (int i = 1; i < pointCount; ++i) {
            boolean show;
            p = this.pointCollection[i];
            if (this.needCutPoints && pointCount > 30000 && i % 20 != 0) continue;
            if (null != preShowp && preShowp.equals(p)) {
                prep = p;
                preshow = true;
                continue;
            }
            int x = p.x;
            int y = p.y;
            boolean bl = show = x >= xleft && x <= xright && y >= ytop && y <= ybottom;
            if (show) {
                preShowp = p;
            }
            if (preshow && show) {
                this.curvePath.lineTo((double)x, (double)y);
                if (!first) {
                    first = true;
                }
            }
            if (preshow && !show) {
                this.drawEdgePointLine(prep.x, prep.y, x, y, xleft, xright, ytop, ybottom);
            }
            if (show && !preshow) {
                this.drawEdgePointLine(x, y, prep.x, prep.y, xleft, xright, ytop, ybottom);
                if (!first) {
                    first = true;
                }
                this.curvePath.moveTo(x, y);
            }
            ++pointcounter;
            preshow = show;
            prep = p;
        }
        System.out.println("Draw point number---->" + pointcounter);
    }

    private void drawEdgePointLine(int showx, int showy, int hidex, int hidey, int xleft, int xright, int ytop, int ybottom) {
        int crossx = -1;
        int crossy = -1;
        if (showy == hidey) {
            if (hidex <= xleft) {
                crossx = xleft;
            } else if (hidex >= xright) {
                crossx = xright;
            }
            crossy = showy;
            this.curvePath.moveTo(showx, showy);
            this.curvePath.lineTo(crossx, crossy);
            return;
        }
        if (showx == hidex) {
            if (hidey <= ytop) {
                crossy = ytop;
            } else if (hidey >= ybottom) {
                crossy = ybottom;
            }
            crossx = showx;
        } else {
            int ty4;
            int tx4;
            int ty3;
            int tx3;
            int tx2;
            int ty2;
            int tx1;
            boolean canbreak = false;
            float k = (float)(hidey - showy) / (float)(hidex - showx);
            k = k == 0.0f ? 1.0f : k;
            int ty1 = (int)(k * (float)((tx1 = xleft) - showx) + (float)showy);
            if (ty1 >= ytop && ty1 <= ybottom) {
                crossx = tx1;
                crossy = ty1;
                canbreak = this.isRightPoint(showx, showy, hidex, hidey, crossx, crossy);
            }
            if (!canbreak && (ty2 = (int)(k * (float)((tx2 = xright) - showx) + (float)showy)) >= ytop && ty2 <= ybottom) {
                crossx = tx2;
                crossy = ty2;
                canbreak = this.isRightPoint(showx, showy, hidex, hidey, crossx, crossy);
            }
            if (!canbreak && (tx3 = (int)((float)((ty3 = ytop) - showy) / k + (float)showx)) >= xleft && tx3 <= xright) {
                crossx = tx3;
                crossy = ty3;
                canbreak = this.isRightPoint(showx, showy, hidex, hidey, crossx, crossy);
            }
            if (!canbreak && (tx4 = (int)((float)((ty4 = ybottom) - showy) / k + (float)showx)) >= xleft && tx4 <= xright) {
                crossx = tx4;
                crossy = ty4;
                canbreak = this.isRightPoint(showx, showy, hidex, hidey, crossx, crossy);
            }
            if (!canbreak) {
                return;
            }
        }
        this.curvePath.moveTo(showx, showy);
        this.curvePath.lineTo(crossx, crossy);
    }

    private boolean isRightPoint(int showx, int showy, int hidex, int hidey, int crossx, int crossy) {
        if (showx > hidex && (crossx > showx || crossx < hidex)) {
            return false;
        }
        if (showx < hidex && (crossx < showx || crossx > hidex)) {
            return false;
        }
        if (showy > hidey && (crossy > showy || crossy < hidey)) {
            return false;
        }
        return showy >= hidey || crossy >= showy && crossy <= hidey;
    }

    public void zoomIn(Point startPoint, int viewAxisLen, int w0, int h0) {
        if (null == this.pointCollection) {
            return;
        }
        this.setSize(new Dimension(w0, h0));
        this.viewAxisLen = viewAxisLen;
        this.setPointArray();
    }

    public void setNeedCutPoints(float xgraphMultiple, float ygraphMultiple) {
        this.needCutPoints = xgraphMultiple <= 3.0f && ygraphMultiple <= 3.0f;
    }

    public void move(int sx, int sy, int moveDB, int moveLength) {
        if (null == this.pointCollection) {
            return;
        }
        Point p2 = null;
        float difDB = (float)moveDB / 1000.0f;
        int difLength = moveLength;
        int shiftx = this.calcLengthWidth(difLength) - this.calcLengthWidth(this.lengthOffset);
        int shifty = this.calcDBWidth(difDB) - this.calcDBWidth(this.dBOffset);
        this.dBOffset = difDB;
        this.lengthOffset = moveLength;
        for (Point p2 : this.pointCollection) {
            p2.x += shiftx;
            p2.y -= shifty;
        }
    }

    public int calcDBWidth(float difDB) {
        return (int)((double)this.height * (double)difDB / 60.0);
    }

    public float calcDifDB(int dify) {
        return 60.0f * (float)dify / (float)this.height;
    }

    public int calcLengthWidth(int difLength) {
        return (int)((double)this.width * (double)difLength / (double)this.viewAxisLen);
    }

    public int calcLength(int x) {
        return (int)((double)(x -= 45) * (double)this.viewAxisLen / (double)this.width);
    }

    public void shiftY(int[] cursorInfo) {
        if (null == cursorInfo || 2 != cursorInfo.length) {
            return;
        }
        int index = this.getPosIndex(cursorInfo[0]);
        if (cursorInfo[0] >= this.lengthOffset && index >= 0 && index < this.pointCollection.length) {
            float difDB = (float)cursorInfo[1] / 1000.0f - (this.dataPointArray[index].getGain() + this.dBOffset);
            this.dBOffset += difDB;
            this.setPointArray();
        }
    }

    public String getTipStringByPoint(Point p) {
        int index = this.getSelectedPointNum(p);
        if (index < 0 || index > this.dataPointArray.length - 1) {
            return "";
        }
        return this.getTipString(index);
    }

    public String getTipStringByPos(int pos) {
        int index = this.getPosIndex(pos);
        if (index < 0 || index > this.dataPointArray.length - 1) {
            return "";
        }
        return this.getTipString(index);
    }

    public String getTipString(int index) {
        StringBuffer strBuffer = new StringBuffer();
        DecimalFormat doubleFormat = new DecimalFormat("0.000");
        float pLen = this.dataPointArray[index].getPos() + this.lengthOffset;
        if (this.unit.equals("km")) {
            strBuffer.append(doubleFormat.format(pLen /= 1000.0f)).append("km");
        } else {
            strBuffer.append(pLen);
        }
        strBuffer.append(",");
        float pDB = this.dataPointArray[index].getGain() + this.dBOffset;
        strBuffer.append(doubleFormat.format(pDB)).append("dB");
        return strBuffer.toString();
    }

    private int getSelectedPointNum(Point p) {
        int index = -1;
        if (null == p || p.x < this.pointCollection[0].x || p.x > this.calcLengthWidth(this.lineLength + this.lengthOffset) + 45) {
            return -1;
        }
        int dif = this.width;
        int pointNum = this.pointCollection.length;
        for (int i = 0; i < pointNum; ++i) {
            int px = this.pointCollection[i].x;
            if (px - p.x == 0) {
                index = i;
                break;
            }
            if (Math.abs(px - p.x) > dif) {
                index = i - 1;
                break;
            }
            dif = Math.abs(px - p.x);
        }
        return index;
    }

    private int getSelectedPointNumForMask(int pos) {
        int index = -1;
        if (pos < this.dataPointArray[0].getPos() + this.lengthOffset || pos > this.lineLength + this.lengthOffset) {
            return -1;
        }
        int dif = this.lineLength;
        int pointNum = this.dataPointArray.length;
        for (int i = 0; i < pointNum; ++i) {
            int px = this.dataPointArray[i].getPos() + this.lengthOffset;
            if (px - pos == 0) {
                index = i;
                break;
            }
            if (Math.abs(px - pos) > dif) {
                index = i - 1;
                break;
            }
            dif = Math.abs(px - pos);
        }
        index = index == -1 ? this.pointCollection.length - 1 : index;
        return index;
    }

    public void restore(int width, int height, int viewAxisLength) {
        this.width = width;
        this.height = height;
        this.viewAxisLen = viewAxisLength;
        this.setPointArray();
    }

    public Point[] getMaskPoints(int aPos, int bPos) {
        int startPos = bPos - aPos > 0 ? aPos : bPos;
        int endPos = bPos - aPos > 0 ? bPos : aPos;
        int startNum = this.getSelectedPointNumForMask(startPos);
        int endNum = this.getSelectedPointNumForMask(endPos);
        if (startNum == -1 && endNum == -1) {
            return null;
        }
        if (startNum == this.pointCollection.length - 1 && endNum == this.pointCollection.length - 1) {
            return null;
        }
        if (startNum == -1 && endNum != -1) {
            startNum = 0;
        }
        if (startNum != -1 && endNum == -1) {
            endNum = this.pointCollection.length - 1;
        }
        Point[] abPoints = new Point[endNum - startNum + 2];
        abPoints[0] = new Point(this.dataPointArray[startNum].getPos() + this.lengthOffset, this.dataPointArray[endNum].getPos() + this.lengthOffset);
        System.arraycopy(this.pointCollection, startNum, abPoints, 1, abPoints.length - 1);
        return abPoints;
    }

    public TEOTDRDataPoint[] getDataPointArray() {
        return this.dataPointArray;
    }

    public int[] getCursorInfo(Point p) {
        int[] cursorInfo = new int[2];
        if (p.x < this.pointCollection[0].x || p.x > this.calcLengthWidth(this.lineLength + this.lengthOffset) + 45) {
            cursorInfo[0] = this.calcLength(p.x);
            cursorInfo[1] = 0;
            return cursorInfo;
        }
        int index = this.getSelectedPointNum(p);
        if (index >= 0) {
            cursorInfo[0] = this.dataPointArray[index].getPos() + this.lengthOffset;
            cursorInfo[1] = (int)((this.dataPointArray[index].getGain() + this.dBOffset) * 1000.0f);
        } else {
            cursorInfo[0] = 0;
            cursorInfo[1] = 0;
        }
        return cursorInfo;
    }

    public int[] getCursorInfo(int pos) {
        int[] cursorInfo = new int[2];
        int index = this.getPosIndex(pos);
        if (pos >= this.lengthOffset && index >= 0 && index < this.pointCollection.length) {
            cursorInfo[0] = this.dataPointArray[index].getPos() + this.lengthOffset;
            cursorInfo[1] = (int)((this.dataPointArray[index].getGain() + this.dBOffset) * 1000.0f);
        } else {
            cursorInfo[0] = pos;
            cursorInfo[1] = -1;
        }
        return cursorInfo;
    }

    public int getPointXByPos(int pos) {
        int x = -1;
        int index = this.getPosIndex(pos);
        if (pos >= this.lengthOffset && index >= 0 && index < this.pointCollection.length) {
            x = this.pointCollection[index].x;
        }
        return x;
    }

    public int getPointYByPos(int pos) {
        int y = -1;
        int index = this.getPosIndex(pos);
        if (pos >= this.lengthOffset && index >= 0 && index < this.pointCollection.length) {
            y = this.pointCollection[index].y;
        }
        return y;
    }

    private int getPosIndex(int pos) {
        int index = -1;
        if (pos > this.lineLength + this.lengthOffset) {
            return -1;
        }
        int dif = this.dataPointArray[this.dataPointArray.length - 1].getPos();
        int pointNum = this.dataPointArray.length;
        for (int i = 0; i < pointNum; ++i) {
            int aPos = this.dataPointArray[i].getPos() + this.lengthOffset;
            if (aPos - pos == 0) {
                index = i;
                break;
            }
            if (Math.abs(aPos - pos) > dif) {
                index = i - 1;
                break;
            }
            dif = Math.abs(aPos - pos);
        }
        return index;
    }

    public int getSelectedPointY(int x) {
        Point p = new Point(x, 0);
        int index = this.getSelectedPointNum(p);
        int y = this.pointCollection[index].y;
        return y;
    }

    public int getLengthOffset() {
        return this.lengthOffset;
    }

    public void setLengthOffset(int lengthOffset) {
        this.lengthOffset = lengthOffset;
    }

    public float getDBOffset() {
        return this.dBOffset;
    }

    public void setDBOffset(float offset) {
        this.dBOffset = offset;
    }

    public void setSize(Dimension newSize) {
        this.width = newSize.width;
        this.height = newSize.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.curvePath.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.curvePath.contains(r);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.curvePath.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.curvePath.contains(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return this.curvePath.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.curvePath.getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.curvePath.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.curvePath.getPathIterator(at, flatness);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.curvePath.intersects(r);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.curvePath.intersects(x, y, w, h);
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }
}

