/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceDeviceInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceEventInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceInfo;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceReperterInfo;
import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventNotInitException;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventTabEventLocateEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventTabEventLocateListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphChangeDifCurveStatusEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphCurveStatusChangeEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphDragPoleMovedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphEventLocateEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendChangeGraphColorListener;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphLegendMakeFileSelectedListener;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartBottomAxis;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartInterface;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartLeftAxis;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartPopupMenu;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRChartTopAxis;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRCurveChart;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRCurveCursor;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRCurveMask;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRCurveUsefulInfo;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRDataPoint;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDREventGraphic;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphToolUtil;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRMaskInfoPanel;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphToolbarInterface;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class TEOTDRCurveCanvas
extends JPanel
implements TEOTDRChartInterface,
MouseListener,
MouseMotionListener,
AncestorListener {
    private static final long serialVersionUID = 6359100935981662328L;
    private static final int OFFSET_B = 10;
    private static final int MOUSE_OFFSET = 5;
    private static final List<Float> fileDBOffsetList = new ArrayList<Float>();
    private Map<String, Float> fileDBOffsetMap = new HashMap<String, Float>();
    private Map<String, Long> fileLengthOffsetMap = new HashMap<String, Long>();
    private Color backgroundColor = TEOTDRGraphicConstants.defaultBGColor;
    private Map<String, TEOTDRCurveChart> curveMap;
    private List<String> openedFileList = new ArrayList<String>();
    private String selectedFile = "";
    private TEOTDRCurveChart compareCurve;
    private Point startPoint = new Point(0, 0);
    private Point viewStartPoint = new Point(0, 0);
    private int viewAxisLength;
    private JLabel topAxis;
    private JLabel leftAxis;
    private JLabel bottomAxis;
    private TEOTDRCurveCursor cursorA;
    private TEOTDRCurveCursor cursorB;
    private Dimension size;
    private Dimension parentSize;
    private boolean isZoomIn = false;
    private boolean aDragFlg = false;
    private boolean bDragFlg = false;
    private boolean isMouseIn = false;
    private Point zoomBoxStartPoint;
    private float zoomBoxWidth;
    private float zoomBoxHeight;
    private int zoomBoxStartLength;
    private Rectangle zoomBox;
    private TEOTDRCurveMask curveMask;
    private TEOTDRMaskInfoPanel maskPanel;
    private float maskDBOffset = 0.1f;
    private TEOTDREventGraphic eventg;
    private TEOTDRChartPopupMenu popupMenu = null;
    private boolean needMenu = false;
    private boolean bindingCursor = false;
    private SelectFileListener selectFileListener;
    private FileColorChangeListener fileColorChangeListener;
    private LocateEventListener locateEventListener;
    private JScrollPane parent;
    private int selectedEventID = -1;
    int[] repeaterPositions;
    String[] repeaterNames;
    protected transient TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;

    public TEOTDRCurveCanvas(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
        this.popupMenu = new TEOTDRChartPopupMenu(teOTDRGraphModuleMgr);
        this.setLayout(null);
        this.needMenu = true;
        this.add(this.popupMenu);
        this.setBackground(this.backgroundColor);
        this.addEventListeners();
        this.initalizeOffset();
    }

    public TEOTDRCurveCanvas(boolean needMenu) {
        this.setLayout(null);
        this.needMenu = needMenu;
        if (needMenu) {
            this.add(this.popupMenu);
        }
        this.setBorder(new EmptyBorder(20, 20, 10, 10));
        this.setBackground(this.backgroundColor);
        this.addEventListeners();
        this.initalizeOffset();
    }

    private void initalizeOffset() {
        fileDBOffsetList.add(Float.valueOf(0.0f));
        fileDBOffsetList.add(Float.valueOf(-2.0f));
        fileDBOffsetList.add(Float.valueOf(-4.0f));
    }

    private void addEventListeners() {
        this.selectFileListener = new SelectFileListener();
        this.teOTDRGraphEventManager.addListener(this.selectFileListener);
        this.fileColorChangeListener = new FileColorChangeListener();
        this.teOTDRGraphEventManager.addListener(this.fileColorChangeListener);
        this.locateEventListener = new LocateEventListener();
        this.teOTDRGraphEventManager.addListener(this.locateEventListener);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addAncestorListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawCurves(g);
        if (null != this.curveMask) {
            g.setColor(this.curveMask.getColor());
            ((Graphics2D)g).draw(this.curveMask);
        }
    }

    private void drawCurves(Graphics g) {
        if (null == this.curveMap || this.curveMap.isEmpty()) {
            return;
        }
        if (this.parent.getWidth() != this.parentSize.width || this.parent.getHeight() != this.parentSize.height) {
            this.parentPnlResize();
            return;
        }
        String fileName = "";
        Graphics2D g2 = (Graphics2D)g;
        int xleft = this.calcLeftEdge();
        int xright = this.calcRightEdge();
        int ytop = this.calcTopEdge();
        int ybottom = this.calcBottomEdge();
        if (null != this.compareCurve) {
            this.compareCurve.setNeedCutPoints(this.calcXZoomMultiple(), this.calcYZoomMultiple());
            this.compareCurve.drawCurvePath(xleft, xright, ytop, ybottom);
            g2.setColor(Color.BLACK);
            g2.draw(this.compareCurve);
            this.cursorA.draw(g2);
            this.cursorB.draw(g2);
            if (this.cursorA.getStartPoint().x == this.cursorB.getStartPoint().x) {
                this.cursorB.draw(g2);
            }
            return;
        }
        for (TEOTDRCurveChart curveChart : this.curveMap.values()) {
            fileName = curveChart.getChartName();
            if (fileName.equals(this.selectedFile)) continue;
            curveChart.setNeedCutPoints(this.calcXZoomMultiple(), this.calcYZoomMultiple());
            curveChart.drawCurvePath(xleft, xright, ytop, ybottom);
            g2.setColor(this.teCommonUtil.getFileColor(fileName));
            g2.draw(curveChart);
        }
        if (null != this.selectedFile && !"".equals(this.selectedFile) && this.curveMap.containsKey(this.selectedFile)) {
            TEOTDRCurveChart selectedCurve = this.curveMap.get(this.selectedFile);
            selectedCurve.setNeedCutPoints(this.calcXZoomMultiple(), this.calcYZoomMultiple());
            selectedCurve.drawCurvePath(xleft, xright, ytop, ybottom);
            g2.setColor(this.teCommonUtil.getFileColor(this.selectedFile));
            g2.draw(selectedCurve);
        }
        this.cursorA.draw(g2);
        this.cursorB.draw(g2);
        if (this.cursorA.getStartPoint().x == this.cursorB.getStartPoint().x) {
            this.cursorB.draw(g2);
        }
        if (null != this.eventg) {
            g2.setColor(Color.red);
            g2.draw(this.eventg);
            g2.fill(this.eventg);
        }
    }

    private int calcLeftEdge() {
        return this.viewStartPoint.x + 45;
    }

    private int calcRightEdgeGap() {
        int right_gap = 120 - (this.size.width - this.viewStartPoint.x - this.parentSize.width + 18);
        return right_gap >= 0 ? right_gap : 0;
    }

    private int calcRightEdge() {
        int right_gap = this.calcRightEdgeGap();
        return this.viewStartPoint.x + this.parentSize.width - 18 - right_gap;
    }

    private int calcTopEdge() {
        return this.viewStartPoint.y + 25;
    }

    private int calcBottomEdge() {
        return this.viewStartPoint.y + this.parentSize.height - 18 - 25;
    }

    private int getViewWidth() {
        return this.parent.getWidth() - 18;
    }

    private int getViewHeight() {
        return this.parent.getHeight() - 18;
    }

    private void parentPnlResize() {
        Dimension oldSize = new Dimension(this.parentSize.width - 18 - this.calcRightEdgeGap() - 45, this.parentSize.height - 18 - 50);
        if (oldSize.width <= 0) {
            oldSize.width = 1;
        }
        if (oldSize.height == 0) {
            oldSize.height = 1;
        }
        this.zoomBoxWidth = oldSize.width;
        this.zoomBoxHeight = oldSize.height;
        this.zoomBoxStartPoint = new Point(this.viewStartPoint.x + 45, this.viewStartPoint.y + 25);
        this.zoomBoxStartLength = this.calcLineLength(this.zoomBoxStartPoint.x - 45);
        float xZoomMultiple = (float)(this.parent.getWidth() - 18 - this.calcRightEdgeGap() - 45) / (float)oldSize.width;
        float yZoomMultiple = (float)(this.parent.getHeight() - 18 - 50) / (float)oldSize.height;
        this.size.setSize((float)this.getCanvasRealWidth() * xZoomMultiple + 165.0f, (float)this.getCanvasRealHeight() * yZoomMultiple + 50.0f);
        this.parentSize = new Dimension(this.parent.getWidth(), this.parent.getHeight());
        this.chartZoomIn(xZoomMultiple, yZoomMultiple);
    }

    @Override
    public void openFile(int neID, String fileName) {
        if ("".equals(fileName)) {
            return;
        }
        if (null != this.curveMap && this.curveMap.keySet().contains(fileName)) {
            this.selectFile(fileName);
            return;
        }
        TEOTDRGraphTraceInfo traceInfo = this.teCommonUtil.getTraceInfo(fileName);
        if (null == traceInfo) {
            return;
        }
        if (null == this.parent) {
            this.parent = (JScrollPane)((JViewport)this.getParent()).getParent();
        }
        int newLineLen = (int)(traceInfo.getTraceParamsInfo().getMeasureRangeDistance() * 1000.0f);
        Map<Integer, TEOTDRGraphTraceReperterInfo> repeaterInfoMap = traceInfo.getTraceSpanInfo();
        Map<Integer, TEOTDRGraphTraceEventInfo> traceEventInfo = traceInfo.getTraceEventInfo();
        Map<Integer, TEOTDRGraphTraceDeviceInfo> traceDeviceInfo = traceInfo.getTraceDeviceInfo();
        if (null == repeaterInfoMap || repeaterInfoMap.isEmpty()) {
            Object repeaterPositions = null;
            Object repeaterNames = null;
        } else {
            int i;
            HashMap<Integer, String> underDeviceInfo = new HashMap<Integer, String>();
            ArrayList<Integer> positionsList = new ArrayList<Integer>();
            int[] repeaterPositions = new int[repeaterInfoMap.size() + traceDeviceInfo.size()];
            String[] repeaterNames = new String[repeaterInfoMap.size() - 1 + traceDeviceInfo.size()];
            ArrayList<Integer> repeaterIdList = new ArrayList<Integer>(repeaterInfoMap.keySet());
            Collections.sort(repeaterIdList);
            int len = repeaterInfoMap.size();
            for (i = 0; i < len; ++i) {
                int curID = (Integer)repeaterIdList.get(i);
                repeaterPositions[i] = (int)(repeaterInfoMap.get(curID).getRepeaterLocation() * 1000.0f);
                positionsList.add(repeaterPositions[i]);
                if (i >= 1) {
                    repeaterNames[i - 1] = repeaterInfoMap.get(curID).getRepeaterName();
                    underDeviceInfo.put(repeaterPositions[i], repeaterNames[i - 1]);
                    continue;
                }
                underDeviceInfo.put(repeaterPositions[i], null);
            }
            for (TEOTDRGraphTraceEventInfo eventInfo : traceEventInfo.values()) {
                int spanIDOfEvent;
                if (!eventInfo.getEventCode().equalsIgnoreCase("0F9999")) continue;
                short deviceType = 0;
                if (eventInfo.getComment().indexOf("OADM.BU") >= 0) {
                    deviceType = 1;
                } else if (eventInfo.getComment().indexOf("FP.BU") >= 0) {
                    deviceType = 2;
                } else if (eventInfo.getComment().indexOf("OEQ") >= 0) {
                    deviceType = 3;
                }
                if (0 == deviceType) continue;
                int eventLocation = (int)(eventInfo.getEventLocationInLine() * 1000.0);
                for (spanIDOfEvent = 1; spanIDOfEvent < repeaterPositions.length && eventLocation >= repeaterPositions[spanIDOfEvent]; ++spanIDOfEvent) {
                }
                for (TEOTDRGraphTraceDeviceInfo deviceInfo : traceDeviceInfo.values()) {
                    if (deviceInfo.getDeviceType() != deviceType || spanIDOfEvent != deviceInfo.getSpanIDOfDevice()) continue;
                    repeaterPositions[i] = eventLocation;
                    repeaterNames[i - 1] = deviceInfo.getDeviceName();
                    positionsList.add(repeaterPositions[i]);
                    underDeviceInfo.put(repeaterPositions[i], repeaterNames[i - 1]);
                    ++i;
                }
            }
            Collections.sort(positionsList);
            repeaterPositions = new int[repeaterInfoMap.size() + traceDeviceInfo.size()];
            repeaterNames = new String[repeaterInfoMap.size() - 1 + traceDeviceInfo.size()];
            i = 0;
            for (Integer position : positionsList) {
                repeaterPositions[i] = position;
                if (i >= 1) {
                    repeaterNames[i - 1] = (String)underDeviceInfo.get(position);
                }
                ++i;
            }
            if (null == this.repeaterPositions || repeaterPositions.length > this.repeaterPositions.length) {
                this.repeaterPositions = repeaterPositions;
            }
            if (null == this.repeaterNames || repeaterNames.length > this.repeaterNames.length) {
                this.repeaterNames = repeaterNames;
            }
            if (repeaterNames.length == this.repeaterNames.length) {
                boolean isHaveNull = false;
                int jlen = repeaterNames.length;
                for (int j = 0; j < jlen; ++j) {
                    if (null != this.repeaterNames[j]) continue;
                    isHaveNull = true;
                }
                if (isHaveNull) {
                    this.repeaterPositions = repeaterPositions;
                    this.repeaterNames = repeaterNames;
                }
            }
        }
        if (null == this.curveMap) {
            this.parentSize = new Dimension(this.parent.getWidth(), this.parent.getHeight());
            this.size = this.getSize(this.parentSize.width, this.parentSize.height);
            this.curveMap = new HashMap<String, TEOTDRCurveChart>();
            this.leftAxis = new TEOTDRChartLeftAxis(this.viewStartPoint, this.size.height, this.getViewHeight());
            this.topAxis = new TEOTDRChartTopAxis(this.viewStartPoint, this.size.width, newLineLen);
            this.viewAxisLength = ((TEOTDRChartTopAxis)this.topAxis).getAxisLineLength();
            this.bottomAxis = new TEOTDRChartBottomAxis(this.viewStartPoint, this.size.width, this.viewAxisLength, this.size.height, this.repeaterPositions, this.repeaterNames);
            this.cursorA = new TEOTDRCurveCursor("A", this.getViewHeight() - 50, 0);
            this.cursorB = new TEOTDRCurveCursor("B", this.getViewHeight() - 50, 10);
        }
        this.removeCompareCurve();
        if (newLineLen > this.viewAxisLength) {
            TEOTDRChartTopAxis topAxisObj = (TEOTDRChartTopAxis)this.topAxis;
            topAxisObj.changeAxis(this.size.width, newLineLen, newLineLen);
            topAxisObj.repaint();
            this.viewAxisLength = topAxisObj.getAxisLineLength();
            this.adjustChart();
        }
        if (null != this.curveMap) {
            ((TEOTDRChartBottomAxis)this.bottomAxis).setRepeaterNames(this.repeaterNames);
            ((TEOTDRChartBottomAxis)this.bottomAxis).changeAxisRpt(this.repeaterPositions, this.viewAxisLength);
        }
        TEOTDRCurveUsefulInfo usefulInfo = this.createUsefulInfo(fileName, TEOTDRGraphToolUtil.calculateDataPoint(traceInfo));
        TEOTDRCurveChart curveChart = new TEOTDRCurveChart(fileName, usefulInfo);
        curveChart.setLineLength(newLineLen);
        this.selectedFile = fileName;
        this.openedFileList.add(fileName);
        this.curveMap.put(fileName, curveChart);
        this.eventg = null;
        this.repaintComponents();
        this.setCursorLocation();
        if (null != this.curveMask) {
            this.removeMask();
            TEOTDRGraphToolbarInterface tinf = this.teOTDRGraphModuleMgr.getToolbarInteractor();
            tinf.removeMask();
        }
        this.repaint();
        this.treggerCursorLocateEvent();
    }

    private void setCursorLocation() {
        if ("".equals(this.selectedFile) || null == this.curveMap || !this.curveMap.containsKey(this.selectedFile)) {
            return;
        }
        TEOTDRCurveChart selectedChart = this.curveMap.get(this.selectedFile);
        int aPos = selectedChart.getCursorInfo(this.cursorA.getStartPoint())[0];
        aPos = aPos != 0 ? aPos : this.calcLineLength(this.cursorA.getStartPoint().x - 45);
        int bPos = selectedChart.getCursorInfo(this.cursorB.getStartPoint())[0];
        bPos = bPos != 0 ? bPos : this.calcLineLength(this.cursorB.getStartPoint().x - 45);
        this.cursorA.setCursorPos(aPos);
        this.cursorB.setCursorPos(bPos);
    }

    private void adjustChart() {
        if (null == this.curveMap || this.curveMap.isEmpty()) {
            return;
        }
        for (TEOTDRCurveChart curveChart : this.curveMap.values()) {
            curveChart.adjustWidth(this.viewAxisLength);
        }
    }

    private TEOTDRCurveUsefulInfo createUsefulInfo(String fileName, TEOTDRDataPoint[] dataPoints) {
        TEOTDRCurveUsefulInfo usefulInfo = new TEOTDRCurveUsefulInfo();
        usefulInfo.setCanvasWidth(this.getCanvasRealWidth());
        usefulInfo.setCanvasHeight(this.getCanvasRealHeight());
        usefulInfo.setDBOffset(this.setInitDBOffset(fileName));
        usefulInfo.setUnit(((TEOTDRChartTopAxis)this.topAxis).getUnit());
        usefulInfo.setViewAxisLength(this.viewAxisLength);
        usefulInfo.setDataPoints(dataPoints);
        return usefulInfo;
    }

    private int getCanvasRealWidth() {
        int tWidth = this.size.width - 165;
        if (tWidth <= 0) {
            tWidth = 1;
        }
        return tWidth;
    }

    private int getCanvasRealHeight() {
        int tHeight = this.size.height - 50;
        if (tHeight <= 0) {
            tHeight = 1;
        }
        return tHeight;
    }

    @Override
    public void initOpenFiles(List<String> openedFileList) {
        this.openedFileList = new ArrayList<String>();
        List<String> fileNames = openedFileList;
        int len = fileNames.size();
        for (int i = 0; i < len; ++i) {
            this.openFile(0, fileNames.get(i));
        }
    }

    private float setInitDBOffset(String fileName) {
        if ("differentcurve".equals(fileName)) {
            return 0.0f;
        }
        int len = fileDBOffsetList.size();
        for (int i = 0; i < len; ++i) {
            float tmpDBOffset = fileDBOffsetList.get(i).floatValue();
            if (this.fileDBOffsetMap.containsValue(Float.valueOf(tmpDBOffset))) continue;
            this.fileDBOffsetMap.put(fileName, Float.valueOf(tmpDBOffset));
            return tmpDBOffset;
        }
        return 0.0f;
    }

    private void repaintComponents() {
        this.removeAll();
        if (null != this.curveMap && !this.curveMap.isEmpty()) {
            this.add(this.leftAxis);
            this.add(this.topAxis);
            this.add(this.bottomAxis);
        }
        if (null != this.maskPanel) {
            this.add(this.maskPanel);
        }
    }

    @Override
    public void closeFiles(List<String> fileNameList) {
        if (null == fileNameList || fileNameList.isEmpty() || null == this.curveMap || this.curveMap.isEmpty()) {
            return;
        }
        int listLen = fileNameList.size();
        for (int i = 0; i < listLen; ++i) {
            String filename = fileNameList.get(i);
            if (this.curveMap.containsKey(filename)) {
                this.curveMap.remove(filename);
                this.openedFileList.remove(filename);
            }
            this.fileDBOffsetMap.remove(filename);
            this.fileLengthOffsetMap.remove(filename);
        }
        if (!this.curveMap.containsKey(this.selectedFile)) {
            this.selectedFile = "";
            this.eventg = null;
        }
        this.removeCompareCurve();
        if (null != this.curveMask) {
            this.removeMask();
            TEOTDRGraphToolbarInterface tinf = this.teOTDRGraphModuleMgr.getToolbarInteractor();
            tinf.removeMask();
        }
        this.repaintComponents();
        this.repaint();
    }

    public void selectFile(String fileName) {
        if (null == fileName || "".equals(fileName)) {
            return;
        }
        this.selectedFile = fileName;
        TEOTDRGraphTraceInfo traceInfo = this.teCommonUtil.getTraceInfo(fileName);
        if (null == traceInfo) {
            return;
        }
        Map<Integer, TEOTDRGraphTraceReperterInfo> repeaterInfoMap = traceInfo.getTraceSpanInfo();
        Map<Integer, TEOTDRGraphTraceEventInfo> traceEventInfo = traceInfo.getTraceEventInfo();
        Map<Integer, TEOTDRGraphTraceDeviceInfo> traceDeviceInfo = traceInfo.getTraceDeviceInfo();
        if (null == repeaterInfoMap || 0 == repeaterInfoMap.size()) {
            Object repeaterPositions = null;
        } else {
            int i;
            HashMap<Integer, String> underDeviceInfo = new HashMap<Integer, String>();
            ArrayList<Integer> positionsList = new ArrayList<Integer>();
            int[] repeaterPositions = new int[repeaterInfoMap.size() + traceDeviceInfo.size()];
            String[] repeaterNames = new String[repeaterInfoMap.size() - 1 + traceDeviceInfo.size()];
            ArrayList<Integer> repeaterIdList = new ArrayList<Integer>(repeaterInfoMap.keySet());
            Collections.sort(repeaterIdList);
            int len = repeaterInfoMap.size();
            for (i = 0; i < len; ++i) {
                repeaterPositions[i] = (int)(repeaterInfoMap.get(repeaterIdList.get(i)).getRepeaterLocation() * 1000.0f);
                positionsList.add(repeaterPositions[i]);
                if (i >= 1) {
                    repeaterNames[i - 1] = repeaterInfoMap.get(repeaterIdList.get(i)).getRepeaterName();
                    underDeviceInfo.put(repeaterPositions[i], repeaterNames[i - 1]);
                    continue;
                }
                underDeviceInfo.put(repeaterPositions[i], null);
            }
            for (TEOTDRGraphTraceEventInfo eventInfo : traceEventInfo.values()) {
                int spanIDOfEvent;
                if (!eventInfo.getEventCode().equalsIgnoreCase("0F9999")) continue;
                short deviceType = 0;
                if (eventInfo.getComment().indexOf("OADM.BU") >= 0) {
                    deviceType = 1;
                } else if (eventInfo.getComment().indexOf("FP.BU") >= 0) {
                    deviceType = 2;
                } else if (eventInfo.getComment().indexOf("OEQ") >= 0) {
                    deviceType = 3;
                }
                if (0 == deviceType) continue;
                int eventLocation = (int)(eventInfo.getEventLocationInLine() * 1000.0);
                for (spanIDOfEvent = 1; spanIDOfEvent < repeaterPositions.length && eventLocation >= repeaterPositions[spanIDOfEvent]; ++spanIDOfEvent) {
                }
                for (TEOTDRGraphTraceDeviceInfo deviceInfo : traceDeviceInfo.values()) {
                    if (deviceInfo.getDeviceType() != deviceType || spanIDOfEvent != deviceInfo.getSpanIDOfDevice()) continue;
                    repeaterPositions[i] = eventLocation;
                    repeaterNames[i - 1] = deviceInfo.getDeviceName();
                    positionsList.add(repeaterPositions[i]);
                    underDeviceInfo.put(repeaterPositions[i], repeaterNames[i - 1]);
                    ++i;
                }
            }
            Collections.sort(positionsList);
            repeaterPositions = new int[repeaterInfoMap.size() + traceDeviceInfo.size()];
            repeaterNames = new String[repeaterInfoMap.size() - 1 + traceDeviceInfo.size()];
            i = 0;
            for (Integer position : positionsList) {
                repeaterPositions[i] = position;
                if (i >= 1) {
                    repeaterNames[i - 1] = (String)underDeviceInfo.get(position);
                }
                ++i;
            }
            if (null == this.repeaterPositions || repeaterPositions.length > this.repeaterPositions.length) {
                this.repeaterPositions = repeaterPositions;
            }
            if (null == this.repeaterNames || repeaterNames.length > this.repeaterNames.length) {
                this.repeaterNames = repeaterNames;
            }
            if (repeaterNames.length == this.repeaterNames.length) {
                boolean isHaveNull = false;
                int jlen = repeaterNames.length;
                for (int j = 0; j < jlen; ++j) {
                    if (null != this.repeaterNames[j]) continue;
                    isHaveNull = true;
                }
                if (isHaveNull) {
                    this.repeaterPositions = repeaterPositions;
                    this.repeaterNames = repeaterNames;
                }
            }
        }
        ((TEOTDRChartBottomAxis)this.bottomAxis).setRepeaterNames(this.repeaterNames);
        ((TEOTDRChartBottomAxis)this.bottomAxis).changeAxisRpt(this.repeaterPositions, this.viewAxisLength);
        this.setCursorLocation();
        this.treggerCursorLocateEvent();
        this.eventg = null;
        if (null != this.curveMask) {
            this.removeMask();
            TEOTDRGraphToolbarInterface tinf = this.teOTDRGraphModuleMgr.getToolbarInteractor();
            tinf.removeMask();
        }
        this.repaintComponents();
        this.repaint();
    }

    private void removeCompareCurve() {
        this.compareCurve = null;
    }

    public void createCompareCurve() {
        if (null != this.compareCurve) {
            return;
        }
        if (null == this.openedFileList || 2 != this.openedFileList.size()) {
            TEOTDRGraphToolUtil.showMessage(this.parent, "NOT_OPENED_TOWFILES");
            return;
        }
        if (!TEOTDRGraphToolUtil.compareConfigInfo(this.openedFileList, this.teCommonUtil.getTraceInfo(this.openedFileList.get(0)), this.teCommonUtil.getTraceInfo(this.openedFileList.get(1)))) {
            TEOTDRGraphToolUtil.showMessage(this.parent, "CONFIG_PARAM_DIFFRENT");
            return;
        }
        ArrayList<TEOTDRCurveChart> curveList = new ArrayList<TEOTDRCurveChart>();
        curveList.add(this.curveMap.get(this.openedFileList.get(0)));
        curveList.add(this.curveMap.get(this.openedFileList.get(1)));
        TEOTDRCurveUsefulInfo usefulInfo = this.createUsefulInfo("differentcurve", TEOTDRGraphToolUtil.calculateDataPoint(curveList, this.selectedFile));
        this.compareCurve = new TEOTDRCurveChart("compare file", usefulInfo);
        this.treggerCompareStatusChangeEvent(true);
        this.repaint();
    }

    private void setMouseMoveCursor(Point p) {
        int xA = this.cursorA.getStartPoint().x;
        int xB = this.cursorB.getStartPoint().x;
        int x = p.x;
        if (x > xA - 5 && x < xA + 5 || x > xB - 5 && x < xB + 5) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    private void showToolTip(Point p) {
        if (null == this.selectedFile || "".equals(this.selectedFile)) {
            return;
        }
        TEOTDRCurveChart selectedCurve = this.curveMap.get(this.selectedFile);
        String tipText = selectedCurve.getTipStringByPoint(p);
        if (this.cursorA.getStartPoint().x == p.x) {
            tipText = selectedCurve.getTipStringByPos(this.cursorA.getCursorPos());
        } else if (this.cursorB.getStartPoint().y == p.y) {
            tipText = selectedCurve.getTipStringByPos(this.cursorB.getCursorPos());
        }
        if ("" != tipText) {
            if (!ToolTipManager.sharedInstance().isEnabled()) {
                ToolTipManager.sharedInstance().setEnabled(true);
            }
            this.setToolTipText(tipText);
        } else if (ToolTipManager.sharedInstance().isEnabled()) {
            ToolTipManager.sharedInstance().setEnabled(false);
        }
    }

    public void setCursorMoveFlg(Point p, boolean pressFlg) {
        int xA = this.cursorA.getStartPoint().x;
        int xB = this.cursorB.getStartPoint().x;
        int x = p.x;
        this.aDragFlg = false;
        this.bDragFlg = false;
        if (!pressFlg) {
            return;
        }
        if (x > xA - 5 && x < xA + 5) {
            this.aDragFlg = pressFlg;
            return;
        }
        if (x > xB - 5 && x < xB + 5) {
            this.bDragFlg = pressFlg;
        }
    }

    public void startZoomIn() {
        this.isZoomIn = true;
        if (this.isMouseIn) {
            this.setZoomMouse(this.getMousePosition());
        }
        this.popupMenu.changeMenuItem("startpartzoom", true);
        TEOTDRGraphToolbarInterface tinf = this.teOTDRGraphModuleMgr.getToolbarInteractor();
        tinf.doStartPartZoom();
    }

    private void setPopupMenuStatus(boolean isZoomIn) {
        HashMap<String, Boolean> menuStates = new HashMap<String, Boolean>();
        menuStates.put("menuzoomout", isZoomIn);
        menuStates.put("restore", isZoomIn);
        this.popupMenu.setMenuItemEnabled(menuStates);
    }

    public void stopZoomIn() {
        this.isZoomIn = false;
        if (this.isMouseIn) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
        this.popupMenu.changeMenuItem("startpartzoom", false);
        TEOTDRGraphToolbarInterface tinf = this.teOTDRGraphModuleMgr.getToolbarInteractor();
        tinf.doStopPartZoom();
    }

    public void chartZoomIn(float xZoomMultiple, float yZoomMultiple) {
        ((TEOTDRChartTopAxis)this.topAxis).changeAxis(this.viewStartPoint, this.size.width, this.calcLineLength(this.getZoomBoxRealWidth()));
        this.viewAxisLength = ((TEOTDRChartTopAxis)this.topAxis).getAxisLineLength();
        ((TEOTDRChartBottomAxis)this.bottomAxis).changeAxis(this.viewStartPoint, this.size.width, this.getViewHeight(), this.viewAxisLength);
        int canvasWidth = this.getCanvasRealWidth();
        int canvasHeight = this.getCanvasRealHeight();
        for (TEOTDRCurveChart curvechart : this.curveMap.values()) {
            curvechart.zoomIn(this.viewStartPoint, this.viewAxisLength, canvasWidth, canvasHeight);
        }
        this.setSize(this.size);
        this.setPreferredSize(this.size);
        this.viewStartPoint.x = (int)this.calcXLength(this.zoomBoxStartLength);
        if (this.viewStartPoint.x - 40 > 0) {
            this.viewStartPoint.x -= 40;
        }
        this.startPoint.x = -this.viewStartPoint.x;
        this.setLocation(this.startPoint);
        ((TEOTDRChartLeftAxis)this.leftAxis).changeAxis(this.viewStartPoint, this.size.height, this.getViewHeight());
        this.resetCursor();
        this.treggerCursorLocateEvent();
        if (null != this.compareCurve) {
            this.compareCurve.zoomIn(this.viewStartPoint, this.viewAxisLength, canvasWidth, canvasHeight);
        }
        this.clearZoomBox();
        this.treggerCurveChangeEvent();
        this.resetMask();
        this.resetEventTriangle();
        this.repaintComponents();
        if (!TECommonUtil.isDebug) {
            this.teCommonUtil.getApplet().repaint();
        } else {
            TECommonUtil.getTopFrame(this.parent).repaint();
        }
    }

    private float getZoomBoxRealWidth() {
        float boxWidth = this.zoomBoxWidth;
        int gap = (int)((float)this.zoomBoxStartPoint.x + boxWidth - (float)(this.getWidth() - 120));
        if (gap > 0) {
            boxWidth -= (float)gap;
        }
        return boxWidth;
    }

    private Point calcMaskStartPoint() {
        int x = this.viewStartPoint.x + this.getViewWidth() - 230 - 10;
        int y = this.viewStartPoint.y + 25 + 10;
        return new Point(x, y);
    }

    private Dimension getSize(int tWidth, int tHeight) {
        Dimension tSize = new Dimension(tWidth - 18, tHeight - 18);
        if (tSize.width <= 0) {
            tSize.width = 1;
        }
        if (tSize.height <= 0) {
            tSize.height = 1;
        }
        return tSize;
    }

    private void clearZoomBox() {
        this.zoomBox = null;
        this.zoomBoxStartPoint = null;
        this.zoomBoxWidth = 0.0f;
        this.zoomBoxHeight = 0.0f;
    }

    private void resetCursor() {
        if ("".equals(this.selectedFile) || null == this.curveMap || !this.curveMap.containsKey(this.selectedFile)) {
            return;
        }
        int tmpPosA = this.cursorA.getCursorPos() > this.viewAxisLength ? this.viewAxisLength : this.cursorA.getCursorPos();
        int ax = this.curveMap.get(this.selectedFile).getPointXByPos(tmpPosA);
        int tmpPosB = this.cursorB.getCursorPos() > this.viewAxisLength ? this.viewAxisLength : this.cursorB.getCursorPos();
        int bx = this.curveMap.get(this.selectedFile).getPointXByPos(tmpPosB);
        if (ax == -1) {
            ax = (int)this.calcXLength(tmpPosA) + 45;
        }
        this.cursorA.setCursorPos(tmpPosA);
        if (bx == -1) {
            bx = (int)this.calcXLength(tmpPosB) + 45;
        }
        this.cursorB.setCursorPos(tmpPosB);
        this.cursorA.reset(this.getViewHeight() - 50, ax, this.viewStartPoint.y);
        this.cursorB.reset(this.getViewHeight() - 50, bx, this.viewStartPoint.y);
    }

    private boolean canBeZoomed() {
        float zoomWidth = this.getZoomBoxRealWidth();
        if (zoomWidth <= 0.0f) {
            return false;
        }
        if (this.calcLineLength(zoomWidth) < 400) {
            return false;
        }
        float zoomDB = this.calcDBLength(this.zoomBoxHeight);
        return !(zoomDB < 0.3f);
    }

    public void zoomOut() {
        int restoreFlg = 0;
        this.zoomBoxStartPoint = new Point(this.viewStartPoint.x, this.viewStartPoint.y);
        this.zoomBoxStartLength = this.calcLineLength(this.zoomBoxStartPoint.x - 45);
        this.zoomBoxWidth = this.getViewWidth();
        this.zoomBoxHeight = this.getViewHeight();
        this.size.setSize((float)this.getCanvasRealWidth() * 0.75f + 165.0f, (float)this.getCanvasRealHeight() * 0.75f + 50.0f);
        this.startPoint.x = (int)((float)this.startPoint.x * 0.75f);
        this.startPoint.y = (int)((float)this.startPoint.y * 0.75f);
        if (this.calcXZoomMultiple() * 0.75f <= 1.0f) {
            this.startPoint.x = 0;
            this.size.width = this.parentSize.width;
            ++restoreFlg;
        }
        if (this.calcYZoomMultiple() * 0.75f <= 1.0f) {
            this.startPoint.y = 0;
            this.size.height = this.parentSize.height;
            ++restoreFlg;
        }
        if (restoreFlg == 2) {
            this.restore();
        } else {
            this.setLocation(this.startPoint);
            this.viewStartPoint.x = -this.startPoint.x;
            this.viewStartPoint.y = -this.startPoint.y;
            this.chartZoomIn(0.75f, 0.75f);
        }
    }

    private float calcXZoomMultiple() {
        return (float)this.size.width / (float)(this.parentSize.width - 18);
    }

    private float calcYZoomMultiple() {
        return (float)this.size.height / (float)(this.parentSize.height - 18);
    }

    public float[] getZoomRate() {
        float[] zoomRate = new float[]{this.calcXZoomMultiple(), this.calcYZoomMultiple()};
        return zoomRate;
    }

    public void restore() {
        this.startPoint = new Point(0, 0);
        this.setLocation(this.startPoint);
        this.viewStartPoint = new Point(0, 0);
        this.size.width = this.parentSize.width - 18;
        this.size.height = this.parentSize.height - 18;
        this.setSize(this.size);
        this.setPreferredSize(this.size);
        ((TEOTDRChartLeftAxis)this.leftAxis).changeAxis(this.viewStartPoint, this.size.height, this.size.height);
        ((TEOTDRChartTopAxis)this.topAxis).changeAxis(this.viewStartPoint, this.size.width, this.viewAxisLength);
        this.viewAxisLength = ((TEOTDRChartTopAxis)this.topAxis).getAxisLineLength();
        ((TEOTDRChartBottomAxis)this.bottomAxis).changeAxis(this.viewStartPoint, this.size.width, this.size.height, this.viewAxisLength);
        for (TEOTDRCurveChart curveChart : this.curveMap.values()) {
            curveChart.restore(this.getCanvasRealWidth(), this.getCanvasRealHeight(), this.viewAxisLength);
        }
        if (null != this.compareCurve) {
            this.compareCurve.restore(this.getCanvasRealWidth(), this.getCanvasRealHeight(), this.viewAxisLength);
        }
        this.resetCursor();
        this.resetMask();
        this.treggerCurveChangeEvent();
        this.treggerCursorLocateEvent();
        this.resetEventTriangle();
        this.repaintComponents();
        this.setPopupMenuStatus(false);
    }

    private void dragCursor(Point p) {
        int x;
        if (this.aDragFlg && null != this.cursorA && this.canCursorMove(this.cursorA, p)) {
            if (this.cursorA.getStartPoint().x == this.cursorB.getStartPoint().x) {
                this.cursorB.draw(this.getGraphics());
            }
            x = this.cursorA.getStartPoint().x;
            this.selectedEventID = -1;
            this.cursorMove(this.cursorA, p);
            if (this.bindingCursor) {
                x = this.cursorB.getStartPoint().x + (p.x - x);
                this.cursorMove(this.cursorB, new Point(x, this.cursorB.getStartPoint().y));
            }
            if (this.cursorA.getStartPoint().x == this.cursorB.getStartPoint().x) {
                this.cursorB.draw(this.getGraphics());
            }
        }
        if (this.bDragFlg && null != this.cursorB && this.canCursorMove(this.cursorB, p)) {
            if (this.cursorA.getStartPoint().x == this.cursorB.getStartPoint().x) {
                this.cursorB.draw(this.getGraphics());
            }
            x = this.cursorB.getStartPoint().x;
            this.cursorMove(this.cursorB, p);
            if (this.bindingCursor) {
                x = this.cursorA.getStartPoint().x + (p.x - x);
                this.selectedEventID = -1;
                this.cursorMove(this.cursorA, new Point(x, this.cursorA.getStartPoint().y));
            }
            if (this.cursorA.getStartPoint().x == this.cursorB.getStartPoint().x) {
                this.cursorB.draw(this.getGraphics());
            }
        }
        this.treggerCursorLocateEvent();
    }

    public void setCursorPos(String cursorStr, int poslen) {
        if ("".equals(this.selectedFile) || null == this.curveMap || !this.curveMap.containsKey(this.selectedFile)) {
            return;
        }
        TEOTDRCurveCursor cursor = "A".equals(cursorStr) ? this.cursorA : this.cursorB;
        int x = this.curveMap.get(this.selectedFile).getPointXByPos(poslen);
        if (x == -1) {
            x = (int)this.calcXLength(poslen) + 45;
            cursor.setCursorPos(poslen);
        } else {
            cursor.setCursorPos(this.curveMap.get(this.selectedFile).getCursorInfo(poslen)[0]);
        }
        cursor.reset(this.getViewHeight() - 50, x, this.viewStartPoint.y);
        this.treggerCursorLocateEvent();
        this.repaint();
    }

    private void cursorMove(TEOTDRCurveCursor cursor, Point p) {
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        g2d.setXORMode(this.backgroundColor);
        cursor.draw(g2d);
        cursor.move(p, g2d);
        if (!"".equals(this.selectedFile) || null != this.curveMap && this.curveMap.containsKey(this.selectedFile)) {
            int pos = this.curveMap.get(this.selectedFile).getCursorInfo(p)[0];
            pos = pos == 0 ? this.calcLineLength(p.x - 45) : pos;
            cursor.setCursorPos(pos);
        }
    }

    private boolean canCursorMove(TEOTDRCurveCursor cursor, Point p) {
        if (p.x < 45 || p.x >= this.viewStartPoint.x + this.getViewWidth() || p.x < this.viewStartPoint.x + 45 || p.x >= this.size.width - 120) {
            return false;
        }
        int oDifPos = 0;
        oDifPos = cursor == this.cursorA ? this.cursorB.getStartPoint().x - (this.cursorA.getStartPoint().x - p.x) : this.cursorA.getStartPoint().x - (this.cursorB.getStartPoint().x - p.x);
        if (this.bindingCursor) {
            if (p.x <= cursor.getStartPoint().x && (oDifPos < 45 || oDifPos < this.viewStartPoint.x + 45)) {
                return false;
            }
            if (p.x >= cursor.getStartPoint().x && (oDifPos >= this.viewStartPoint.x + this.getViewWidth() || oDifPos >= this.size.width - 120)) {
                return false;
            }
        }
        return true;
    }

    public void bindingCursor() {
        this.bindingCursor = true;
        HashMap<String, Boolean> menuEnableMap = new HashMap<String, Boolean>();
        menuEnableMap.put("menulock", false);
        menuEnableMap.put("menuunlock", true);
        this.popupMenu.setMenuItemEnabled(menuEnableMap);
    }

    public void unBindingCursor() {
        this.bindingCursor = false;
        HashMap<String, Boolean> menuEnableMap = new HashMap<String, Boolean>();
        menuEnableMap.put("menulock", true);
        menuEnableMap.put("menuunlock", false);
        this.popupMenu.setMenuItemEnabled(menuEnableMap);
    }

    @Override
    public void colorChange(Color newColor) {
        if (null != newColor) {
            this.backgroundColor = newColor;
            this.setBackground(newColor);
        }
    }

    public void addMask() {
        TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
        if (null == curveChart) {
            return;
        }
        Point[] points = curveChart.getMaskPoints(this.cursorA.getCursorPos(), this.cursorB.getCursorPos());
        float offset = this.calcYLength(this.maskDBOffset);
        int[] firstBadPointInfo = new int[]{0, 0};
        if (null != points) {
            this.curveMask = new TEOTDRCurveMask(points, offset);
            Point firstBadPoint = this.curveMask.getFirstBadPoint();
            firstBadPointInfo = this.getFirstBadPointInfo(firstBadPoint);
        }
        if (null != this.maskPanel) {
            this.maskPanel.setFirstBadPoint(firstBadPointInfo);
        } else {
            this.maskPanel = new TEOTDRMaskInfoPanel(this.teOTDRGraphModuleMgr, this.calcMaskStartPoint(), firstBadPointInfo);
        }
        this.add(this.maskPanel);
        this.parent.validate();
        this.repaint();
    }

    public void removeMask() {
        if (null == this.maskPanel) {
            return;
        }
        this.remove(this.maskPanel);
        this.curveMask = null;
        this.maskPanel = null;
        this.maskDBOffset = 0.1f;
        this.repaint();
    }

    public void resetMask() {
        TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
        if (null == this.curveMask || null == this.maskPanel || null == curveChart) {
            return;
        }
        Point[] points = curveChart.getMaskPoints(this.curveMask.getStartPos(), this.curveMask.getEndPos());
        float offset = this.calcYLength(this.maskDBOffset);
        this.curveMask.zoom(points, offset);
        this.maskPanel.reLocate(this.calcMaskStartPoint());
    }

    public void resetMaskGap() {
        float maskgap;
        TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
        if (null == this.curveMask || null == this.maskPanel || null == curveChart) {
            return;
        }
        Point[] points = curveChart.getMaskPoints(this.cursorA.getCursorPos(), this.cursorB.getCursorPos());
        this.maskDBOffset = maskgap = this.maskPanel.getMaskGap();
        this.curveMask.resetMaskGap(this.calcYLength(maskgap), points);
        this.maskPanel.setFirstBadPoint(this.getFirstBadPointInfo(this.curveMask.getFirstBadPoint()));
        this.repaint();
    }

    public boolean canShowMask() {
        TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
        if (null == curveChart) {
            return false;
        }
        Point[] points = curveChart.getMaskPoints(this.cursorA.getCursorPos(), this.cursorB.getCursorPos());
        return null != points && 0 != points.length;
    }

    private int[] getFirstBadPointInfo(Point p) {
        if (null == p || null == this.selectedFile || "".equals(this.selectedFile)) {
            return null;
        }
        TEOTDRCurveChart curve = this.curveMap.get(this.selectedFile);
        int[] firstBadPointInfo = curve.getCursorInfo(p);
        return firstBadPointInfo;
    }

    public void locateEvent(boolean isNextEvent) {
        if (null == this.selectedFile || "".equals(this.selectedFile)) {
            return;
        }
        Map<Integer, TEOTDRGraphTraceEventInfo> traceEventInfo = this.teCommonUtil.getTraceInfo(this.selectedFile).getTraceEventInfo();
        if (null == traceEventInfo || 0 == traceEventInfo.size()) {
            TEOTDRGraphToolUtil.showMessage(this, "noevent");
            return;
        }
        ArrayList<Integer> eventIdList = new ArrayList<Integer>(traceEventInfo.keySet());
        Collections.sort(eventIdList);
        int cursorLocation = 0;
        if (!isNextEvent) {
            if (this.selectedEventID == 0) {
                TEOTDRGraphToolUtil.showMessage(this, "firstevent");
                return;
            }
            cursorLocation = this.getPreEventPos(traceEventInfo, eventIdList);
        } else {
            if (this.selectedEventID == traceEventInfo.size() - 1) {
                TEOTDRGraphToolUtil.showMessage(this, "lastevent");
                return;
            }
            cursorLocation = this.getNextEventPos(traceEventInfo, eventIdList);
        }
        if (cursorLocation == -1) {
            TEOTDRGraphToolUtil.showMessage(this, "nolocateevent");
        }
        this.addEventTriangle(cursorLocation);
        this.treggerOrientEvent((Integer)eventIdList.get(this.selectedEventID));
        this.treggerCursorLocateEvent();
        this.repaint();
    }

    private int getNextEventPos(Map<Integer, TEOTDRGraphTraceEventInfo> traceEventInfo, List<Integer> eventIdList) {
        int index;
        int eventPos = 0;
        int cursorPos = this.cursorA.getCursorPos();
        int len = eventIdList.size();
        int lenOffset = this.curveMap.get(this.selectedFile).getLengthOffset();
        for (index = this.selectedEventID == -1 ? 0 : this.selectedEventID; index < len && cursorPos >= (eventPos = (int)(traceEventInfo.get(eventIdList.get(index)).getEventLocationInLine() * 1000.0)) + lenOffset; ++index) {
        }
        int n = this.selectedEventID = index >= len ? len - 1 : index;
        if (eventPos > this.viewAxisLength) {
            return -1;
        }
        this.locateCursorPos(this.cursorA, eventPos + lenOffset);
        return eventPos;
    }

    private int getPreEventPos(Map<Integer, TEOTDRGraphTraceEventInfo> traceEventInfo, List<Integer> eventIdList) {
        int index;
        int eventPos = 0;
        int cursorPos = this.cursorA.getCursorPos();
        int lenOffset = this.curveMap.get(this.selectedFile).getLengthOffset();
        for (index = eventIdList.size() - 1; index >= 0 && cursorPos <= (eventPos = (int)(traceEventInfo.get(eventIdList.get(index)).getEventLocationInLine() * 1000.0)) + lenOffset; --index) {
        }
        int n = this.selectedEventID = index <= 0 ? 0 : index;
        if (eventPos > this.viewAxisLength) {
            return -1;
        }
        this.locateCursorPos(this.cursorA, eventPos + lenOffset);
        return eventPos;
    }

    private void showEvent(String fileName, int eventNo) {
        Map<Integer, TEOTDRGraphTraceEventInfo> traceEventInfo = this.teCommonUtil.getTraceInfo(this.selectedFile).getTraceEventInfo();
        if (null == traceEventInfo || 0 == traceEventInfo.size() || null == traceEventInfo.get(eventNo)) {
            return;
        }
        int eventLength = (int)(traceEventInfo.get(eventNo).getEventLocationInLine() * 1000.0);
        if (eventLength > this.viewAxisLength) {
            TEOTDRGraphToolUtil.showMessage(this.parent, "nolocateevent");
            return;
        }
        this.addEventTriangle(eventLength);
        this.repaint();
    }

    private void locateCursorPos(TEOTDRCurveCursor cursor, int pos) {
        if ("".equals(this.selectedFile) || null == this.curveMap || !this.curveMap.containsKey(this.selectedFile)) {
            return;
        }
        TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
        int cursorPos = curveChart.getCursorInfo(pos)[0];
        cursorPos = cursorPos == 0 ? pos : cursorPos;
        cursor.setCursorPos(cursorPos);
        cursor.reset(this.getViewHeight() - 50, (int)this.calcXLength(pos) + 45, this.viewStartPoint.y);
    }

    private void shiftY(int[] cursorInfo) {
        for (Map.Entry<String, TEOTDRCurveChart> curveEntry : this.curveMap.entrySet()) {
            if (curveEntry.getKey().equals(this.selectedFile)) continue;
            curveEntry.getValue().shiftY(cursorInfo);
        }
    }

    private float calcDBLength(float y) {
        return 60.0f * y / (float)(this.getHeight() - 50);
    }

    private int calcLineLength(float x) {
        return Math.round((float)((double)this.viewAxisLength * (double)x / (double)(this.getWidth() - 165)));
    }

    private float calcYLength(float gain) {
        return (float)(this.size.height - 50) * gain / 60.0f;
    }

    private float calcXLength(int lineLength) {
        return (float)((double)(this.size.width - 165) * (double)lineLength / (double)this.viewAxisLength);
    }

    private void addEventTriangle(int eventPos) {
        TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
        int eventGraphY = curveChart.getPointYByPos(eventPos + curveChart.getLengthOffset());
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        g2d.setColor(Color.red);
        int eventGraphX = (int)(this.calcXLength(eventPos + curveChart.getLengthOffset()) + 45.0f);
        if (null != this.eventg) {
            this.eventg.setEventLength(eventPos);
            this.eventg.setLenOffset(curveChart.getLengthOffset());
            this.eventg.setNewLocation(new Point(eventGraphX, eventGraphY));
        } else {
            this.eventg = new TEOTDREventGraphic(new Point(eventGraphX, eventGraphY));
            this.eventg.setEventLength(eventPos);
            this.eventg.setLenOffset(curveChart.getLengthOffset());
        }
    }

    private void resetEventTriangle() {
        if ("".equals(this.selectedFile) || null == this.curveMap || !this.curveMap.containsKey(this.selectedFile) || null == this.eventg) {
            return;
        }
        TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
        int eventx = curveChart.getPointXByPos(this.eventg.getEventLength());
        int eventy = curveChart.getPointYByPos(this.eventg.getEventLength());
        this.eventg.setNewLocation(new Point(eventx, eventy));
    }

    public void doCoverAtAPole() {
        TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
        int[] aInfo = curveChart.getCursorInfo(this.cursorA.getCursorPos());
        if (-1 == aInfo[1]) {
            return;
        }
        this.shiftY(aInfo);
        this.repaint();
    }

    public void doCoverAtBPole() {
        TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
        int[] bInfo = curveChart.getCursorInfo(this.cursorB.getCursorPos());
        if (-1 == bInfo[1]) {
            return;
        }
        this.shiftY(bInfo);
        this.repaint();
    }

    public void doMove(Map<String, int[]> moveData) {
        if (null == moveData || 0 == moveData.size()) {
            return;
        }
        for (Map.Entry<String, TEOTDRCurveChart> curveEntry : this.curveMap.entrySet()) {
            int[] moveParam = moveData.get(curveEntry.getKey());
            curveEntry.getValue().move(this.viewStartPoint.x, this.viewStartPoint.y, moveParam[0], moveParam[1]);
        }
        this.setCursorLocation();
        if (null != this.eventg && !"".equals(this.selectedFile) && this.curveMap.containsKey(this.selectedFile)) {
            TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
            this.eventg.setLenOffset(curveChart.getLengthOffset());
            this.resetEventTriangle();
        }
        if (null != this.curveMask) {
            this.removeMask();
            TEOTDRGraphToolbarInterface tinf = this.teOTDRGraphModuleMgr.getToolbarInteractor();
            tinf.removeMask();
        }
        this.repaint();
        this.treggerCursorLocateEvent();
    }

    public void doZoom(int[] zdata) {
        if (null == zdata || 4 != zdata.length) {
            return;
        }
        this.zoomBoxStartPoint = new Point((int)this.calcXLength(zdata[2]) + 45, (int)this.calcYLength(20.0f - (float)zdata[0] / 1000.0f) + 25);
        this.zoomBoxStartLength = zdata[2];
        this.zoomBoxWidth = this.calcXLength(zdata[3] - zdata[2]);
        this.zoomBoxHeight = this.calcYLength((float)(zdata[0] - zdata[1]) / 1000.0f);
        this.canvasZoomIn();
        this.repaint();
    }

    public Map<String, int[]> getCurrentGraphMoveData() {
        HashMap<String, int[]> graphMoveMap = new HashMap<String, int[]>();
        for (Map.Entry<String, TEOTDRCurveChart> entry : this.curveMap.entrySet()) {
            int[] offsets = new int[]{(int)(entry.getValue().getDBOffset() * 1000.0f), entry.getValue().getLengthOffset()};
            graphMoveMap.put(entry.getKey(), offsets);
        }
        return graphMoveMap;
    }

    public void scrollCanvas() {
        int difx = this.getX() - this.startPoint.x;
        int dify = this.getY() - this.startPoint.y;
        if (difx != 0) {
            this.startPoint.x = this.getX();
            this.viewStartPoint.x = -this.startPoint.x;
            ((TEOTDRChartLeftAxis)this.leftAxis).setStartPoint(this.viewStartPoint);
        }
        if (dify != 0) {
            this.startPoint.y = this.getY();
            this.viewStartPoint.y = -this.startPoint.y;
            ((TEOTDRChartTopAxis)this.topAxis).setStartPoint(this.viewStartPoint);
            ((TEOTDRChartBottomAxis)this.bottomAxis).setStartPoint(this.viewStartPoint);
            this.resetCursor();
        }
        if (null != this.curveMask) {
            this.maskPanel.reLocate(this.calcMaskStartPoint());
        }
        this.repaint();
    }

    @Override
    public List<String> getOpenedFileNameList() {
        StringBuffer fileNames = new StringBuffer("");
        int len = this.openedFileList.size();
        for (int i = 0; i < len; ++i) {
            fileNames.append(this.openedFileList.get(i));
        }
        TEOTDRGraphToolUtil.log("openedFileList-->" + fileNames);
        return this.openedFileList;
    }

    public int getCurrentMaxLineLength() {
        return this.viewAxisLength;
    }

    public boolean isCompareNow() {
        return null != this.compareCurve;
    }

    public void undoCompareCurve() {
        this.removeCompareCurve();
        this.treggerCompareStatusChangeEvent(false);
        this.repaint();
    }

    private void treggerOrientEvent(int eventNo) {
        TEOTDRGraphGraphEventLocateEvent event = TEOTDRGraphGraphEventLocateEvent.getEvent();
        event.setFileName(this.selectedFile);
        event.setEventNo(eventNo);
        this.teOTDRGraphEventManager.triggerEvent(event);
    }

    private void treggerCursorLocateEvent() {
        TEOTDRGraphGraphDragPoleMovedEvent event = TEOTDRGraphGraphDragPoleMovedEvent.getEvent();
        if (this.selectedFile.equals("") || 0 == this.curveMap.size() || null == this.curveMap.get(this.selectedFile)) {
            return;
        }
        if (null == this.cursorA || null == this.cursorB) {
            return;
        }
        TEOTDRCurveChart curveChart = this.curveMap.get(this.selectedFile);
        int[] aInfo = curveChart.getCursorInfo(this.cursorA.getCursorPos());
        int n = aInfo[1] == -1 ? 0 : aInfo[1];
        aInfo[1] = n;
        int[] bInfo = curveChart.getCursorInfo(this.cursorB.getCursorPos());
        bInfo[1] = bInfo[1] == -1 ? 0 : bInfo[1];
        event.setAPos(aInfo);
        event.setBPos(bInfo);
        this.teOTDRGraphEventManager.triggerEvent(event);
    }

    private void treggerCurveChangeEvent() {
        TEOTDRGraphGraphCurveStatusChangeEvent event = TEOTDRGraphGraphCurveStatusChangeEvent.getEvent();
        this.teOTDRGraphEventManager.triggerEvent(event);
        TEOTDRGraphToolUtil.log("Graph tregger TEOTDRGraphGraphOpenedFileChangeListener!");
    }

    private void treggerCompareStatusChangeEvent(boolean isCompare) {
        TEOTDRGraphGraphChangeDifCurveStatusEvent event = TEOTDRGraphGraphChangeDifCurveStatusEvent.getEvent();
        if (isCompare) {
            event.setSelectedFileName(null);
        } else {
            event.setSelectedFileName(this.selectedFile);
        }
        this.teOTDRGraphEventManager.triggerEvent(event);
        TEOTDRGraphToolUtil.log("Dispatch TEOTDRGraphGraphChangeDifStatusEvent-->selectedFileName=" + this.selectedFile + ",isCompare=" + isCompare);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.needMenu && 16 == e.getModifiers()) {
            this.popupMenu.setVisible(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (null == this.curveMap || 0 == this.curveMap.size()) {
            return;
        }
        this.isMouseIn = true;
        if (this.isZoomIn) {
            this.setZoomMouse(e.getPoint());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    private void setZoomMouse(Point p) {
        String fileName = "res/imageresource.ini";
        ImageIcon cursorIcon = (ImageIcon)TEMarineResourceUtil.getInstance(fileName).getIcon("mousezoomin");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor cursor = toolkit.createCustomCursor(cursorIcon.getImage(), new Point(0, 0), "mousezoomin");
        this.setCursor(cursor);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (null == this.curveMap || 0 == this.curveMap.size()) {
            return;
        }
        this.isMouseIn = false;
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (null == this.curveMap || 0 == this.curveMap.size()) {
            return;
        }
        Point p = e.getPoint();
        if (!this.isZoomIn) {
            this.setCursorMoveFlg(p, true);
        } else if (4 != e.getModifiers()) {
            int x = p.x <= this.viewStartPoint.x + 45 ? this.viewStartPoint.x + 45 + 1 : p.x;
            int y = p.y <= this.viewStartPoint.y + 25 ? this.viewStartPoint.y + 25 + 1 : p.y;
            this.zoomBoxStartPoint = new Point(x, y);
            this.zoomBoxStartLength = this.calcLineLength(this.zoomBoxStartPoint.x - 45);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (null == this.curveMap || 0 == this.curveMap.size()) {
            return;
        }
        Point p = e.getPoint();
        if (this.isZoomIn && 16 == e.getModifiers()) {
            p = this.calcZoomBoxEndPoint(p);
            this.zoomBoxWidth = Math.abs(p.x - this.zoomBoxStartPoint.x);
            this.zoomBoxHeight = Math.abs(p.y - this.zoomBoxStartPoint.y);
            this.calcBoxStartPoint(p);
            if (null != this.zoomBox) {
                Graphics2D g2d = (Graphics2D)this.getGraphics();
                g2d.setXORMode(this.backgroundColor);
                g2d.draw(this.zoomBox);
            }
            this.canvasZoomIn();
        } else {
            this.setCursorMoveFlg(p, false);
        }
        if (4 == e.getModifiers() && this.needMenu) {
            this.popupMenu.show(this, e.getX(), e.getY());
        }
    }

    private void calcBoxStartPoint(Point endPoint) {
        Point p = new Point();
        p.x = endPoint.x < this.zoomBoxStartPoint.x ? endPoint.x : this.zoomBoxStartPoint.x;
        p.y = endPoint.y < this.zoomBoxStartPoint.y ? endPoint.y : this.zoomBoxStartPoint.y;
        this.zoomBoxStartPoint = p;
        this.zoomBoxStartLength = this.calcLineLength(this.zoomBoxStartPoint.x - 45);
    }

    private void canvasZoomIn() {
        if (!this.canBeZoomed()) {
            this.clearZoomBox();
            this.repaint();
            return;
        }
        float xZoomMultiple = (float)(this.getViewWidth() - 45) / this.getZoomBoxRealWidth();
        float yZoomMultiple = (float)(this.getViewHeight() - 50) / this.zoomBoxHeight;
        this.size.setSize((float)this.getCanvasRealWidth() * xZoomMultiple + 165.0f, (float)this.getCanvasRealHeight() * yZoomMultiple + 50.0f);
        this.startPoint.x -= (int)((float)(this.zoomBoxStartPoint.x - 45) * xZoomMultiple + 45.0f) - this.viewStartPoint.x;
        this.startPoint.y -= (int)((float)(this.zoomBoxStartPoint.y - 25) * yZoomMultiple + 25.0f) - this.viewStartPoint.y;
        this.viewStartPoint.x = -this.startPoint.x;
        this.viewStartPoint.y = -this.startPoint.y;
        this.chartZoomIn(xZoomMultiple, yZoomMultiple);
        this.zoomBoxStartPoint = null;
        HashMap<String, Boolean> menuStates = new HashMap<String, Boolean>();
        menuStates.put("menuzoomout", true);
        menuStates.put("restore", true);
        this.popupMenu.setMenuItemEnabled(menuStates);
    }

    private Point calcZoomBoxStartPoint(Point p) {
        int startPX = p.x > this.zoomBoxStartPoint.x ? this.zoomBoxStartPoint.x : p.x;
        int startPY = p.y > this.zoomBoxStartPoint.y ? this.zoomBoxStartPoint.y : p.y;
        return new Point(startPX, startPY);
    }

    private Point calcZoomBoxEndPoint(Point p) {
        int endPX = p.x;
        int endPY = p.y;
        if (p.x <= this.viewStartPoint.x + 45) {
            endPX = this.viewStartPoint.x + 45 + 1;
        }
        if (p.x >= this.viewStartPoint.x + this.getViewWidth()) {
            endPX = this.viewStartPoint.x + this.getViewWidth() - 1;
        }
        if (p.y <= this.viewStartPoint.y + 25) {
            endPY = this.viewStartPoint.y + 25 + 1;
        }
        if (p.y >= this.viewStartPoint.y + this.getViewHeight() - 25) {
            endPY = this.viewStartPoint.y + this.getViewHeight() - 25 - 1;
        }
        return new Point(endPX, endPY);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (null == this.curveMap || 0 == this.curveMap.size() || 4 == e.getModifiers()) {
            return;
        }
        Point p = e.getPoint();
        if (this.isZoomIn) {
            this.drawRectangle(p);
            return;
        }
        this.dragCursor(p);
    }

    private void drawRectangle(Point p) {
        Point zoomBoxEndPoint = this.calcZoomBoxEndPoint(p);
        this.zoomBoxWidth = Math.abs(zoomBoxEndPoint.x - this.zoomBoxStartPoint.x);
        this.zoomBoxHeight = Math.abs(zoomBoxEndPoint.y - this.zoomBoxStartPoint.y);
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        g2d.setColor(Color.RED);
        g2d.setXORMode(this.backgroundColor);
        Point boxRealStartPoint = this.calcZoomBoxStartPoint(zoomBoxEndPoint);
        if (null != this.zoomBox) {
            g2d.draw(this.zoomBox);
            this.zoomBox.setRect(boxRealStartPoint.x, boxRealStartPoint.y, this.zoomBoxWidth, this.zoomBoxHeight);
        } else {
            this.zoomBox = new Rectangle(boxRealStartPoint, new Dimension((int)this.zoomBoxWidth, (int)this.zoomBoxHeight));
        }
        g2d.draw(this.zoomBox);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (null == this.curveMap || 0 == this.curveMap.size()) {
            return;
        }
        Point p = e.getPoint();
        if (!(this.isZoomIn || this.aDragFlg || this.bDragFlg)) {
            this.setMouseMoveCursor(p);
        }
        this.showToolTip(p);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        if (this.getX() == this.startPoint.x && this.getY() == this.startPoint.y) {
            return;
        }
        this.scrollCanvas();
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public String getSelectedFileName() {
        return this.selectedFile;
    }

    @Override
    public void dispose() {
        this.fileDBOffsetMap = null;
        this.fileLengthOffsetMap = null;
        this.curveMap = null;
        this.openedFileList = null;
        this.compareCurve = null;
        this.teOTDRGraphEventManager.removeListener(this.selectFileListener);
        this.teOTDRGraphEventManager.removeListener(this.fileColorChangeListener);
        this.teOTDRGraphEventManager.removeListener(this.locateEventListener);
    }

    class LocateEventListener
    extends TEOTDRGraphEventTabEventLocateListener {
        LocateEventListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphEventTabEventLocateEvent tabLocateEvent = (TEOTDRGraphEventTabEventLocateEvent)event;
            try {
                TEOTDRCurveCanvas.this.showEvent(tabLocateEvent.getFileName(), tabLocateEvent.getEvtNo());
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRCurveCanvas.LocateEventListener.handleEvent() fail!", e);
            }
        }
    }

    class FileColorChangeListener
    extends TEOTDRGraphLegendChangeGraphColorListener {
        FileColorChangeListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRCurveCanvas.this.repaint();
        }
    }

    class SelectFileListener
    extends TEOTDRGraphLegendMakeFileSelectedListener {
        SelectFileListener() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphLegendMakeFileSelectedEvent selectFileEvent = (TEOTDRGraphLegendMakeFileSelectedEvent)event;
            try {
                TEOTDRCurveCanvas.this.selectFile(selectFileEvent.getFileName());
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRCurveCanvas.SelectFileListener.handleEvent() fail!", e);
            }
        }
    }
}

