/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButton;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButtonGroup;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmDoubleTextField;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventNotInitException;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphDragPoleMovedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphGraphDragPoleMovedListener;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphGraphInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TEOTDRCursorInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CURSORAStr = "A: ";
    private static final String CURSORBStr = "B: ";
    private static final String CURSORDIF = "|A-B|: ";
    private static final String LEN_UNIT = "km, ";
    private static final String GAIN_UNIT = "dB";
    private static final String SLOP_UNIT = "dB/km";
    private static final int CURSORLBL_WID = 250;
    private static final int SLOPELBL_WID = 450;
    private static final int TEXTFILD_WID = 110;
    private static final int LABEL_HIGHT = 12;
    private TEOTDRGraphGraphInterface chartInterface = null;
    private InmDoubleTextField textFieldA = null;
    private InmDoubleTextField textFieldB = new InmDoubleTextField(0.0, 9000.0, 3);
    private CursorButton submitButtonA = null;
    private CursorButton cancelButtonA = null;
    private CursorButton submitButtonB = null;
    private CursorButton cancelButtonB = null;
    private JLabel aGainLabel;
    private JLabel bGainLabel;
    private JLabel slopeLabel;
    DecimalFormat doubleFormatter = new DecimalFormat("0.000");
    public static final int DefaultWidth = 60;
    public static final int DefaultHeight = 26;
    private static final String submitStr = "\u00a1\u00cc";
    private static final String cancelStr = "\u00a1\u00c1";
    private String[] cursorValue = new String[2];
    private GraphDragPole graphDragPole;
    protected transient TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;

    public TEOTDRCursorInfoPanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.chartInterface = teOTDRGraphModuleMgr.getGraphInteractor();
        this.jbInit();
        this.initListener();
    }

    private void jbInit() {
        this.initButton();
        this.setLayout(new BorderLayout());
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.add((Component)new JLabel(CURSORAStr), new GridBagConstraints(0, 0, 2, 2, 1.0, 0.0, 17, 0, new Insets(15, 10, 15, 2), 0, 0));
        contentPane.add((Component)this.textFieldA, new GridBagConstraints(2, 0, 2, 2, 1.0, 0.0, 17, 0, new Insets(10, 2, 10, 0), 0, 0));
        contentPane.add((Component)this.submitButtonA, new GridBagConstraints(4, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(10, 0, 0, 2), 0, 0));
        contentPane.add((Component)this.cancelButtonA, new GridBagConstraints(4, 1, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 10, 2), 0, 0));
        contentPane.add((Component)this.aGainLabel, new GridBagConstraints(5, 0, 2, 2, 1.0, 0.0, 17, 0, new Insets(10, 4, 10, 10), 0, 0));
        contentPane.add((Component)new JLabel(CURSORBStr), new GridBagConstraints(7, 0, 2, 2, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 4), 0, 0));
        contentPane.add((Component)this.textFieldB, new GridBagConstraints(9, 0, 2, 2, 1.0, 0.0, 17, 0, new Insets(5, 2, 5, 0), 0, 0));
        contentPane.add((Component)this.submitButtonB, new GridBagConstraints(11, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(10, 0, 0, 2), 0, 0));
        contentPane.add((Component)this.cancelButtonB, new GridBagConstraints(11, 1, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 10, 2), 0, 0));
        contentPane.add((Component)this.bGainLabel, new GridBagConstraints(12, 0, 2, 2, 1.0, 0.0, 17, 0, new Insets(5, 2, 5, 10), 0, 0));
        contentPane.add((Component)new JLabel(CURSORDIF), new GridBagConstraints(14, 0, 2, 2, 1.0, 0.0, 17, 0, new Insets(5, 10, 5, 4), 0, 0));
        contentPane.add((Component)this.slopeLabel, new GridBagConstraints(16, 0, 2, 2, 1.0, 0.0, 17, 0, new Insets(5, 2, 5, 2), 0, 0));
        this.add((Component)contentPane, "West");
    }

    private void initButton() {
        this.textFieldA = new InmDoubleTextField(0.0, Double.MAX_VALUE, 3);
        this.textFieldA.setVisible(false);
        this.textFieldA.setSize(110, 12);
        this.textFieldA.addActionListener(new TextActionList("A"));
        this.textFieldA.addFocusListener(new TextFocusListener("A"));
        this.textFieldA.getDocument().addDocumentListener(new TextFieldDocumentListener("textFieldA"));
        this.textFieldA.setPreferredSize(new Dimension(60, 26));
        this.aGainLabel = new JLabel();
        this.bGainLabel = new JLabel();
        this.slopeLabel = new JLabel();
        this.aGainLabel.setSize(250, 12);
        this.bGainLabel.setSize(250, 12);
        this.slopeLabel.setSize(450, 12);
        this.textFieldB = new InmDoubleTextField(0.0, Double.MAX_VALUE, 3);
        this.textFieldB.setVisible(false);
        this.textFieldB.setSize(110, 12);
        this.textFieldB.addActionListener(new TextActionList("B"));
        this.textFieldB.addFocusListener(new TextFocusListener("B"));
        this.textFieldB.getDocument().addDocumentListener(new TextFieldDocumentListener("textFieldB"));
        this.textFieldB.setPreferredSize(new Dimension(60, 26));
        this.submitButtonA = new CursorButton(submitStr);
        this.submitButtonA.addActionListener(new TextActionList("A"));
        this.submitButtonA.setEnabled(false);
        this.cancelButtonA = new CursorButton(cancelStr);
        this.cancelButtonA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRCursorInfoPanel.this.cancelTextFieldInput("A");
            }
        });
        this.cancelButtonA.setEnabled(false);
        this.submitButtonB = new CursorButton(submitStr);
        this.submitButtonB.addActionListener(new TextActionList("B"));
        this.submitButtonB.setEnabled(false);
        this.cancelButtonB = new CursorButton(cancelStr);
        this.cancelButtonB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TEOTDRCursorInfoPanel.this.cancelTextFieldInput("B");
            }
        });
        this.cancelButtonB.setEnabled(false);
        InmButtonGroup group = new InmButtonGroup();
        group.add(this.submitButtonA);
        group.add(this.cancelButtonA);
        group.add(this.submitButtonB);
        group.add(this.cancelButtonB);
    }

    private void setBottonEnable(String textFieldStr, boolean isEnable) {
        if (textFieldStr.equals("textFieldA")) {
            this.submitButtonA.setEnabled(isEnable);
            this.cancelButtonA.setEnabled(isEnable);
        } else {
            this.submitButtonB.setEnabled(isEnable);
            this.cancelButtonB.setEnabled(isEnable);
        }
    }

    private void initListener() {
        this.graphDragPole = new GraphDragPole();
        this.teOTDRGraphEventManager.addListener(this.graphDragPole);
    }

    public void setCursorInfo(int[] aInfo, int[] bInfo) {
        if (aInfo.length < 2 || bInfo.length < 2) {
            return;
        }
        if (aInfo[0] == -1 || bInfo[0] == -1) {
            this.textFieldA.setText("");
            this.textFieldA.setVisible(false);
            this.aGainLabel.setText("");
            this.textFieldB.setText("");
            this.textFieldB.setVisible(false);
            this.bGainLabel.setText("");
            this.slopeLabel.setText("");
            this.cursorValue[0] = "";
            this.cursorValue[1] = "";
            return;
        }
        double textFieldAValue = (double)aInfo[0] / 1000.0;
        String textFieldAStr = this.doubleFormatter.format(textFieldAValue);
        this.textFieldA.setText(textFieldAStr);
        this.textFieldA.setVisible(true);
        this.setBottonEnable("textFieldA", false);
        double gainValue = (double)aInfo[1] / 1000.0;
        String gainStr = this.doubleFormatter.format(gainValue);
        this.aGainLabel.setText(LEN_UNIT + gainStr + GAIN_UNIT);
        double textFieldBValue = (double)bInfo[0] / 1000.0;
        String textFieldBStr = this.doubleFormatter.format(textFieldBValue);
        this.textFieldB.setText(textFieldBStr);
        this.textFieldB.setVisible(true);
        this.setBottonEnable("textFieldB", false);
        gainValue = (double)bInfo[1] / 1000.0;
        gainStr = this.doubleFormatter.format(gainValue);
        this.bGainLabel.setText(LEN_UNIT + gainStr + GAIN_UNIT);
        this.cursorValue[0] = textFieldAStr;
        this.cursorValue[1] = textFieldBStr;
        double difL = (double)Math.abs(aInfo[0] - bInfo[0]) / 1000.0;
        double difG = (double)Math.abs(aInfo[1] - bInfo[1]) / 1000.0;
        double slope = 0.0;
        String slopeStr = "";
        String slopeLabelStr = String.valueOf(difL) + LEN_UNIT + difG + GAIN_UNIT + slopeStr;
        if (0.0 != difL) {
            slope = difG / difL;
            slopeStr = this.doubleFormatter.format(slope);
            slopeLabelStr = slopeLabelStr + ", " + slopeStr + SLOP_UNIT;
        }
        this.slopeLabel.setText(slopeLabelStr);
    }

    public void submitTextFiledInput(String cursorStr, String inputStr) {
        TECommonUtil.log("TEOTDRCurSorInfoPanel.submitTextFiledInput()", "cursorStr is: " + cursorStr + " inputStr is: " + inputStr);
        if (null == inputStr || "".equals(inputStr)) {
            return;
        }
        double doubleValue = Double.valueOf(inputStr);
        int intValue = (int)(doubleValue * 1000.0);
        this.chartInterface.setCursorPos(cursorStr, intValue);
    }

    private void cancelTextFieldInput(String cursorStr) {
        if ("A".equals(cursorStr)) {
            this.textFieldA.setText(this.cursorValue[0]);
            this.setBottonEnable("textFieldA", false);
        } else {
            this.textFieldB.setText(this.cursorValue[1]);
            this.setBottonEnable("textFieldB", false);
        }
    }

    public void dispose() {
        this.teOTDRGraphEventManager.removeListener(this.graphDragPole);
    }

    class CursorButton
    extends InmButton {
        private static final long serialVersionUID = 1L;
        private static final int BUTTON_WIDTH = 20;
        private static final int BUTTON_HEIGHT = 13;

        public CursorButton(String text) {
            super(text, null);
            this.resetButtonSize();
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            this.resetButtonSize();
        }

        private void resetButtonSize() {
            this.setMargin(new Insets(0, 0, 0, 0));
            Dimension setedSize = new Dimension(20, 13);
            this.setSize(setedSize);
            this.setMaximumSize(setedSize);
            this.setMinimumSize(setedSize);
            this.setWidth(20);
            this.setHeight(13);
        }
    }

    class TextFieldDocumentListener
    implements DocumentListener {
        private String textFieldName;

        public TextFieldDocumentListener(String textFieldName) {
            this.textFieldName = textFieldName;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.doSetEnable();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.doSetEnable();
        }

        private void doSetEnable() {
            TEOTDRCursorInfoPanel.this.setBottonEnable(this.textFieldName, true);
        }
    }

    class TextFocusListener
    implements FocusListener {
        private String cursorStr = null;

        public TextFocusListener(String cursorStr) {
            this.cursorStr = cursorStr;
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    class TextActionList
    implements ActionListener {
        private String cursorStr = null;

        public TextActionList(String cursorStr) {
            this.cursorStr = cursorStr;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String inputStr = null;
            if ("A".equals(this.cursorStr)) {
                inputStr = TEOTDRCursorInfoPanel.this.textFieldA.getText();
                TEOTDRCursorInfoPanel.this.setBottonEnable("textFieldA", false);
            } else {
                inputStr = TEOTDRCursorInfoPanel.this.textFieldB.getText();
                TEOTDRCursorInfoPanel.this.setBottonEnable("textFieldB", false);
            }
            TEOTDRCursorInfoPanel.this.submitTextFiledInput(this.cursorStr, inputStr);
        }
    }

    class GraphDragPole
    extends TEOTDRGraphGraphDragPoleMovedListener {
        GraphDragPole() {
        }

        @Override
        public void handleEvent(TEOTDRGraphEvent event) {
            TEOTDRGraphGraphDragPoleMovedEvent dragEvent = (TEOTDRGraphGraphDragPoleMovedEvent)event;
            try {
                int lineLen = TEOTDRCursorInfoPanel.this.chartInterface.getCurrentLineRange();
                String lineLenStr = TEOTDRCursorInfoPanel.this.doubleFormatter.format((float)lineLen / 1000.0f);
                double doubleLineLen = Double.parseDouble(lineLenStr);
                TEOTDRCursorInfoPanel.this.textFieldA.setRange(0.0, doubleLineLen);
                TEOTDRCursorInfoPanel.this.textFieldB.setRange(0.0, doubleLineLen);
                TEOTDRCursorInfoPanel.this.setCursorInfo(dragEvent.getAPos(), dragEvent.getBPos());
            }
            catch (TEOTDRGraphEventNotInitException e) {
                TEAppletLogMgr.error("TEOTDRCursorInfoPanel.GraphDragPole.handleEvent() fail!", e);
            }
        }
    }
}

