/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TEOTDRChartTopAxis
extends JLabel {
    private static final long LENGTHUNIT_CHANGE_POINT = 3000L;
    private int width;
    private int height;
    private int axisWidth;
    private int lineLength;
    private int viewLineLength;
    private int axisLineLength;
    private String unit = "km";
    private float axisStep;
    private int lineStep;
    private Point startPoint;

    public TEOTDRChartTopAxis(Point startPoint, int graphWidth, int lineLength) {
        this.initAxisInfo(startPoint, graphWidth, lineLength);
        this.initAxisRule(lineLength);
        this.initTopAxisAttr();
    }

    private void initAxisInfo(Point startPoint, int graphWidth, int lineLength) {
        this.width = graphWidth - 40;
        this.height = 25;
        this.axisWidth = this.width - 5 - 120;
        this.lineLength = lineLength;
        this.startPoint = this.calcStartPoint(startPoint);
        this.width = this.width <= 0 ? 1 : this.width;
        this.axisWidth = this.axisWidth <= 0 ? 1 : this.axisWidth;
    }

    private void initAxisRule(int viewLineLength) {
        this.viewLineLength = viewLineLength;
        this.setUnit();
        this.calcStep();
    }

    private void initTopAxisAttr() {
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
        this.setOpaque(true);
        this.setBackground(TEOTDRGraphicConstants.GAPCOLOR);
    }

    private void setUnit() {
        this.unit = (long)this.viewLineLength >= 3000L ? "km" : "m";
    }

    public String getUnit() {
        return this.unit;
    }

    private void calcStep() {
        int divisor = 1;
        int quotient = this.viewLineLength / divisor;
        int i = 0;
        while (quotient > 10) {
            quotient = this.viewLineLength / (divisor *= 10);
            ++i;
        }
        this.lineStep = quotient >= 3 ? (int)Math.pow(10.0, i) : 5 * (int)Math.pow(10.0, i - 1);
        this.lineStep = this.lineStep <= 0 ? 1 : this.lineStep;
        int strNum = this.calcAxisSectNum();
        this.axisStep = (float)this.axisWidth / (float)strNum;
        this.axisLineLength = this.lineStep * strNum;
    }

    public int getAxisLineLength() {
        return this.axisLineLength;
    }

    private Point calcStartPoint(Point pStartPoint) {
        int x = 40;
        int y = pStartPoint.y;
        return new Point(x, y);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawAxisString(g);
    }

    private void drawAxisString(Graphics g) {
        int strNum = this.calcAxisSectNum();
        int sectLength = 0;
        float xi = 5.0f;
        int yi = 13;
        g.setFont(TEOTDRGraphicConstants.FONT);
        String axisStr = String.valueOf(sectLength) + this.unit;
        g.drawString(axisStr, (int)xi, yi);
        for (int i = 1; i <= strNum; ++i) {
            axisStr = this.unit.equals("km") ? String.valueOf(sectLength / 1000) : String.valueOf(sectLength += this.lineStep);
            g.drawString(axisStr, (int)(xi += this.axisStep), yi);
        }
    }

    private int calcAxisSectNum() {
        int strNum = this.lineLength / this.lineStep;
        if (this.lineLength % this.lineStep > 0) {
            ++strNum;
        }
        return strNum;
    }

    public void changeAxis(Point startPoint, int graphWidth, int viewLineLength) {
        this.initAxisInfo(startPoint, graphWidth, this.lineLength);
        this.initAxisRule(viewLineLength);
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
    }

    public void changeAxis(int graphWidth, int lineLength, int viewLineLength) {
        this.initAxisInfo(this.startPoint, graphWidth, lineLength);
        this.initAxisRule(viewLineLength);
        this.setSize(new Dimension(this.width, this.height));
    }

    public void setStartPoint(Point startPoint) {
        this.startPoint = this.calcStartPoint(startPoint);
        this.setLocation(this.startPoint);
    }

    public int getViewLineLength() {
        return this.viewLineLength;
    }

    public static void main(String[] arg) {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        panel.setLayout(null);
        frame.getContentPane().add((Component)panel, "Center");
        frame.setVisible(true);
        frame.setExtendedState(6);
        frame.setDefaultCloseOperation(3);
    }
}

