/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JLabel;

public class TEOTDRChartRepeaterAxis
extends JLabel {
    private static final int MASK_LENGTH = 4;
    private int width;
    private int height;
    private Point startPoint;
    private float[] repeaterGains;
    private String[] repeaterNames;

    public TEOTDRChartRepeaterAxis(int graphWidth, int graphHeight, float[] repeaterGains, String[] repeaterNames) {
        this.setAxisBasicInfo(graphWidth, graphHeight, repeaterGains);
        this.setRepeaterNames(repeaterNames);
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
        this.setBackground(TEOTDRGraphicConstants.GAPCOLOR);
        this.setOpaque(true);
    }

    private void setRepeaterNames(String[] repeaterNames) {
        if (null == repeaterNames || repeaterNames.length < 1) {
            this.repeaterNames = null;
            return;
        }
        this.repeaterNames = repeaterNames;
    }

    private void setAxisBasicInfo(int graphWidth, int graphHeight, float[] repeaterGains) {
        this.width = null == repeaterGains ? graphWidth - 40 : repeaterGains.length * 86 + 120 + 5;
        if (this.width < graphWidth) {
            this.width = graphWidth - 40;
        }
        this.height = 25;
        this.startPoint = new Point(40, graphHeight - 25);
        this.repeaterGains = repeaterGains;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawRepeaterAxis(g);
        this.drawAxisHead(g);
        this.drawAxisDetail(g);
    }

    private void drawRepeaterAxis(Graphics g) {
        int startx = 0;
        int starty = 4;
        g.drawLine(startx, starty, startx + this.width, starty);
    }

    private void drawAxisHead(Graphics g) {
        String REPEATERID = "RepeaterID";
        int ANGLE_NUM = 3;
        int TRIHEIGHT = 12;
        int TRBOTTOMLEN = 8;
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        int nPoints = 3;
        int xi = this.width;
        int yi = 4;
        xPoints[0] = xi;
        yPoints[0] = yi;
        xPoints[1] = xi -= 12;
        yPoints[1] = yi += 4;
        xPoints[2] = xi;
        yPoints[2] = yi -= 8;
        g.drawPolygon(xPoints, yPoints, nPoints);
        g.fillPolygon(xPoints, yPoints, nPoints);
        g.drawString("RepeaterID", this.width - 65, 20);
    }

    private void drawAxisDetail(Graphics g) {
        if (null == this.repeaterGains || 0 == this.repeaterGains.length) {
            return;
        }
        int startx = 5;
        int starty = 4;
        int xi = 0;
        int yi = starty;
        g.setFont(TEOTDRGraphicConstants.FONT);
        int len = this.repeaterGains.length;
        for (int i = 0; i < len; ++i) {
            xi = startx + (i + 1) * 86;
            g.drawLine(xi, yi, xi, yi - 4);
            String scaleStr = "";
            scaleStr = null != this.repeaterNames && !this.repeaterNames[i].equals("") ? this.repeaterNames[i] : String.valueOf(i + 1);
            g.drawString(scaleStr, xi - 3, yi + 12);
        }
    }

    public void changeAxisRpt(float[] repeaterGains) {
        this.setAxisBasicInfo(this.width, this.height, repeaterGains);
        this.repaint();
    }

    public void changeAxisRpt(int graphWidth, int graphHeight) {
        this.setAxisBasicInfo(graphWidth, graphHeight, this.repeaterGains);
        this.setLocation(this.startPoint);
        this.repaint();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public int getRepeaterGainNum() {
        if (null != this.repeaterGains) {
            return this.repeaterGains.length;
        }
        return 0;
    }
}

