/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphGraphInterface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TEOTDRChartPopupMenu
extends JPopupMenu {
    Map<String, MenuItemInfo> menuItemMap = new HashMap<String, MenuItemInfo>();
    TEMarineResourceUtil resource = TEMarineResourceUtil.getInstance("res" + File.separator + "stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    TEOTDRGraphGraphInterface graphInterface = null;

    public TEOTDRChartPopupMenu(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr) {
        this.graphInterface = teOTDRGraphModuleMgr.getGraphInteractor();
        this.initMenuItem();
    }

    private void initMenuItem() {
        MenuItemInfo itemInfo = new MenuItemInfo("startpartzoom", new JMenuItem(this.resource.getString("startpartzoom")), true, new StartZoomIn());
        itemInfo.setStandbyName("stoppartzoom");
        itemInfo.setStandbyAction(new StopZoomIn());
        this.add(itemInfo.getMenuItem());
        this.menuItemMap.put(itemInfo.getItemName(), itemInfo);
        itemInfo = new MenuItemInfo("menuzoomout", new JMenuItem(this.resource.getString("menuzoomout")), false, new ZoomOut());
        this.add(itemInfo.getMenuItem());
        this.menuItemMap.put(itemInfo.getItemName(), itemInfo);
        itemInfo = new MenuItemInfo("restore", new JMenuItem(this.resource.getString("restore")), false, new Retore());
        this.add(itemInfo.getMenuItem());
        this.menuItemMap.put(itemInfo.getItemName(), itemInfo);
        itemInfo = new MenuItemInfo("menulock", new JMenuItem(this.resource.getString("menulock")), true, new BindCursor());
        this.add(itemInfo.getMenuItem());
        this.menuItemMap.put(itemInfo.getItemName(), itemInfo);
        itemInfo = new MenuItemInfo("menuunlock", new JMenuItem(this.resource.getString("menuunlock")), false, new UnBindCursor());
        this.add(itemInfo.getMenuItem());
        this.menuItemMap.put(itemInfo.getItemName(), itemInfo);
    }

    public void changeMenuItem(String itemName, boolean isStandby) {
        if (null == this.menuItemMap.get(itemName)) {
            return;
        }
        MenuItemInfo itemInfo = this.menuItemMap.get(itemName);
        if (isStandby) {
            itemInfo.useStandbyAction();
        } else {
            itemInfo.restoreAction();
        }
    }

    public void setMenuItemEnabled(Map<String, Boolean> itemEnabledMap) {
        if (null == itemEnabledMap || 0 == itemEnabledMap.size()) {
            return;
        }
        for (Map.Entry<String, Boolean> entry : itemEnabledMap.entrySet()) {
            MenuItemInfo itemInfo = this.menuItemMap.get(entry.getKey());
            itemInfo.setEnabled(entry.getValue());
            itemInfo.getMenuItem().setEnabled(entry.getValue());
        }
    }

    class UnBindCursor
    implements ActionListener {
        UnBindCursor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TEOTDRChartPopupMenu.this.graphInterface.unBindingCursor();
        }
    }

    class BindCursor
    implements ActionListener {
        BindCursor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TEOTDRChartPopupMenu.this.graphInterface.bindingCursor();
        }
    }

    class Retore
    implements ActionListener {
        Retore() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TEOTDRChartPopupMenu.this.graphInterface.doRestoreGraph();
        }
    }

    class ZoomOut
    implements ActionListener {
        ZoomOut() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TEOTDRChartPopupMenu.this.graphInterface.doZoomOut();
        }
    }

    class StopZoomIn
    implements ActionListener {
        StopZoomIn() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TEOTDRChartPopupMenu.this.graphInterface.doStopPartZoom();
        }
    }

    class StartZoomIn
    implements ActionListener {
        StartZoomIn() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TEOTDRChartPopupMenu.this.graphInterface.doStartPartZoom();
        }
    }

    class MenuItemInfo {
        private String itemName;
        private JMenuItem menuItem;
        private boolean isEnabled = true;
        private String standbyName;
        private ActionListener action;
        private ActionListener standbyAction;

        MenuItemInfo() {
        }

        MenuItemInfo(String itemName, JMenuItem menuItem, boolean isEnabled, ActionListener action) {
            this.itemName = itemName;
            this.menuItem = menuItem;
            this.action = action;
            this.menuItem.addActionListener(this.action);
            this.isEnabled = isEnabled;
            this.menuItem.setEnabled(this.isEnabled);
        }

        public void useStandbyAction() {
            if (null == this.standbyName || null == this.standbyAction) {
                return;
            }
            this.menuItem.setText(TEOTDRChartPopupMenu.this.resource.getString(this.standbyName));
            this.menuItem.removeActionListener(this.action);
            this.menuItem.addActionListener(this.standbyAction);
        }

        public void restoreAction() {
            this.menuItem.setText(TEOTDRChartPopupMenu.this.resource.getString(this.itemName));
            this.menuItem.removeActionListener(this.standbyAction);
            this.menuItem.addActionListener(this.action);
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public JMenuItem getMenuItem() {
            return this.menuItem;
        }

        public void setMenuItem(JMenuItem menuItem) {
            this.menuItem = menuItem;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public String getStandbyName() {
            return this.standbyName;
        }

        public void setStandbyName(String standbyName) {
            this.standbyName = standbyName;
        }

        public ActionListener getAction() {
            return this.action;
        }

        public void setAction(ActionListener action) {
            this.action = action;
        }

        public ActionListener getStandbyAction() {
            return this.standbyAction;
        }

        public void setStandbyAction(ActionListener standbyAction) {
            this.standbyAction = standbyAction;
        }
    }
}

