/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TEOTDRChartLeftAxis
extends JLabel {
    private static final int AXISOFFSET = 27;
    private static final int STROPTIONOFFSET = 4;
    private static final int LONG_MASK = 7;
    private static final int MEDIEM_MASK = 4;
    private static final int SHORT_MASK = 2;
    private static final int BOTTOM_MASK = 4;
    private int width;
    private int height;
    private int axisLineHeight;
    private int axisHeight;
    private float viewdBRange;
    private int viewAxisHeight;
    private float axisStep;
    private float dBStep;
    private Point startPoint;
    private float maxGain = 20.0f;
    private float minGain = -40.0f;
    private float gainRange = 60.0f;
    private boolean isRepeaterChart = false;

    public TEOTDRChartLeftAxis(Point startPoint, int graphHeight, int viewHeight) {
        this.calcAxisInfo(startPoint, graphHeight, viewHeight);
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
        this.setBackground(TEOTDRGraphicConstants.GAPCOLOR);
        this.setOpaque(true);
    }

    public TEOTDRChartLeftAxis(Point startPoint, int graphHeight, int viewHeight, float[] rangeData) {
        if (null != rangeData && rangeData.length >= 2) {
            this.maxGain = rangeData[0];
            this.minGain = rangeData[1];
            this.gainRange = this.maxGain - this.minGain;
        }
        this.calcAxisInfo(startPoint, graphHeight, viewHeight);
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
        this.setBackground(TEOTDRGraphicConstants.GAPCOLOR);
        this.setOpaque(true);
    }

    public TEOTDRChartLeftAxis(Point startPoint, int graphHeight, int viewHeight, boolean isRepeaterChart) {
        if (isRepeaterChart) {
            this.maxGain = 40.0f;
            this.minGain = 0.0f;
            this.gainRange = 40.0f;
        }
        this.calcAxisInfo(startPoint, graphHeight, viewHeight, isRepeaterChart);
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
        this.setBackground(TEOTDRGraphicConstants.GAPCOLOR);
        this.setOpaque(true);
    }

    private void calcAxisInfo(Point startPoint, int graphHeight, int viewHeight, boolean isRepeaterChart) {
        this.width = 40;
        this.height = graphHeight;
        this.axisLineHeight = isRepeaterChart ? this.height - 57 + 4 : this.height - 25 + 4;
        this.startPoint = this.calcStartPoint(startPoint);
        this.axisHeight = this.axisLineHeight - 25 - 4;
        this.setAxisViewHeight(viewHeight);
        this.calcStep();
    }

    private void calcAxisInfo(Point startPoint, int graphHeight, int viewHeight) {
        this.calcAxisInfo(startPoint, graphHeight, viewHeight, false);
    }

    private void calcStep() {
        double divisor = 0.1;
        double quotient = (double)this.viewdBRange / divisor;
        int i = -1;
        while (quotient > 10.0) {
            quotient = (double)this.viewdBRange / (divisor *= 10.0);
            ++i;
        }
        this.dBStep = quotient >= 3.0 ? (float)Math.pow(10.0, i) : 5.0f * (float)Math.pow(10.0, i - 1);
        int strNum = this.calcAxisSectNum();
        this.axisStep = (float)this.axisHeight / (float)strNum;
    }

    private int calcAxisSectNum() {
        int strNum = (int)(this.gainRange / this.dBStep);
        return strNum;
    }

    private Point calcStartPoint(Point pStartPoint) {
        int x = pStartPoint.x;
        int y = 0;
        return new Point(x, y);
    }

    private void setAxisViewHeight(int viewHeight) {
        this.viewAxisHeight = viewHeight - 25 - 25;
        this.viewdBRange = (float)((double)(this.gainRange * (float)this.viewAxisHeight) / (double)this.axisHeight);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawAxisHead(g);
        this.drawDBAxis(g);
        this.drawAxisDetail(g);
    }

    private void drawAxisHead(Graphics g) {
        String DB_UNIT = "dB";
        int ANGLE_NUM = 3;
        int TRIHEIGHT = 12;
        int TRBOTTOMLEN = 8;
        int STR_X_OFFSET = 3;
        int STR_Y_OFFSET = 13;
        g.drawString("dB", 3, 13);
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        int nPoints = 3;
        int xi = 27;
        int yi = 0;
        xPoints[0] = xi;
        yPoints[0] = yi;
        xPoints[1] = xi += 4;
        yPoints[1] = yi += 12;
        xPoints[2] = xi -= 8;
        yPoints[2] = yi;
        g.drawPolygon(xPoints, yPoints, nPoints);
        g.fillPolygon(xPoints, yPoints, nPoints);
    }

    private void drawDBAxis(Graphics g) {
        Point p = new Point(27, this.startPoint.y);
        g.drawLine(p.x, p.y, p.x, p.y + this.axisLineHeight);
        g.drawLine(p.x, p.y + this.axisLineHeight, p.x + (this.width - 27), p.y + this.axisLineHeight);
    }

    private void drawAxisDetail(Graphics g) {
        int strNum = this.calcAxisSectNum();
        float sectLength = this.maxGain;
        int xi = 2;
        float yi = 25.0f;
        g.setFont(TEOTDRGraphicConstants.FONT);
        String axisStr = String.valueOf(sectLength);
        g.drawString(axisStr, xi, (int)yi + 4);
        g.drawLine(xi + 27, (int)yi, xi + 27 + 7, (int)yi);
        for (int i = 1; i <= strNum; ++i) {
            this.drawShortLine(g, xi + 27, yi);
            axisStr = this.getAxisString(sectLength -= this.dBStep);
            g.drawString(axisStr, xi, (int)(yi += this.axisStep) + 4);
        }
    }

    private String getAxisString(float sectLength) {
        DecimalFormat doubleFormatter = new DecimalFormat("0.0");
        String axisStr = doubleFormatter.format(sectLength);
        axisStr = axisStr.equals("-0.0") ? "0.0" : axisStr;
        return axisStr;
    }

    private void drawShortLine(Graphics g, int x, float y) {
        int len = 5;
        if (this.dBStep % 10.0f == 0.0f) {
            len = 10;
        }
        float shortLineStep = this.axisStep / (float)len;
        int xi = x;
        int yi = (int)y;
        for (int i = 0; i < len; ++i) {
            yi = (int)(shortLineStep * (float)(i + 1) + y);
            if (i + 1 == len) {
                g.drawLine(xi, yi, xi + 7, yi);
                break;
            }
            if ((i + 1) % 5 == 0 && (i + 1) % 10 != 0) {
                g.drawLine(xi, yi, xi + 4, yi);
                continue;
            }
            g.drawLine(xi, yi, xi + 2, yi);
        }
    }

    public void changeAxis(Point startPoint, int graphHeight, int viewHeight) {
        this.changeAxis(startPoint, graphHeight, viewHeight, false);
    }

    public void changeAxis(Point startPoint, int graphHeight, int viewHeight, boolean isRepeaterChart) {
        this.calcAxisInfo(startPoint, graphHeight, viewHeight, isRepeaterChart);
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
        this.update(this.getGraphics());
    }

    public void setStartPoint(Point startPoint) {
        this.startPoint = this.calcStartPoint(startPoint);
        this.setLocation(this.startPoint);
    }

    public static void main(String[] arg) {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        panel.setLayout(null);
        frame.getContentPane().add((Component)panel, "Center");
        TEOTDRChartLeftAxis leftAxis = new TEOTDRChartLeftAxis(new Point(0, 20), 900, 900);
        panel.add(leftAxis);
        frame.setVisible(true);
        frame.setExtendedState(6);
        frame.setDefaultCloseOperation(3);
    }
}

