/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.graphics;

import com.huawei.nglct.otdr.appletgraph.graphics.TEOTDRGraphicConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TEOTDRChartBottomAxis
extends JLabel {
    private static final int MASK_LENGTH = 4;
    private int width;
    private int height;
    private int axisLineLength;
    private Point startPoint;
    private int viewHeight;
    private int[] repeaterPositions;
    private String[] repeaterNames;

    public TEOTDRChartBottomAxis(Point startPoint, int graphWidth, int lineLength, int graphHeight, int[] repeaterPositions, String[] repeaterNames) {
        this.setRepeaterPosInfo(repeaterPositions);
        this.setRepeaterNames(repeaterNames);
        this.setAxisBasicInfo(startPoint, graphWidth, lineLength, graphHeight);
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
        this.setOpaque(true);
        this.setBackground(TEOTDRGraphicConstants.GAPCOLOR);
    }

    public void setRepeaterNames(String[] repeaterNames) {
        if (null == repeaterNames || repeaterNames.length < 1) {
            this.repeaterNames = null;
            return;
        }
        this.repeaterNames = repeaterNames;
    }

    private void setAxisBasicInfo(Point startPoint, int graphWidth, int lineLength, int viewHeight) {
        this.width = graphWidth - 40;
        this.height = 25;
        this.axisLineLength = lineLength;
        this.viewHeight = viewHeight;
        this.startPoint = new Point(40, startPoint.y + viewHeight - 25);
    }

    private void setRepeaterPosInfo(int[] repeaterPositions) {
        if (null == repeaterPositions || repeaterPositions.length <= 1) {
            this.repeaterPositions = null;
            return;
        }
        int tmpRptPos = repeaterPositions[1];
        int lastExitRptIndex = repeaterPositions.length - 1;
        int len = repeaterPositions.length;
        for (int i = 2; i < len; ++i) {
            if (repeaterPositions[i] - tmpRptPos <= 0) {
                lastExitRptIndex = i - 1;
                break;
            }
            tmpRptPos = repeaterPositions[i];
        }
        this.repeaterPositions = new int[lastExitRptIndex];
        System.arraycopy(repeaterPositions, 1, this.repeaterPositions, 0, lastExitRptIndex);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawRepeaterAxis(g);
        this.drawAxisHead(g);
        this.drawAxisDetail(g);
    }

    private void drawRepeaterAxis(Graphics g) {
        int startx = 0;
        int starty = 4;
        g.drawLine(startx, starty, startx + this.width, starty);
    }

    private void drawAxisHead(Graphics g) {
        String REPEATERID = "RepeaterID";
        int ANGLE_NUM = 3;
        int TRIHEIGHT = 12;
        int TRBOTTOMLEN = 8;
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        int nPoints = 3;
        int xi = this.width;
        int yi = 4;
        xPoints[0] = xi;
        yPoints[0] = yi;
        xPoints[1] = xi -= 12;
        yPoints[1] = yi += 4;
        xPoints[2] = xi;
        yPoints[2] = yi -= 8;
        g.drawPolygon(xPoints, yPoints, nPoints);
        g.fillPolygon(xPoints, yPoints, nPoints);
        g.drawString("RepeaterID", this.width - 65, 20);
    }

    private void drawAxisDetail(Graphics g) {
        if (null == this.repeaterPositions || 0 == this.repeaterPositions.length) {
            return;
        }
        int axisWidth = this.width - 5 - 120;
        int startx = 5;
        int starty = 4;
        int xi = 0;
        int yi = starty;
        g.setFont(TEOTDRGraphicConstants.FONT);
        if (0 == this.axisLineLength) {
            return;
        }
        int index = 0;
        int len = this.repeaterPositions.length;
        for (int i = 0; i < len; ++i) {
            xi = startx + (int)((long)axisWidth * (long)this.repeaterPositions[i] / (long)this.axisLineLength);
            g.drawLine(xi, yi, xi, yi - 4);
            String scaleStr = "";
            if (this.repeaterNames != null && this.repeaterNames.length > i) {
                if (this.repeaterNames[i] == null) {
                    scaleStr = "";
                } else if ("".equals(this.repeaterNames[i])) {
                    scaleStr = String.valueOf(index + 1);
                    ++index;
                } else {
                    scaleStr = this.repeaterNames[i];
                }
            }
            g.drawString(scaleStr, xi - 3, yi + 12);
        }
    }

    public void changeAxis(Point startPoint, int graphWidth, int graphHeight, int axisLineLength) {
        this.setAxisBasicInfo(startPoint, graphWidth, axisLineLength, graphHeight);
        this.setLocation(this.startPoint);
        this.setSize(new Dimension(this.width, this.height));
    }

    public void changeAxisRpt(int[] repeaterPositions, int linelength) {
        this.setRepeaterPosInfo(repeaterPositions);
        this.axisLineLength = linelength;
        this.repaint();
    }

    public void setStartPoint(Point startPoint) {
        this.startPoint = new Point(40, startPoint.y + this.viewHeight - 25);
        this.setLocation(this.startPoint);
    }

    public static void main(String[] arg) {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout());
        frame.getContentPane().add((Component)panel, "Center");
        int[] repeaterPositions = new int[]{100000, 200000, 300000};
        String[] repeaterNames = new String[]{"111", "222", "333"};
        TEOTDRChartBottomAxis bottomAxis = new TEOTDRChartBottomAxis(new Point(0, 20), 1200, 500000, 900, repeaterPositions, repeaterNames);
        panel.add(bottomAxis);
        frame.setVisible(true);
        frame.setExtendedState(6);
        frame.setDefaultCloseOperation(3);
    }
}

