/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.filetree.menu;

import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEMultiSelectTreeNode;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEObjectCheckBoxTree;
import com.huawei.nglct.otdr.appletgraph.filetree.TEOTDRFileTreePanel;
import com.huawei.nglct.otdr.appletgraph.filetree.menu.FileTreeMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class FileOpenMenuItem
implements FileTreeMenuItem {
    private TEMarineResourceUtil menuResUtil = TEMarineResourceUtil.getInstance("res/filetreemenu_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    TEOTDRFileTreePanel panel = null;
    private TEMultiSelectTreeNode curNode = null;
    private List<TEMultiSelectTreeNode> openNodeList = null;
    private JMenuItem openItem = null;

    public FileOpenMenuItem(final TEOTDRFileTreePanel panel, TEMultiSelectTreeNode node) {
        this.panel = panel;
        this.openItem = new JMenuItem(this.menuResUtil.getString("OPEN"));
        this.openNodeList = new ArrayList<TEMultiSelectTreeNode>();
        this.curNode = node;
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.handleOpenFileEvent(FileOpenMenuItem.this.openNodeList);
            }
        });
    }

    @Override
    public JMenuItem getItem(boolean isEnabled) {
        TEObjectCheckBoxTree tree = this.panel.getSelectObjTree();
        ArrayList<TEMultiSelectTreeNode> selectedFileList = tree.getSelectedFileNodes();
        if (selectedFileList.size() > 3 || !this.canOpen(selectedFileList)) {
            this.openItem.setEnabled(false);
        } else {
            this.openItem.setEnabled(isEnabled);
        }
        return this.openItem;
    }

    private boolean canOpen(List<TEMultiSelectTreeNode> selectedFileList) {
        this.openNodeList = new ArrayList<TEMultiSelectTreeNode>();
        TEObjectCheckBoxTree tree = this.panel.getSelectObjTree();
        ArrayList<TEMultiSelectTreeNode> openedFileList = tree.getOpenedFileNodes();
        if (null == openedFileList || openedFileList.size() >= 3) {
            return false;
        }
        if (null == selectedFileList || 0 == selectedFileList.size()) {
            return false;
        }
        for (TEMultiSelectTreeNode selectedNode : selectedFileList) {
            if (openedFileList.contains(selectedNode)) continue;
            this.openNodeList.add(selectedNode);
        }
        if (0 == this.openNodeList.size() || this.openNodeList.size() > 3) {
            return false;
        }
        return this.openNodeList.size() + openedFileList.size() <= 3;
    }
}

