/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.filetree.menu;

import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEMultiSelectTreeNode;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEObjectCheckBoxTree;
import com.huawei.nglct.otdr.appletgraph.filetree.TEOTDRFileTreePanel;
import com.huawei.nglct.otdr.appletgraph.filetree.menu.FileTreeMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JMenuItem;

public class FileDeleteMenuItem
implements FileTreeMenuItem {
    private TEMarineResourceUtil menuResUtil = TEMarineResourceUtil.getInstance("res/filetreemenu_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    TEOTDRFileTreePanel panel = null;
    private TEMultiSelectTreeNode curNode = null;
    JMenuItem item = null;

    public FileDeleteMenuItem(final TEOTDRFileTreePanel panel, TEMultiSelectTreeNode node) {
        this.panel = panel;
        this.curNode = node;
        this.item = new JMenuItem(this.menuResUtil.getString("DELETE"));
        this.item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.handleDeleteFileEvent();
            }
        });
    }

    @Override
    public JMenuItem getItem(boolean isEnabled) {
        TEObjectCheckBoxTree tree = this.panel.getSelectObjTree();
        ArrayList<TEMultiSelectTreeNode> selectedFileList = tree.getSelectedFileNodes();
        this.item.setEnabled(isEnabled);
        if (selectedFileList.size() == 0 || !selectedFileList.contains(this.curNode)) {
            this.item.setEnabled(false);
        }
        if (!this.panel.isViewTestRecordView()) {
            HashMap<String, String> fileNameParamMap = null;
            for (String selectedFileName : this.panel.getSelectedFileNameList()) {
                fileNameParamMap = TECommonUtil.getParamMapFromFileName(selectedFileName, false);
                boolean isBaseline = "1".equals(fileNameParamMap.get("baseline"));
                if (!isBaseline) continue;
                this.item.setEnabled(false);
                break;
            }
        }
        return this.item;
    }
}

