/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.filetree.menu;

import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEMultiSelectTreeNode;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEObjectCheckBoxTree;
import com.huawei.nglct.otdr.appletgraph.filetree.TEOTDRFileTreePanel;
import com.huawei.nglct.otdr.appletgraph.filetree.menu.FileTreeMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class FileCloseMenuItem
implements FileTreeMenuItem {
    private TEMarineResourceUtil menuResUtil = TEMarineResourceUtil.getInstance("res/filetreemenu_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    TEOTDRFileTreePanel panel = null;
    private TEMultiSelectTreeNode curNode = null;
    private List<TEMultiSelectTreeNode> closeNodeList = null;
    JMenuItem item = null;

    public FileCloseMenuItem(final TEOTDRFileTreePanel panel, TEMultiSelectTreeNode node) {
        this.panel = panel;
        this.curNode = node;
        this.item = new JMenuItem(this.menuResUtil.getString("CLOSE"));
        this.closeNodeList = new ArrayList<TEMultiSelectTreeNode>();
        this.item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileCloseMenuItem.this.handleCloseFileEvent(panel);
            }
        });
    }

    private void handleCloseFileEvent(TEOTDRFileTreePanel panel) {
        panel.handleCloseFileEvent(this.closeNodeList);
    }

    @Override
    public JMenuItem getItem(boolean isEnabled) {
        TEObjectCheckBoxTree tree = this.panel.getSelectObjTree();
        ArrayList<TEMultiSelectTreeNode> selectedFileList = tree.getSelectedFileNodes();
        if (!this.canClosed(selectedFileList)) {
            this.item.setEnabled(false);
        } else {
            this.item.setEnabled(isEnabled);
        }
        return this.item;
    }

    private boolean canClosed(List<TEMultiSelectTreeNode> selectedFileList) {
        this.closeNodeList = new ArrayList<TEMultiSelectTreeNode>();
        TEObjectCheckBoxTree tree = this.panel.getSelectObjTree();
        ArrayList<TEMultiSelectTreeNode> openedFileList = tree.getOpenedFileNodes();
        if (null == openedFileList || 0 == openedFileList.size()) {
            return false;
        }
        for (TEMultiSelectTreeNode openedNode : openedFileList) {
            if (!selectedFileList.contains(openedNode)) continue;
            this.closeNodeList.add(openedNode);
        }
        return 0 != this.closeNodeList.size();
    }
}

