/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.filetree;

import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphBaseLineMgrView;
import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphMgrView;
import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphTestFileAnalysisView;
import com.huawei.nglct.otdr.appletgraph.app.TEOTDRGraphViewTestRecordView;
import com.huawei.nglct.otdr.appletgraph.chartinfo.TEOTDRGraphTraceInfo;
import com.huawei.nglct.otdr.appletgraph.common.TECommUtil;
import com.huawei.nglct.otdr.appletgraph.common.TECommonUtil;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.common.TESystemMgr;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Datainterface;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.OperationData;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEMultiSelectTreeNode;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEMutableTreeNode;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEObjectCheckBoxTree;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEObjectSelectData;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEObjectSelectTree;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TETreeInterface;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphEventManager;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileClosedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileDeletedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileOpenedEvent;
import com.huawei.nglct.otdr.appletgraph.eventsys.TEOTDRGraphFileTreeFileSelectedEvent;
import com.huawei.nglct.otdr.appletgraph.filetree.menu.FileCloseMenuItem;
import com.huawei.nglct.otdr.appletgraph.filetree.menu.FileDeleteMenuItem;
import com.huawei.nglct.otdr.appletgraph.filetree.menu.FileOpenMenuItem;
import com.huawei.nglct.otdr.appletgraph.filetree.menu.FileSaveRecordItem;
import com.huawei.nglct.otdr.appletgraph.filetree.node.FileNodeInfo;
import com.huawei.nglct.otdr.appletgraph.filetree.node.MonthObj;
import com.huawei.nglct.otdr.appletgraph.filetree.node.NodeInfo;
import com.huawei.nglct.otdr.appletgraph.filetree.node.YearObj;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphInteractor;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModule;
import com.huawei.nglct.otdr.appletgraph.modulefrm.TEOTDRGraphModuleMgr;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphFileTreeIntegerface;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphMainFrameInterface;
import com.huawei.nglct.otdr.appletgraph.modulefrm.interactor.TEOTDRGraphToolbarInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeModel;

public class TEOTDRFileTreePanel
extends JPanel
implements TETreeInterface,
TEOTDRGraphFileTreeIntegerface,
TEOTDRGraphModule {
    private static final long serialVersionUID = 1L;
    private TETreeInterface invokeObject;
    private int treeType = 0;
    private boolean selectAll = false;
    private TEObjectCheckBoxTree selectObjTree;
    private List<TEObjectSelectData> datas;
    private String rootName = "";
    private static TEMarineResourceUtil strResUtil = TEMarineResourceUtil.getInstance("res/stringresource_" + TESystemMgr.getInstance().getLanguage() + ".ini");
    protected transient TEOTDRGraphModuleMgr teOTDRGraphModuleMgr = null;
    protected TEOTDRGraphEventManager teOTDRGraphEventManager = null;
    protected TECommonUtil teCommonUtil = null;

    public TEOTDRFileTreePanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil, int treeType) {
        this(teOTDRGraphModuleMgr, teOTDRGraphEventManager, teCommonUtil, null, treeType);
    }

    public TEOTDRFileTreePanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil, TETreeInterface invokeObject, int treeType) {
        this(teOTDRGraphModuleMgr, teOTDRGraphEventManager, teCommonUtil, invokeObject, treeType, null);
    }

    public TEOTDRFileTreePanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil, TETreeInterface invokeObject, int treeType, List<TEObjectSelectData> datas) {
        this(teOTDRGraphModuleMgr, teOTDRGraphEventManager, teCommonUtil, invokeObject, treeType, datas, false);
    }

    public TEOTDRFileTreePanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil, TETreeInterface invokeObject, int treeType, List<TEObjectSelectData> datas, boolean selectAll) {
        this(teOTDRGraphModuleMgr, teOTDRGraphEventManager, teCommonUtil, invokeObject, treeType, datas, selectAll, false);
    }

    public TEOTDRFileTreePanel(TEOTDRGraphModuleMgr teOTDRGraphModuleMgr, TEOTDRGraphEventManager teOTDRGraphEventManager, TECommonUtil teCommonUtil, TETreeInterface invokeObject, int treeType, List<TEObjectSelectData> datas, boolean selectAll, boolean lazyBuild) {
        this.teOTDRGraphModuleMgr = teOTDRGraphModuleMgr;
        this.teOTDRGraphEventManager = teOTDRGraphEventManager;
        this.teCommonUtil = teCommonUtil;
        this.invokeObject = invokeObject;
        this.treeType = treeType;
        this.datas = datas;
        this.selectAll = selectAll;
        this.buildEmptyTree();
        this.getFileList();
        this.buildTreeData();
        this.jbInit();
        this.initName();
        this.registerModule();
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public TEObjectCheckBoxTree getSelectObjTree() {
        return this.selectObjTree;
    }

    public void setSelectObjTree(TEObjectCheckBoxTree selectObjTree) {
        this.selectObjTree = selectObjTree;
    }

    private void buildEmptyTree() {
        this.invokeObject = this;
        if ("".equals(this.rootName)) {
            this.rootName = strResUtil.getString("treeroot");
        }
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.setShowName(this.rootName);
        TEObjectSelectData root = new TEObjectSelectData(-1, nodeInfo);
        this.selectObjTree = new TEObjectCheckBoxTree(root, this.invokeObject, this.selectAll);
        this.selectObjTree.setRootVisible(true);
    }

    private void getFileList() {
        OperationData req = this.createGetFileListReq();
        Datainterface rsp = TECommUtil.sendCommand(req);
        this.processGetFileListPsp(rsp);
    }

    private OperationData createGetFileListReq() {
        OperationData req = new OperationData();
        req.setServletName("FileName");
        req.addURLParam("neID", this.teCommonUtil.getNeIDStr());
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        req.addURLParam("indexID", this.teCommonUtil.getIndexIDStr());
        req.addURLParam("testMode", this.teCommonUtil.getTestModeStr());
        int fileType = -1;
        fileType = this.isViewTestRecordView() ? 0 : 1;
        req.addURLParam("fileType", fileType);
        return req;
    }

    private void processGetFileListPsp(Datainterface rsp) {
        TEObjectSelectData root = null;
        ArrayList<TEObjectSelectData> list = new ArrayList<TEObjectSelectData>();
        int errorCode = Integer.parseInt(rsp.getErrorMessage().getErrorcode());
        if (0 == errorCode) {
            root = this.convertTreeFileData(strResUtil.getString("treeroot"), rsp, this.isViewTestRecordView());
            if (null != root && null != root.getChildren()) {
                list.addAll(root.getChildren());
            }
            this.setDatas(list);
        } else {
            ArrayList<String> operObjParamList = new ArrayList<String>();
            operObjParamList.add("nename");
            this.teCommonUtil.showOptionMessage((Component)this, rsp, operObjParamList);
        }
    }

    private void buildTreeData() {
        if (this.datas != null) {
            this.selectObjTree.rebuildTree(this.datas);
        }
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        JScrollPane selectedObjScrlPane = new JScrollPane();
        selectedObjScrlPane.getViewport().add(this.selectObjTree);
        this.add((Component)selectedObjScrlPane, "Center");
    }

    private void initName() {
    }

    public Vector getSelectedObject() {
        return this.selectObjTree.getSelectedObject();
    }

    public void refreshTree() {
        if (this.selectObjTree != null) {
            this.buildTreeData();
        }
    }

    public void setDatas(List<TEObjectSelectData> datas) {
        this.datas = datas;
    }

    public TEObjectSelectTree getObjectSelectTree() {
        return this.selectObjTree;
    }

    @Override
    public JPopupMenu getPopupMenu(TEMultiSelectTreeNode node) {
        FileNodeInfo fileNodeInfo;
        TEObjectSelectData nodeData = node.getUserObject();
        NodeInfo nodeInfo = (NodeInfo)nodeData.getValue();
        if (2 == nodeInfo.getNodeType()) {
            return null;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        FileOpenMenuItem fileItem = new FileOpenMenuItem(this, node);
        popupMenu.add(fileItem.getItem(true));
        FileCloseMenuItem closeItem = new FileCloseMenuItem(this, node);
        popupMenu.add(closeItem.getItem(true));
        if (!this.isViewBaseLineMgrView() && !(fileNodeInfo = (FileNodeInfo)nodeData.getValue()).isBaseLine()) {
            FileDeleteMenuItem deleteItem = new FileDeleteMenuItem(this, node);
            popupMenu.add(deleteItem.getItem(this.getBtnRight("deletetestrecordbtnid")));
        }
        if (this.isViewTestRecordView()) {
            FileSaveRecordItem saveItem = new FileSaveRecordItem(this, node);
            popupMenu.add(saveItem.getItem(this.getBtnRight("savetestrecordbtnid")));
        }
        return popupMenu;
    }

    @Override
    public List<String> getCurrentSelectedFileList() {
        ArrayList<String> fileNameList = new ArrayList<String>();
        String fileName = null;
        TEMultiSelectTreeNode node2 = null;
        TEObjectSelectData nodeData = null;
        FileNodeInfo fileNodeInfo = null;
        ArrayList<TEMultiSelectTreeNode> selectedFileList = this.selectObjTree.getSelectedFileNodes();
        for (TEMultiSelectTreeNode node2 : selectedFileList) {
            nodeData = node2.getUserObject();
            fileNodeInfo = (FileNodeInfo)nodeData.getValue();
            if (null == fileNodeInfo) continue;
            fileName = fileNodeInfo.getFileName();
            fileNameList.add(fileName);
        }
        return fileNameList;
    }

    @Override
    public void deleteFile(List<String> fileNameList) {
        if (null == fileNameList || fileNameList.isEmpty()) {
            return;
        }
        String fileName2 = null;
        TEMultiSelectTreeNode node = null;
        ArrayList<TEMultiSelectTreeNode> selectedFileNodeList = new ArrayList<TEMultiSelectTreeNode>();
        for (String fileName2 : fileNameList) {
            node = this.getTreeNodeFromFileName(fileName2);
            selectedFileNodeList.add(node);
        }
        this.handleDeleteFileEvent(selectedFileNodeList);
    }

    public void handleDeleteFileEvent() {
        ArrayList<String> delFileNameList = this.getSelectedFileNameList();
        TEOTDRGraphMainFrameInterface minf = this.teOTDRGraphModuleMgr.getMainFrameInteractor();
        minf.doDeleteFile(delFileNameList);
    }

    public ArrayList<String> getSelectedFileNameList() {
        ArrayList<TEMultiSelectTreeNode> selectedFileNodeList = this.getSelectObjTree().getSelectedFileNodes();
        ArrayList<String> selectedFileNameList = new ArrayList<String>();
        String fileName = null;
        TEMultiSelectTreeNode node2 = null;
        TEObjectSelectData nodeData = null;
        FileNodeInfo fileNodeInfo = null;
        for (TEMultiSelectTreeNode node2 : selectedFileNodeList) {
            nodeData = node2.getUserObject();
            fileNodeInfo = (FileNodeInfo)nodeData.getValue();
            if (null == fileNodeInfo) continue;
            fileName = fileNodeInfo.getFileName();
            selectedFileNameList.add(fileName);
        }
        return selectedFileNameList;
    }

    private void handleDeleteFileEvent(ArrayList<TEMultiSelectTreeNode> selectedFileNodeList) {
        String classMethodName = "TEOTDRFileTREEPanel.handleDeleteFileEvent()";
        String logInfo = "\u00c9\u00be\u00b3\u00fd\u00ce\u00c4\u00bc\u00fe\u00b2\u00a2\u00b4\u00a5\u00b7\u00a2\u00ce\u00c4\u00bc\u00fe\u00c9\u00be\u00b3\u00fd\u00ca\u00c2\u00bc\u00fe  selectedFileNodeList: " + selectedFileNodeList;
        TECommonUtil.log(classMethodName, logInfo);
        if (null == selectedFileNodeList || selectedFileNodeList.isEmpty()) {
            return;
        }
        String fileName = null;
        ArrayList<String> delSucceedfileNameList = new ArrayList<String>();
        TEMultiSelectTreeNode node2 = null;
        TEObjectSelectData nodeData = null;
        FileNodeInfo fileNodeInfo = null;
        for (TEMultiSelectTreeNode node2 : selectedFileNodeList) {
            nodeData = node2.getUserObject();
            fileNodeInfo = (FileNodeInfo)nodeData.getValue();
            if (null == fileNodeInfo) continue;
            fileName = fileNodeInfo.getFileName();
            this.removeTreeNode(node2);
            this.teCommonUtil.setFileColor(fileName, null);
            this.teCommonUtil.getOpenedFileList().remove(fileName);
            this.teCommonUtil.getOpendedFileContentMap().remove(fileName);
            delSucceedfileNameList.add(fileName);
        }
        TEOTDRGraphFileTreeFileDeletedEvent event = TEOTDRGraphFileTreeFileDeletedEvent.getEvent();
        event.setFileNameList(delSucceedfileNameList);
        event.setNeID(this.teCommonUtil.getNeID());
        this.teOTDRGraphEventManager.triggerEvent(event);
    }

    public void removeTreeNode(List<String> fileNameList) {
        if (null == fileNameList) {
            return;
        }
        Iterator<String> iter = fileNameList.iterator();
        while (iter.hasNext()) {
            this.removeTreeNode(iter.next());
        }
    }

    public void removeTreeNode(String fileName) {
        TEMultiSelectTreeNode node = this.getTreeNodeFromFileName(fileName);
        this.removeTreeNode(node);
    }

    public void removeTreeNode(TEMultiSelectTreeNode node) {
        this.getSelectObjTree().setNodeUnselected((TEMutableTreeNode)node);
        this.getSelectObjTree().removeNode(node);
    }

    @Override
    public void saveFile(List<String> fileNameList) {
        this.handleSaveRecordEvent(fileNameList);
    }

    private void handleSaveRecordEvent(List<String> fileNameList) {
        if (null == fileNameList || fileNameList.isEmpty()) {
            return;
        }
        String fileName2 = null;
        TEMultiSelectTreeNode node = null;
        ArrayList<TEMultiSelectTreeNode> selectedFileNodeList = new ArrayList<TEMultiSelectTreeNode>();
        for (String fileName2 : fileNameList) {
            node = this.getTreeNodeFromFileName(fileName2);
            selectedFileNodeList.add(node);
        }
        this.handleSaveRecordEvent(selectedFileNodeList);
    }

    public void handleSaveRecordEvent() {
        ArrayList<String> saveFileNameList = this.getSelectedFileNameList();
        String classMethodName = "TEOTDRFileTREEPanel.handleSaveRecordEvent()";
        String logInfo = "\u00b1\u00a3\u00b4\u00e6\u00b2\u00e2\u00ca\u00d4\u00bc\u00c7\u00c2\u00bc  saveFileNameList: " + saveFileNameList;
        TECommonUtil.log(classMethodName, logInfo);
        TEOTDRGraphMainFrameInterface minf = this.teOTDRGraphModuleMgr.getMainFrameInteractor();
        minf.doSaveFile(saveFileNameList);
    }

    private void handleSaveRecordEvent(ArrayList<TEMultiSelectTreeNode> selectedFileNodeList) {
        String fileName = null;
        ArrayList<String> fileNameList = new ArrayList<String>();
        TEObjectCheckBoxTree tree = this.getSelectObjTree();
        TEMultiSelectTreeNode node2 = null;
        TEObjectSelectData nodeData = null;
        FileNodeInfo fileNodeInfo = null;
        for (TEMultiSelectTreeNode node2 : selectedFileNodeList) {
            nodeData = node2.getUserObject();
            fileNodeInfo = (FileNodeInfo)nodeData.getValue();
            if (null != fileNodeInfo) {
                fileName = fileNodeInfo.getFileName();
                tree.removeNode(node2);
                this.teCommonUtil.getOpenedFileList().remove(fileName);
                this.teCommonUtil.setFileColor(fileName, null);
                this.teCommonUtil.getOpendedFileContentMap().remove(fileName);
                fileNameList.add(fileName);
            }
            fileNameList.add(fileName);
        }
        TEOTDRGraphFileTreeFileDeletedEvent event = TEOTDRGraphFileTreeFileDeletedEvent.getEvent();
        event.setFileNameList(fileNameList);
        event.setNeID(this.teCommonUtil.getNeID());
        this.teOTDRGraphEventManager.triggerEvent(event);
    }

    @Override
    public String addFileToTree(List<String> fileNameList) {
        TEObjectCheckBoxTree tempTree = this.getTreeFromFileNameList(fileNameList);
        TEMultiSelectTreeNode tempRoot = (TEMultiSelectTreeNode)tempTree.getRoot();
        TEMultiSelectTreeNode root = (TEMultiSelectTreeNode)this.selectObjTree.getRoot();
        this.insertBaselineAndYearNode(tempRoot, root);
        return null;
    }

    private void insertBaselineAndYearNode(TEMultiSelectTreeNode tempRoot, TEMultiSelectTreeNode root) {
        String baseLineFileName;
        FileNodeInfo tempNodeInfo;
        String tempBaseLineFileName;
        TEMultiSelectTreeNode tempNode = this.getBaseLineFileNode(tempRoot);
        if (null != tempNode && !(tempBaseLineFileName = (tempNodeInfo = (FileNodeInfo)tempNode.getUserObject().getValue()).getFileName()).equalsIgnoreCase(baseLineFileName = this.getBaseLineFileName())) {
            TEMultiSelectTreeNode oldBaselineNode;
            this.insertYearNodeBranch(root, tempNode, 0);
            if (baseLineFileName != null && null != (oldBaselineNode = this.getBaseLineFileNode(root))) {
                this.removeTreeNode(oldBaselineNode);
            }
        }
        TEMultiSelectTreeNode tempYearNode = null;
        TEMultiSelectTreeNode yearNode = null;
        TEObjectSelectData tempYearNodeData = null;
        TEObjectSelectData nodeData = null;
        NodeInfo tempYearNodeInfo = null;
        NodeInfo nodeInfo = null;
        int tempYear = -1;
        int year = -1;
        boolean yearNeedAddFlag = true;
        int yearIndex = 0;
        for (int j = root.getChildCount() - 1; j >= 0; --j) {
            yearNode = (TEMultiSelectTreeNode)root.getChildAt(j);
            nodeData = yearNode.getUserObject();
            nodeInfo = (NodeInfo)nodeData.getValue();
            if (1 != nodeInfo.getNodeType()) continue;
            ++yearIndex;
        }
        for (int i = tempRoot.getChildCount() - 1; i >= 0; --i) {
            tempYearNode = (TEMultiSelectTreeNode)tempRoot.getChildAt(i);
            tempYearNodeData = tempYearNode.getUserObject();
            tempYearNodeInfo = (NodeInfo)tempYearNodeData.getValue();
            yearNeedAddFlag = true;
            if (1 == tempYearNodeInfo.getNodeType()) continue;
            tempYearNodeData = tempYearNode.getUserObject();
            tempYear = (Integer)tempYearNodeInfo.getValue();
            for (int j = root.getChildCount() - 1; j >= 0; --j) {
                yearNode = (TEMultiSelectTreeNode)root.getChildAt(j);
                nodeData = yearNode.getUserObject();
                nodeInfo = (NodeInfo)nodeData.getValue();
                if (0 != nodeInfo.getNodeType()) continue;
                year = (Integer)nodeInfo.getValue();
                if (tempYear > year) {
                    yearIndex = j + 1;
                    break;
                }
                if (tempYear != year) continue;
                yearNeedAddFlag = false;
                this.insertMonthNode(yearNode, tempYearNode);
                break;
            }
            if (!yearNeedAddFlag) continue;
            this.insertYearNodeBranch(root, tempYearNode, yearIndex);
        }
    }

    private void insertYearNodeBranch(TEMultiSelectTreeNode root, TEMultiSelectTreeNode tempYearnode, int yearIndex) {
        if (null == tempYearnode) {
            return;
        }
        root.setAllowsChildren(true);
        root.insert(tempYearnode, yearIndex);
        DefaultTreeModel model = this.getSelectObjTree().getModel();
        model.nodeStructureChanged(root);
    }

    private void insertMonthNode(TEMultiSelectTreeNode yearNode, TEMultiSelectTreeNode tempYearNode) {
        TEMultiSelectTreeNode tempMonthNode = null;
        TEMultiSelectTreeNode monthNode = null;
        TEObjectSelectData tempNodeData = null;
        TEObjectSelectData nodeData = null;
        NodeInfo tempNodeInfo = null;
        NodeInfo nodeInfo = null;
        int tempMonth = -1;
        int month = -1;
        boolean monthNeedAddFlag = true;
        for (int i = tempYearNode.getChildCount() - 1; i >= 0; --i) {
            tempMonthNode = (TEMultiSelectTreeNode)tempYearNode.getChildAt(i);
            tempNodeData = tempMonthNode.getUserObject();
            tempNodeInfo = (NodeInfo)tempNodeData.getValue();
            tempMonth = (Integer)tempNodeInfo.getValue();
            monthNeedAddFlag = true;
            int monthIndex = 0;
            for (int j = yearNode.getChildCount() - 1; j >= 0; --j) {
                monthNode = (TEMultiSelectTreeNode)yearNode.getChildAt(j);
                nodeData = monthNode.getUserObject();
                nodeInfo = (NodeInfo)nodeData.getValue();
                month = (Integer)nodeInfo.getValue();
                if (tempMonth > month) {
                    monthIndex = j + 1;
                    break;
                }
                if (tempMonth != month) continue;
                monthNeedAddFlag = false;
                this.insertFileNode(monthNode, tempMonthNode);
                break;
            }
            if (!monthNeedAddFlag) continue;
            this.insertMonthBranch(yearNode, tempMonthNode, monthIndex);
        }
    }

    private void insertMonthBranch(TEMultiSelectTreeNode yearNode, TEMultiSelectTreeNode tempMonthNode, int monthIndex) {
        yearNode.insert(tempMonthNode, monthIndex);
        TEObjectSelectData yearNodeData = yearNode.getUserObject();
        TEObjectSelectData temMonthNodeData = tempMonthNode.getUserObject();
        List<TEObjectSelectData> children = yearNodeData.getChildren();
        if (null == children) {
            children = new ArrayList<TEObjectSelectData>();
            yearNodeData.setChildren(children);
        }
        children.add(monthIndex, temMonthNodeData);
        DefaultTreeModel model = this.getSelectObjTree().getModel();
        model.nodeStructureChanged(yearNode);
    }

    private void insertFileNode(TEMultiSelectTreeNode monthNode, TEMultiSelectTreeNode tempMonthNode) {
        TEMultiSelectTreeNode tempFileNode = null;
        TEMultiSelectTreeNode fileNode = null;
        TEObjectSelectData tempNodeData = null;
        TEObjectSelectData nodeData = null;
        NodeInfo tempFileNodeInfo = null;
        FileNodeInfo fileNodeInfo = null;
        String tempShowName = null;
        String showName = null;
        boolean fileNeedAddFlag = true;
        int compareResult = 0;
        for (int i = tempMonthNode.getChildCount() - 1; i >= 0; --i) {
            tempFileNode = (TEMultiSelectTreeNode)tempMonthNode.getChildAt(i);
            tempNodeData = tempFileNode.getUserObject();
            tempFileNodeInfo = (NodeInfo)tempNodeData.getValue();
            tempShowName = tempFileNodeInfo.getShowName();
            fileNeedAddFlag = true;
            int fileIndex = 0;
            for (int j = monthNode.getChildCount() - 1; j >= 0; --j) {
                fileNode = (TEMultiSelectTreeNode)monthNode.getChildAt(j);
                nodeData = fileNode.getUserObject();
                fileNodeInfo = (FileNodeInfo)nodeData.getValue();
                showName = fileNodeInfo.getShowName();
                compareResult = this.compareShowName(tempShowName, showName);
                if (compareResult > 0) {
                    fileIndex = j + 1;
                    break;
                }
                if (compareResult != 0) continue;
                fileNeedAddFlag = false;
                break;
            }
            if (!fileNeedAddFlag) continue;
            this.insertFileNodeBranch(monthNode, tempFileNode, fileIndex);
        }
    }

    private void insertFileNodeBranch(TEMultiSelectTreeNode monthNode, TEMultiSelectTreeNode tempFileNode, int fileIndex) {
        monthNode.insert(tempFileNode, fileIndex);
        TEObjectSelectData monthNodeData = monthNode.getUserObject();
        TEObjectSelectData temFileNodeData = tempFileNode.getUserObject();
        List<TEObjectSelectData> children = monthNodeData.getChildren();
        if (null == children) {
            children = new ArrayList<TEObjectSelectData>();
            monthNodeData.setChildren(children);
        }
        children.add(fileIndex, temFileNodeData);
        DefaultTreeModel model = this.getSelectObjTree().getModel();
        model.nodeStructureChanged(monthNode);
    }

    private int compareShowName(String tempShowName, String showName) {
        int tempDay = Integer.parseInt(tempShowName.substring(0, 2));
        int tempHour = Integer.parseInt(tempShowName.substring(3, 5));
        int tempMinute = Integer.parseInt(tempShowName.substring(6, 8));
        int tempSecond = Integer.parseInt(tempShowName.substring(9, 11));
        int day = Integer.parseInt(showName.substring(0, 2));
        int hour = Integer.parseInt(showName.substring(3, 5));
        int minute = Integer.parseInt(showName.substring(6, 8));
        int second = Integer.parseInt(showName.substring(9, 11));
        if (tempDay != day) {
            return tempDay - day;
        }
        if (tempHour != hour) {
            return tempHour - hour;
        }
        if (tempMinute != minute) {
            return tempMinute - minute;
        }
        if (tempSecond != second) {
            return tempSecond - second;
        }
        return 0;
    }

    private TEObjectCheckBoxTree getTreeFromFileNameList(List<String> fileNameList) {
        TEObjectSelectData newRootData = new TEObjectSelectData(null);
        newRootData.setObjType(0);
        HashMap<String, YearObj> yearObjMap = new HashMap<String, YearObj>();
        String fileName2 = null;
        for (String fileName2 : fileNameList) {
            this.addFileNode(newRootData, yearObjMap, fileName2, false);
        }
        this.addRootItem(newRootData, yearObjMap);
        NodeInfo tempNodeInfo = new NodeInfo();
        TEObjectSelectData tempRoot = new TEObjectSelectData(-1, tempNodeInfo);
        TEObjectCheckBoxTree newTree = new TEObjectCheckBoxTree(tempRoot);
        newTree.rebuildTree(newRootData.getChildren());
        return newTree;
    }

    @Override
    public void closeGraphFromFileTree(String fileName) {
        if (null == fileName || "".equals(fileName)) {
            return;
        }
        TEMultiSelectTreeNode node = this.getTreeNodeFromFileName(fileName);
        if (null != node) {
            this.handleCloseFileEvent(node);
        }
    }

    public void handleCloseFileEvent(List<TEMultiSelectTreeNode> nodeList) {
        if (null == nodeList || nodeList.isEmpty()) {
            return;
        }
        for (TEMultiSelectTreeNode node : nodeList) {
            this.handleCloseFileEvent(node);
        }
    }

    public void handleCloseFileEvent(TEMultiSelectTreeNode node) {
        String classMethodName = "TEOTDRFileTreePanel.handleCloseFileEvent()";
        String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00b9\u00d8\u00b1\u00d5\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe";
        TECommonUtil.log(classMethodName, logInfo);
        if (!this.canCloseFile()) {
            return;
        }
        String fileName = null;
        TEObjectSelectData nodeData = node.getUserObject();
        FileNodeInfo fileNodeInfo = null;
        if (null != nodeData && null != (fileNodeInfo = (FileNodeInfo)nodeData.getValue())) {
            fileName = fileNodeInfo.getFileName();
            this.teCommonUtil.getOpenedFileList().remove(fileName);
            this.teCommonUtil.setFileColor(fileName, null);
            this.teCommonUtil.getOpendedFileContentMap().remove(fileName);
            node.setFileFlag(0);
            fileNodeInfo.setFileOpenFlag(0);
            this.getSelectObjTree().getModel().nodeStructureChanged(node);
        }
        TEOTDRGraphFileTreeFileClosedEvent event = TEOTDRGraphFileTreeFileClosedEvent.getEvent();
        event.setFileName(fileName);
        event.setNeID(this.teCommonUtil.getNeID());
        this.teOTDRGraphEventManager.triggerEvent(event);
    }

    @Override
    public String getBaseLineFileName() {
        TEMultiSelectTreeNode root = (TEMultiSelectTreeNode)this.selectObjTree.getModel().getRoot();
        return this.getBaseLineFileName(root);
    }

    private String getBaseLineFileName(TEMultiSelectTreeNode root) {
        TEMultiSelectTreeNode node = null;
        TEObjectSelectData nodeData = null;
        NodeInfo nodeInfo = null;
        FileNodeInfo fileNodeInfo = null;
        int len = root.getChildCount();
        for (int i = 0; i < len; ++i) {
            node = (TEMultiSelectTreeNode)root.getChildAt(i);
            nodeData = node.getUserObject();
            nodeInfo = (NodeInfo)nodeData.getValue();
            if (1 != nodeInfo.getNodeType() || null == (fileNodeInfo = (FileNodeInfo)nodeData.getValue()) || !fileNodeInfo.isBaseLine()) continue;
            return fileNodeInfo.getFileName();
        }
        return null;
    }

    private TEMultiSelectTreeNode getBaseLineFileNode(TEMultiSelectTreeNode root) {
        TEMultiSelectTreeNode node = null;
        TEObjectSelectData nodeData = null;
        NodeInfo nodeInfo = null;
        int len = root.getChildCount();
        for (int i = 0; i < len; ++i) {
            node = (TEMultiSelectTreeNode)root.getChildAt(i);
            nodeData = node.getUserObject();
            nodeInfo = (NodeInfo)nodeData.getValue();
            if (1 != nodeInfo.getNodeType()) continue;
            return node;
        }
        return null;
    }

    @Override
    public void openFileFromTree(String blFileName) {
        if (null == blFileName || "".equals(blFileName)) {
            return;
        }
        TEMultiSelectTreeNode node = this.getTreeNodeFromFileName(blFileName);
        if (null != node) {
            this.handleOpenFileEvent(node);
        }
    }

    private boolean canCloseFile() {
        boolean canCloseFile = true;
        if (this.teOTDRGraphModuleMgr.getGraphInteractor().isCompareNow()) {
            int a = InmOptionPane.showConfirmDialog(strResUtil.getString("IS_EXIT_COMPARECURVE"));
            if (a != 0) {
                canCloseFile = false;
            } else {
                TEOTDRGraphToolbarInterface tinf = this.teOTDRGraphModuleMgr.getToolbarInteractor();
                if (null != tinf) {
                    tinf.closeCompareStatus();
                }
            }
        }
        return canCloseFile;
    }

    private boolean canOpenFile() {
        boolean canOpenFile = true;
        if (this.teOTDRGraphModuleMgr.getGraphInteractor().isCompareNow()) {
            int a = InmOptionPane.showConfirmDialog(strResUtil.getString("IS_EXIT_COMPARECURVE"));
            if (a != 0) {
                canOpenFile = false;
            } else {
                TEOTDRGraphToolbarInterface tinf = this.teOTDRGraphModuleMgr.getToolbarInteractor();
                if (null != tinf) {
                    tinf.closeCompareStatus();
                }
            }
        }
        return canOpenFile;
    }

    public void handleOpenFileEvent(List<TEMultiSelectTreeNode> nodeList) {
        if (null == nodeList || nodeList.isEmpty()) {
            return;
        }
        for (TEMultiSelectTreeNode node : nodeList) {
            this.handleOpenFileEvent(node);
        }
    }

    public void handleOpenFileEvent(TEMultiSelectTreeNode node) {
        String classMethodName = "TEOTDRFileTreePanel.handleCloseFileEvent()";
        String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00b4\u00f2\u00bf\u00aa\u00ce\u00c4\u00bc\u00fe\u00ca\u00c2\u00bc\u00fe";
        TECommonUtil.log(classMethodName, logInfo);
        if (!this.canOpenFile()) {
            return;
        }
        TEObjectSelectData nodeData = null;
        FileNodeInfo fileNodeInfo = null;
        String fileName = null;
        nodeData = node.getUserObject();
        if (null != nodeData && null != (fileNodeInfo = (FileNodeInfo)nodeData.getValue())) {
            fileName = fileNodeInfo.getFileName();
            int errorCode = this.getFileFromServer(fileName);
            if (0 != errorCode) {
                return;
            }
            node.setFileFlag(1);
            fileNodeInfo.setFileOpenFlag(1);
            this.getSelectObjTree().getModel().nodeStructureChanged(node);
            TEOTDRGraphFileTreeFileOpenedEvent event = TEOTDRGraphFileTreeFileOpenedEvent.getEvent();
            event.setNeID(this.teCommonUtil.getNeID());
            event.setFileName(fileName);
            this.teOTDRGraphEventManager.triggerEvent(event);
        }
    }

    private int getFileFromServer(String fileName) {
        OperationData req = this.createGetFileFromServerReq(fileName);
        Datainterface rsp = TECommUtil.sendCommand(req);
        return this.processGetFileFromServerRsp(fileName, rsp);
    }

    private OperationData createGetFileFromServerReq(String fileName) {
        OperationData req = new OperationData();
        req.setServletName("xmldata");
        req.addURLParam("neID", this.teCommonUtil.getNeIDStr());
        req.addURLParam("nmUser", this.teCommonUtil.getUser());
        req.addURLParam("fileName", fileName);
        return req;
    }

    private int processGetFileFromServerRsp(String fileName, Datainterface rsp) {
        String classMethodName = "TEOTDRFileTreePanel.processGetFileFromServerRsp()";
        String logInfo = "\u00b4\u00d3\u00ba\u00f3\u00cc\u00a8\u00bb\u00f1\u00c8\u00a1\u00ce\u00c4\u00bc\u00fe fileName: " + fileName;
        TECommonUtil.log(classMethodName, logInfo);
        int errorCode = Integer.parseInt(rsp.getErrorMessage().getErrorcode());
        if (0 == errorCode) {
            TEOTDRGraphTraceInfo traceInfo = this.teCommonUtil.getTraceInfo(rsp);
            this.teCommonUtil.getOpendedFileContentMap().put(fileName, traceInfo);
            ArrayList<String> opendedFileList = this.teCommonUtil.getOpenedFileList();
            if (!opendedFileList.contains(fileName)) {
                this.teCommonUtil.getOpenedFileList().add(fileName);
            }
        } else {
            ArrayList<String> operObjParamList = new ArrayList<String>();
            operObjParamList.add("nename");
            operObjParamList.add("fileName");
            this.teCommonUtil.showOptionMessage((Component)this, rsp, operObjParamList);
            logInfo = "\u00b4\u00d3\u00ba\u00f3\u00cc\u00a8\u00bb\u00f1\u00c8\u00a1\u00ce\u00c4\u00bc\u00fe\u00ca\u00a7\u00b0\u00dc !" + rsp.toString();
            TECommonUtil.log(classMethodName, logInfo);
        }
        return errorCode;
    }

    public TEMultiSelectTreeNode getTreeNodeFromFileName(String fileName) {
        TEMultiSelectTreeNode root = (TEMultiSelectTreeNode)this.selectObjTree.getModel().getRoot();
        return this.getTreeNodeFromFileName(root, fileName);
    }

    private TEMultiSelectTreeNode getTreeNodeFromFileName(TEMultiSelectTreeNode node, String fileName) {
        if (null == node || null == fileName || "".equals(fileName)) {
            return null;
        }
        TEMultiSelectTreeNode child = null;
        NodeInfo nodeInfo = null;
        FileNodeInfo fileNodeInfo = null;
        TEObjectSelectData nodeData = node.getUserObject();
        nodeInfo = (NodeInfo)nodeData.getValue();
        TEMultiSelectTreeNode objNode = null;
        if (1 == nodeInfo.getNodeType()) {
            fileNodeInfo = (FileNodeInfo)nodeData.getValue();
            if (null != fileNodeInfo && fileName.equals(fileNodeInfo.getFileName())) {
                return node;
            }
        } else {
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                child = (TEMultiSelectTreeNode)node.getChildAt(i);
                objNode = this.getTreeNodeFromFileName(child, fileName);
                if (null == objNode) continue;
                return objNode;
            }
        }
        return null;
    }

    public TEObjectSelectData convertTreeFileData(String treeName, Datainterface data) {
        String classMethodName = "TEOTDRFileTreePanel.convertTreeFileData()";
        String logInfo = "\u00bd\u00e2\u00ce\u00f6\u00ce\u00c4\u00bc\u00fe.";
        TECommonUtil.log(classMethodName, logInfo);
        return this.convertTreeFileData(treeName, data, false);
    }

    public TEObjectSelectData convertTreeFileData(String treeName, Datainterface data, boolean showTestMode) {
        TEObjectSelectData root = new TEObjectSelectData(null);
        root.setObjType(0);
        HashMap<String, YearObj> yearObjMap = new HashMap<String, YearObj>();
        String fileName = null;
        int len = data.getDataRowLength();
        for (int i = 0; i < len; ++i) {
            fileName = data.getDataRowParamValue(i, "filename");
            this.addFileNode(root, yearObjMap, fileName, showTestMode);
        }
        this.addRootItem(root, yearObjMap);
        return root;
    }

    private void addFileNode(TEObjectSelectData root, HashMap<String, YearObj> yearObjMap, String fileName, boolean showTestMode) {
        String classMethodName = "TEOTDRFileTreePanel.addFileNode()";
        String logInfo = "\u00cc\u00ed\u00bc\u00d3\u00ce\u00c4\u00bc\u00fe fileName: " + fileName;
        TECommonUtil.log(classMethodName, logInfo);
        HashMap<String, String> fileNameParamMap = null;
        fileNameParamMap = TECommonUtil.getParamMapFromFileName(fileName, showTestMode);
        String indexID = fileNameParamMap.get("indexID");
        String testMode = fileNameParamMap.get("testMode");
        String lmiNEID = fileNameParamMap.get("lmiNEID");
        String lmiSlotID = fileNameParamMap.get("lmiSlotID");
        String lmiPortID = fileNameParamMap.get("lmiPortID");
        String timeStamp = fileNameParamMap.get("timeStamp");
        String year = fileNameParamMap.get("year");
        String month = fileNameParamMap.get("month");
        String showName = fileNameParamMap.get("showName");
        boolean isBaseline = "1".equals(fileNameParamMap.get("baseline"));
        FileNodeInfo fileObj = new FileNodeInfo();
        fileObj.setIndexID(Integer.parseInt(indexID));
        fileObj.setTestMode(Integer.parseInt(testMode));
        fileObj.setLmiNeID(Integer.parseInt(lmiNEID));
        fileObj.setLmiSlotID(Integer.parseInt(lmiSlotID));
        fileObj.setLmiPortID(Integer.parseInt(lmiPortID));
        fileObj.setTimeStamp(timeStamp);
        fileObj.setFileName(fileName);
        fileObj.setBaseLine(false);
        fileObj.setShowName(showName);
        if (isBaseline) {
            fileObj.setBaseLine(true);
            showName = strResUtil.getString("BASELINE_NAME");
            fileObj.setShowName(showName);
            fileObj.setFileOpenFlag(0);
            this.createFileItem(root, fileObj);
        } else {
            MonthObj monthObj;
            YearObj yearObj = yearObjMap.get(year);
            if (null == yearObj) {
                yearObj = new YearObj(Integer.parseInt(year));
                yearObjMap.put(year, yearObj);
            }
            if (null == (monthObj = yearObj.getMap().get(month))) {
                monthObj = new MonthObj(Integer.parseInt(month));
                yearObj.getMap().put(month, monthObj);
            }
            monthObj.getMap().put(fileName, fileObj);
        }
    }

    private void addRootItem(TEObjectSelectData root, HashMap<String, YearObj> yearObjMap) {
        if (null == root || null == yearObjMap || 0 == yearObjMap.size()) {
            return;
        }
        ArrayList<String> yearObjList = new ArrayList<String>();
        for (Map.Entry<String, YearObj> entry : yearObjMap.entrySet()) {
            yearObjList.add(entry.getKey());
        }
        Collections.sort(yearObjList);
        Iterator iter = yearObjList.iterator();
        String yearName = null;
        while (iter.hasNext()) {
            yearName = (String)iter.next();
            this.createYearItem(root, yearName, yearObjMap.get(yearName));
        }
    }

    private void createYearItem(TEObjectSelectData parent, String yearName, YearObj yearObj) {
        if (null == parent || null == yearName || null == yearObj) {
            return;
        }
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.setShowName(yearName);
        nodeInfo.setValue(Integer.valueOf(yearName));
        TEObjectSelectData node = new TEObjectSelectData(nodeInfo);
        node.setObjType(0);
        List<TEObjectSelectData> children = parent.getChildren();
        if (null == children) {
            children = new ArrayList<TEObjectSelectData>();
            parent.setChildren(children);
        }
        children.add(node);
        HashMap<String, MonthObj> monthObjMap = yearObj.getMap();
        if (null == monthObjMap || 0 == monthObjMap.size()) {
            return;
        }
        ArrayList<String> monthList = new ArrayList<String>();
        for (Map.Entry<String, MonthObj> entry : monthObjMap.entrySet()) {
            monthList.add(entry.getKey());
        }
        Collections.sort(monthList);
        Iterator iter = monthList.iterator();
        String monthName = null;
        while (iter.hasNext()) {
            monthName = (String)iter.next();
            this.createMonthItem(node, monthName, monthObjMap.get(monthName));
        }
    }

    private void createMonthItem(TEObjectSelectData parent, String monthName, MonthObj monthObj) {
        if (null == parent || null == monthObj) {
            return;
        }
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.setShowName(this.getMonthShowName(monthName));
        nodeInfo.setValue(Integer.valueOf(monthName));
        TEObjectSelectData node = new TEObjectSelectData(nodeInfo);
        node.setObjType(0);
        List<TEObjectSelectData> children = parent.getChildren();
        if (null == children) {
            children = new ArrayList<TEObjectSelectData>();
            parent.setChildren(children);
        }
        children.add(node);
        HashMap<String, FileNodeInfo> fileNodeInfoMap = monthObj.getMap();
        if (null == fileNodeInfoMap || 0 == fileNodeInfoMap.size()) {
            return;
        }
        ArrayList<String> fileNodeInfoList = new ArrayList<String>();
        for (Map.Entry<String, FileNodeInfo> entry : fileNodeInfoMap.entrySet()) {
            fileNodeInfoList.add(entry.getKey());
        }
        Collections.sort(fileNodeInfoList);
        Iterator iter = fileNodeInfoList.iterator();
        while (iter.hasNext()) {
            this.createFileItem(node, fileNodeInfoMap.get(iter.next()));
        }
    }

    private String getMonthShowName(String month) {
        return strResUtil.getString("monthname" + month);
    }

    private void createFileItem(TEObjectSelectData parent, FileNodeInfo fileObj) {
        if (null == parent || null == fileObj) {
            return;
        }
        List<TEObjectSelectData> children = parent.getChildren();
        if (null == children) {
            children = new ArrayList<TEObjectSelectData>();
            parent.setChildren(children);
        }
        TEObjectSelectData node = new TEObjectSelectData(fileObj);
        node.setObjType(1);
        children.add(node);
    }

    @Override
    public TEOTDRGraphInteractor getInteractor() {
        return this;
    }

    public void registerModule() {
        this.teOTDRGraphModuleMgr.registerModule("filetreemodule", this);
    }

    @Override
    public void fireTreeSelectStateChanged() {
        String classMethodName = "TEOTDRFileTreePanel.fireTreeSelectStateChanged()";
        String logInfo = "\u00b7\u00a2\u00cb\u00cd\u00ca\u00f7\u00bd\u00da\u00b5\u00e3\u00d1\u00a1\u00d6\u00d0\u00d7\u00b4\u00cc\u00ac\u00b8\u00c4\u00b1\u00e4\u00ca\u00c2\u00bc\u00fe ";
        TECommonUtil.log(classMethodName, logInfo);
        TEOTDRGraphFileTreeFileSelectedEvent event = TEOTDRGraphFileTreeFileSelectedEvent.getEvent();
        event.setNeID(this.teCommonUtil.getNeID());
        event.setFileNameList(this.getSelectedFileNameList());
        this.teOTDRGraphEventManager.triggerEvent(event);
    }

    @Override
    public void onDBClickTreeNode(TEMultiSelectTreeNode node) {
        String classMethodName = "TEOTDRFileTreePanel.onDBClickTreeNode()";
        String logInfo = "\u00b4\u00a6\u00c0\u00ed\u00ca\u00f7\u00bd\u00da\u00b5\u00e3\u00cb\u00ab\u00bb\u00f7\u00ca\u00c2\u00bc\u00fe ";
        TECommonUtil.log(classMethodName, logInfo);
        if (1 != this.getNodeType(node)) {
            return;
        }
        node.setStatus((byte)3);
        ArrayList<TEMultiSelectTreeNode> openedFileNodeList = this.getSelectObjTree().getOpenedFileNodes();
        int openedFileCount = openedFileNodeList.size();
        if (openedFileCount >= 3 && !openedFileNodeList.contains(node)) {
            return;
        }
        this.handleOpenFileEvent(node);
    }

    private int getNodeType(TEMultiSelectTreeNode node) {
        if (null == node) {
            return -1;
        }
        TEObjectSelectData nodeData = node.getUserObject();
        if (null == nodeData) {
            return -1;
        }
        NodeInfo nodeInfo = (NodeInfo)nodeData.getValue();
        return nodeInfo.getNodeType();
    }

    public boolean isViewTestRecordView() {
        TEOTDRGraphModule module = this.teOTDRGraphModuleMgr.getModuleByModuleName("mainframemodule");
        return module instanceof TEOTDRGraphViewTestRecordView;
    }

    private boolean isViewBaseLineMgrView() {
        TEOTDRGraphModule module = this.teOTDRGraphModuleMgr.getModuleByModuleName("mainframemodule");
        return module instanceof TEOTDRGraphBaseLineMgrView;
    }

    private boolean isViewTestFileAnalysisView() {
        TEOTDRGraphModule module = this.teOTDRGraphModuleMgr.getModuleByModuleName("mainframemodule");
        return module instanceof TEOTDRGraphTestFileAnalysisView;
    }

    private boolean getBtnRight(String btnid) {
        TEOTDRGraphMgrView module = (TEOTDRGraphMgrView)this.teOTDRGraphModuleMgr.getModuleByModuleName("mainframemodule");
        return module.hasOperationRight(btnid);
    }

    @Override
    public void destroy() {
    }
}

