/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.tree;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.common.TEMarineResourceUtil;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmTridStateIcon;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEMultiSelectTreeNode;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEMutableTreeNode;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEObjectSelectData;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEObjectSelectTree;
import com.huawei.nglct.otdr.appletgraph.core.util.tree.TETreeInterface;
import com.huawei.nglct.otdr.appletgraph.filetree.node.FileNodeInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TEObjectCheckBoxTree
extends TEObjectSelectTree {
    private static final long serialVersionUID = 1L;
    private static final int DOUBLE_CLICK = 2;
    private static final int TREE_CELL_RENDER_WIDTH = 360;
    private static final int TREE_CELL_RENDER_HEIGHT = 18;
    protected TEMultiSelectTreeNode curNode = null;
    protected TEMultiSelectTreeNode curParentNode = null;
    private boolean bSelectAll = true;
    protected TEMultiSelectTreeNode root = null;
    TEMarineResourceUtil resUtil = TEMarineResourceUtil.getInstance("res" + File.separator + "imageresource.ini");
    private DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer(){
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
            this.hasFocus = hasFocus;
            this.setText(stringValue);
            this.setEnabled(tree.isEnabled());
            this.setComponentOrientation(tree.getComponentOrientation());
            this.selected = sel;
            TreePath path = tree.getPathForRow(row);
            if (path != null) {
                TEMultiSelectTreeNode node = (TEMultiSelectTreeNode)path.getLastPathComponent();
                InmTridStateIcon icon = null;
                switch (node.getStatus()) {
                    case 3: {
                        icon = InmTridStateIcon.ALL_SELECT_ICON;
                        break;
                    }
                    case 1: {
                        icon = InmTridStateIcon.NONE_SELECT_ICON;
                        break;
                    }
                    case 2: {
                        icon = InmTridStateIcon.PART_SELECT_ICON;
                        break;
                    }
                    default: {
                        icon = InmTridStateIcon.NONE_SELECT_ICON;
                    }
                }
                TEObjectSelectData nodeData = node.getUserObject();
                FileNodeInfo fileNodeInfo = null;
                ImageIcon imageIcon = null;
                imageIcon = 1 == nodeData.getObjType() ? (1 == (fileNodeInfo = (FileNodeInfo)nodeData.getValue()).getFileOpenFlag() ? (ImageIcon)TEObjectCheckBoxTree.this.resUtil.getIcon("leafsel.gif") : (0 == fileNodeInfo.getFileOpenFlag() ? (ImageIcon)TEObjectCheckBoxTree.this.resUtil.getIcon("root.gif") : null)) : null;
                icon.setImageIcon(imageIcon);
                int width = 360;
                int height = 18;
                this.setPreferredSize(new Dimension(width, height));
                this.setIcon(icon);
            }
            return this;
        }

        @Override
        public Color getBackgroundSelectionColor() {
            return super.getBackgroundNonSelectionColor();
        }

        @Override
        public Color getTextSelectionColor() {
            return super.getTextNonSelectionColor();
        }

        @Override
        public Color getBorderSelectionColor() {
            return null;
        }
    };

    public TEObjectCheckBoxTree() {
        this((TEObjectSelectData)null);
    }

    public TEObjectCheckBoxTree(TEObjectSelectData data) {
        this(data, null);
    }

    public TEObjectCheckBoxTree(TEObjectSelectData data, TETreeInterface adapter) {
        this(data, adapter, true);
    }

    public TEObjectCheckBoxTree(TEObjectSelectData data, TETreeInterface adapter, boolean bselectAll) {
        super(TEObjectCheckBoxTree.createTreeModel(data));
        this.dataAdapter = adapter;
        this.root = (TEMultiSelectTreeNode)this.getRoot();
        this.bSelectAll = bselectAll;
        this.setCellRenderer(this.cellRenderer);
        if (this.bSelectAll) {
            this.setTreeAllSelected();
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu;
                Point p = e.getPoint();
                TreePath tp = TEObjectCheckBoxTree.this.getPathForRow(TEObjectCheckBoxTree.this.getRowForLocation(p.x, p.y));
                TEMultiSelectTreeNode node = null;
                if (e.getModifiers() == 16) {
                    int row = TEObjectCheckBoxTree.this.getRowForLocation(e.getX(), e.getY());
                    TEObjectCheckBoxTree.this.actionSelect(row);
                    if (2 == e.getClickCount() && null != tp) {
                        node = (TEMultiSelectTreeNode)tp.getLastPathComponent();
                        TEObjectCheckBoxTree.this.dataAdapter.onDBClickTreeNode(node);
                        TEObjectCheckBoxTree.this.setNodeSelected(node);
                    }
                } else if (e.getModifiers() == 4 && null != tp && (menu = TEObjectCheckBoxTree.this.dataAdapter.getPopupMenu(node = (TEMultiSelectTreeNode)tp.getLastPathComponent())) != null) {
                    menu.show(TEObjectCheckBoxTree.this, p.x, p.y);
                }
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setRowHeight(25);
        BasicTreeUI ui = (BasicTreeUI)this.getUI();
        ui.setCollapsedIcon(this.resUtil.getIcon("add.gif"));
        ui.setExpandedIcon(this.resUtil.getIcon("minu.gif"));
    }

    protected static DefaultTreeModel createTreeModel(Object value) {
        TEObjectSelectData convertedData = null;
        try {
            convertedData = (TEObjectSelectData)value;
        }
        catch (Exception e) {
            System.out.println("object checkbox tree instance failed!");
            TEAppletLogMgr.error("TEObjectCheckBoxTree.createTreeModel() fail!", e);
            return null;
        }
        TEMultiSelectTreeNode rootNode = new TEMultiSelectTreeNode(convertedData, convertedData.getChildren());
        return new DefaultTreeModel(rootNode, false);
    }

    @Override
    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    private void mountChildren(TEMutableTreeNode node, List childrenData) {
        node.clearChildren();
        node.setAllowsChildren(true);
        node.createChildren(childrenData);
        this.getModel().nodeStructureChanged(node);
        node.getUserObject().setChildren(childrenData);
        this.setAllChildrenState((TEMultiSelectTreeNode)node, this.bSelectAll);
    }

    public boolean isTreeAllselected() {
        return this.getNodeState(this.root) == 3;
    }

    @Override
    public void rebuildTree(List datas) {
        this.mountChildren(this.root, datas);
    }

    public byte getNodeState(TEMultiSelectTreeNode node) {
        boolean bSet = false;
        byte status = 1;
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.curNode = (TEMultiSelectTreeNode)node.getChildAt(i);
            byte status1 = this.curNode.getStatus();
            if (!bSet) {
                bSet = true;
                status = status1;
                continue;
            }
            if (status == status1) continue;
            return 2;
        }
        return status;
    }

    private void getSelectedNEData(TEObjectSelectData data, Set set) {
        if (data.getObjType() == 0) {
            List<TEObjectSelectData> children = data.getChildren();
            if (children != null && !children.isEmpty()) {
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    this.getSelectedNEData(children.get(i), set);
                }
            }
        } else {
            set.add(data);
        }
    }

    protected void getSelectedChildren(TEMultiSelectTreeNode node, Set set, boolean reCursion) {
        Enumeration enumer = node.children();
        while (enumer.hasMoreElements()) {
            TEMultiSelectTreeNode tmp_node = (TEMultiSelectTreeNode)enumer.nextElement();
            switch (tmp_node.getStatus()) {
                case 1: {
                    break;
                }
                case 3: {
                    TEObjectSelectData tmpData = tmp_node.getUserObject();
                    this.getSelectedNEData(tmpData, set);
                    break;
                }
                case 2: {
                    this.getSelectedChildren(tmp_node, set, reCursion);
                    break;
                }
            }
        }
    }

    public ArrayList<TEMultiSelectTreeNode> getSelectedFileNodes() {
        ArrayList<TEMultiSelectTreeNode> list = new ArrayList<TEMultiSelectTreeNode>();
        this.getSelectedFileNodes(this.root, list);
        return list;
    }

    public void getSelectedFileNodes(TEMultiSelectTreeNode node, ArrayList<TEMultiSelectTreeNode> list) {
        TEObjectSelectData data = null;
        data = node.getUserObject();
        if (null == data) {
            return;
        }
        if (1 == data.getObjType() && 3 == node.getStatus()) {
            list.add(node);
            return;
        }
        Enumeration enumer = node.children();
        TEMultiSelectTreeNode tmp_node = null;
        while (enumer.hasMoreElements()) {
            tmp_node = (TEMultiSelectTreeNode)enumer.nextElement();
            data = tmp_node.getUserObject();
            if (null == data) {
                return;
            }
            if (0 == data.getObjType()) {
                this.getSelectedFileNodes(tmp_node, list);
                continue;
            }
            if (3 != tmp_node.getStatus()) continue;
            list.add(tmp_node);
        }
    }

    public ArrayList<TEMultiSelectTreeNode> getOpenedFileNodes() {
        ArrayList<TEMultiSelectTreeNode> list = new ArrayList<TEMultiSelectTreeNode>();
        this.getOpenedFileNodes(this.root, list);
        return list;
    }

    private void getOpenedFileNodes(TEMultiSelectTreeNode node, ArrayList<TEMultiSelectTreeNode> list) {
        TEObjectSelectData data = null;
        if (1 == node.getFileFlag()) {
            list.add(node);
            return;
        }
        Enumeration enumer = node.children();
        TEMultiSelectTreeNode tmp_node = null;
        while (enumer.hasMoreElements()) {
            tmp_node = (TEMultiSelectTreeNode)enumer.nextElement();
            data = tmp_node.getUserObject();
            if (null == data) {
                return;
            }
            if (0 == data.getObjType()) {
                this.getOpenedFileNodes(tmp_node, list);
                continue;
            }
            if (1 != tmp_node.getFileFlag()) continue;
            list.add(tmp_node);
        }
    }

    public void removeNode(TEMultiSelectTreeNode node) {
        TEObjectSelectData parentData = null;
        if (this.root == node) {
            this.getModel().nodeStructureChanged(node);
            return;
        }
        TEMultiSelectTreeNode parent = (TEMultiSelectTreeNode)node.getParent();
        parentData = parent.getUserObject();
        parent.remove(node);
        parentData.getChildren().remove(node.getUserObject());
        this.getModel().nodeStructureChanged(parent);
        TEMultiSelectTreeNode parentParent = (TEMultiSelectTreeNode)parent.getParent();
        if (null != parentParent && 0 == parent.getChildCount()) {
            this.removeNode(parent);
        }
    }

    @Override
    public Vector getSelectedObject() {
        TreeSet set = new TreeSet();
        this.getSelectedChildren(this.root, set, false);
        return new Vector(set);
    }

    public void setTreeAllSelected() {
        this.setAllChildrenState(this.root, true);
        this.repaint();
    }

    public void setTreeAllUnSelected() {
        this.setAllChildrenState(this.root, false);
        this.repaint();
    }

    public void actionSelect(int row) {
        TreePath path = this.getPathForRow(row);
        if (path == null) {
            return;
        }
        this.curNode = (TEMultiSelectTreeNode)path.getLastPathComponent();
        byte status = this.curNode.getStatus();
        if (status == 1) {
            this.setNodeSelected(this.curNode);
        } else {
            this.setNodeUnselected(this.curNode);
        }
        this.fireSelectStateChanged(this.root.getStatus());
    }

    protected void setNodeSelected(TEMultiSelectTreeNode node) {
        if (node != null) {
            this.setAllChildrenState(node, true);
            this.curParentNode = (TEMultiSelectTreeNode)node.getParent();
            while (this.curParentNode != null) {
                this.curParentNode.setStatus(this.getNodeState(this.curParentNode));
                this.curParentNode = (TEMultiSelectTreeNode)this.curParentNode.getParent();
            }
            this.repaint();
        }
    }

    protected void setNodeUnselected(TEMultiSelectTreeNode node) {
        if (node != null) {
            this.setAllChildrenState(node, false);
            this.curParentNode = (TEMultiSelectTreeNode)node.getParent();
            while (this.curParentNode != null) {
                this.curParentNode.setStatus(this.getNodeState(this.curParentNode));
                this.curParentNode = (TEMultiSelectTreeNode)this.curParentNode.getParent();
            }
            this.removeSelectionPath(new TreePath(node.getPath()));
            this.repaint();
        }
    }

    public void setAllChildrenState(TEMultiSelectTreeNode node, boolean state) {
        node.setStatus(state ? (byte)3 : 1);
        int size = this.treeModel.getChildCount(node);
        for (int i = 0; i < size; ++i) {
            TEMultiSelectTreeNode tmp_node = (TEMultiSelectTreeNode)this.treeModel.getChild(node, i);
            this.setAllChildrenState(tmp_node, state);
        }
    }

    public void fireSelectStateChanged(int newState) {
        if (this.dataAdapter != null) {
            this.dataAdapter.fireTreeSelectStateChanged();
        }
    }

    @Override
    public void shrinkAll() {
        Enumeration nodeEnum = this.root.children();
        TEMultiSelectTreeNode tmp = null;
        while (nodeEnum.hasMoreElements()) {
            tmp = (TEMultiSelectTreeNode)nodeEnum.nextElement();
            this.setNodeExpandState(tmp, false);
        }
        this.setNodeExpandState(this.root, false);
    }

    private void setNodeExpandState(TEMultiSelectTreeNode node, boolean state, boolean expandAll) {
        TEMultiSelectTreeNode tmp = null;
        TreePath path = null;
        if (expandAll) {
            if (node.isLeaf()) {
                return;
            }
            Enumeration nodeEnum1 = node.children();
            while (nodeEnum1.hasMoreElements()) {
                tmp = (TEMultiSelectTreeNode)nodeEnum1.nextElement();
                this.setNodeExpandState(tmp, state);
            }
            path = new TreePath(node.getPath());
            this.setExpandedState(path, state);
        } else {
            Enumeration<TreeNode> nodeEnum2 = node.breadthFirstEnumeration();
            while (nodeEnum2.hasMoreElements()) {
                tmp = (TEMultiSelectTreeNode)nodeEnum2.nextElement();
                if (tmp.isLeaf() || state && tmp.isNeedloadLater() && tmp.getChildCount() <= 0) continue;
                path = new TreePath(tmp.getPath());
                this.setExpandedState(path, state);
            }
        }
    }

    private void setNodeExpandState(TEMultiSelectTreeNode node, boolean state) {
        this.setNodeExpandState(node, state, true);
    }

    public void refreshNodeSelectStatus(ArrayList neList) {
        Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TEMultiSelectTreeNode node = (TEMultiSelectTreeNode)e.nextElement();
            if (node.isRoot() || !node.isLeaf()) continue;
            Object obj = node.getUserObject().getValue();
            if (neList.contains(obj)) {
                this.setNodeSelected(node);
                continue;
            }
            this.setNodeUnselected(node);
        }
    }

    @Override
    public void setNodeSelected(TEMutableTreeNode node) {
        this.setNodeSelected((TEMultiSelectTreeNode)node);
        this.fireSelectStateChanged(this.root.getStatus());
    }

    @Override
    public void setNodeUnselected(TEMutableTreeNode node) {
        this.setNodeUnselected((TEMultiSelectTreeNode)node);
    }

    @Override
    public boolean getShowsRootHandles() {
        return true;
    }

    @Override
    public boolean isRootVisible() {
        return true;
    }

    @Override
    public boolean hasBeenExpanded(TreePath path) {
        if (null != this.root && path.getLastPathComponent() == this.root && 0 == this.root.getChildCount()) {
            return false;
        }
        return super.hasBeenExpanded(path);
    }
}

