/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.tree;

import com.huawei.nglct.otdr.appletgraph.core.util.tree.TEObjectSelectData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class TEMutableTreeNode
extends DefaultMutableTreeNode {
    protected Object childValue;
    protected boolean loadedChildren = false;
    protected boolean needLoadLater;

    public TEMutableTreeNode() {
        this(null, null);
    }

    public TEMutableTreeNode(Object value, Object children) {
        this(value, children, false);
    }

    public TEMutableTreeNode(Object value, Object children, boolean loadLater) {
        super(value);
        this.childValue = children;
        this.needLoadLater = loadLater;
        if (children != null) {
            if (children instanceof Vector) {
                this.setAllowsChildren(true);
            } else if (children instanceof Hashtable) {
                this.setAllowsChildren(true);
            } else if (children instanceof Object[]) {
                this.setAllowsChildren(true);
            } else if (children instanceof List) {
                this.setAllowsChildren(true);
            } else {
                this.setAllowsChildren(false);
            }
        } else {
            this.setAllowsChildren(this.needLoadLater);
        }
    }

    @Override
    public TEObjectSelectData getUserObject() {
        return (TEObjectSelectData)super.getUserObject();
    }

    public void createChildren(Object children) {
        TEObjectSelectData tmpData = null;
        Object[] childArray = null;
        if (children instanceof List) {
            childArray = ((List)children).toArray();
        }
        if (children instanceof Object[]) {
            childArray = (Object[])children;
        }
        if (childArray == null) {
            return;
        }
        if (childArray.length <= 0) {
            this.setAllowsChildren(false);
            return;
        }
        if (childArray[0] instanceof TEObjectSelectData) {
            int maxCounter = childArray.length;
            for (int counter = 0; counter < maxCounter; ++counter) {
                tmpData = (TEObjectSelectData)childArray[counter];
                if (tmpData == null) continue;
                this.add(new TEMutableTreeNode(tmpData, tmpData.getChildren(), tmpData.hasChildren()));
            }
        }
    }

    public boolean isNeedloadLater() {
        return this.needLoadLater;
    }

    @Override
    public boolean isLeaf() {
        if (this.getRoot() == this) {
            return false;
        }
        return !this.getAllowsChildren();
    }

    @Override
    public int getChildCount() {
        if (!this.loadedChildren) {
            this.loadChildren();
        }
        return super.getChildCount();
    }

    protected void loadChildren() {
        this.loadedChildren = true;
        this.createChildren(this.childValue);
    }

    public void clearChildren() {
        this.children = null;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (!this.loadedChildren) {
            this.loadChildren();
        }
        return super.getChildAt(index);
    }

    public Enumeration children() {
        if (!this.loadedChildren) {
            this.loadChildren();
        }
        return super.children();
    }

    public byte getStatus() {
        return 0;
    }
}

