/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.table;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButton;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TETextButtonSelectAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TETextButtonPanel
extends JPanel {
    private static final Color disableColor = new Color(204, 204, 204);
    private static final Color enableColor = new JTextField().getBackground();
    private List listeners = new ArrayList();
    private JTextField text = new JTextField(){

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.setBackground(enableColor);
            } else {
                this.setBackground(disableColor);
            }
        }
    };
    private InmButton selectBtn = new InmButton("...");
    private Object value = null;

    public TETextButtonPanel(final TETextButtonSelectAction action) {
        this.uiInit();
        this.selectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = action.doSelect();
                if (obj == null) {
                    TETextButtonPanel.this.fireObjectSelected(null);
                    return;
                }
                TETextButtonPanel.this.setValue(obj);
                TETextButtonPanel.this.fireObjectSelected(new ActionEvent(TETextButtonPanel.this, 0, ""));
            }
        });
    }

    private void uiInit() {
        this.text.setEditable(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.text, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.selectBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object obj) {
        this.value = obj;
        this.text.setText(obj == null ? "" : obj.toString());
    }

    public void addSelectListener(ActionListener lis) {
        this.listeners.add(lis);
    }

    public void fireObjectSelected(ActionEvent e) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ActionListener)iter.next()).actionPerformed(e);
        }
    }

    public JTextField getTextField() {
        return this.text;
    }

    public void setButtonEnable(boolean isEnable) {
        this.text.setEnabled(isEnable);
        this.selectBtn.setEnabled(isEnable);
    }

    public void setEditable(boolean isEditable) {
        this.text.setEditable(isEditable);
    }
}

