/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class TERadioButtonCellRenderer
extends JRadioButton
implements TableCellRenderer {
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;

    public TERadioButtonCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    public TERadioButtonCellRenderer(JRadioButton button) {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.setSelected(button.isSelected());
        this.setText(button.getText());
        this.setSelectedIcon(button.getSelectedIcon());
        this.setToolTipText(button.getToolTipText());
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
        super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        super.setFont(table.getFont());
        Color back = this.getBackground();
        boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        this.setSelected(((JRadioButton)value).isSelected());
        return this;
    }
}

