/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.table;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmFileDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmProfileFactory;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.SortableTableModel;
import com.huawei.nglct.otdr.appletgraph.core.util.TENameValuePair;
import com.huawei.nglct.otdr.appletgraph.core.util.model.IfCtrl;
import com.huawei.nglct.otdr.appletgraph.core.util.model.TEModelUtility;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import javax.swing.table.TableCellEditor;

public class TENormalTableModel
extends SortableTableModel {
    public static final int FIRST_COL = 0;
    public static final int DEFAULT_HIDE = 0;
    public static final TENameValuePair INVALID_PAIR = new TENameValuePair(-1, "/");
    private String fileName = "";
    private String areaName = "";
    private Vector colNames = new Vector();
    private int sortCol = -1;
    private boolean isAssentSort = false;
    private ArrayList changedCells = new ArrayList();
    private ArrayList changedModelCells = new ArrayList();
    private static final int MOVE = 16;
    private static final int CELL_ROW = 65535;
    private static final long CELL_COL = 0xFFFF0000L;

    public TENormalTableModel(String descField, String fName) {
        this.fileName = fName;
        this.areaName = descField;
        this.initCellEditor();
    }

    public TENormalTableModel() {
    }

    public String getConfigFile() {
        return this.fileName;
    }

    public String getConfigArea() {
        return this.areaName;
    }

    public Vector getColumnNames() {
        return this.colNames;
    }

    public void addRowEx(Vector rowData) {
        if (rowData != null && rowData.size() > 0) {
            Object firstCol = rowData.get(0);
            if (firstCol instanceof TENormalColumn) {
                ((TENormalColumn)firstCol).setFlag((byte)1);
            }
            this.addRow(rowData);
        }
    }

    @Override
    public void sortByColumn(int column, boolean isAscent) {
        super.sortByColumn(column, isAscent);
        this.sortCol = column;
        this.isAssentSort = isAscent;
    }

    protected Object resetFirstValue(Object aValue, int row, int column) {
        Object obj = this.getValueAt(row, 0);
        if (obj instanceof TENormalColumn) {
            if (((TENormalColumn)obj).getFlag() != 1) {
                ((TENormalColumn)obj).setFlag((byte)2);
            }
            this.fireTableCellUpdated(row, 0);
            if (column == 0) {
                if (!(aValue instanceof TENormalColumn)) {
                    aValue = new TENormalColumn(aValue);
                }
                ((TENormalColumn)aValue).setFlag(((TENormalColumn)obj).getFlag());
            }
        }
        return aValue;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Object newValue = this.resetFirstValue(aValue, row, column);
        super.setValueAt(newValue, row, column);
        this.processEditingCells(row, column);
        this.doAfterValueChange();
    }

    public void setValueAtNoChange(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
    }

    @Override
    public void setValueAt(Object value, int row, int col, boolean isAutoSort, boolean bfireTableCellUpdated) {
        Object newValue = this.resetFirstValue(value, row, col);
        super.setValueAt(newValue, row, col, isAutoSort, bfireTableCellUpdated);
        this.processEditingCells(row, col);
        this.doAfterValueChange();
    }

    public void doAfterValueChange() {
    }

    private void processEditingCells(int row, int col) {
        Integer cell = new Integer((col << 16) + row);
        int pos = Collections.binarySearch(this.changedCells, cell);
        Integer modelCell = new Integer((col << 16) + this.convertTableRowIndexToModel(row));
        int modelPos = Collections.binarySearch(this.changedModelCells, modelCell);
        if (pos < 0) {
            this.changedCells.add(-1 - pos, cell);
        }
        if (modelPos < 0) {
            this.changedModelCells.add(-1 - modelPos, modelCell);
        }
    }

    public ArrayList getChangedRows() {
        ArrayList<Integer> changedRows = new ArrayList<Integer>();
        Vector<Vector> dataVector = this.getDataVector();
        int size = dataVector.size();
        for (int i = 0; i < size; ++i) {
            Vector rowData = dataVector.get(i);
            Object firstCol = rowData.get(0);
            if (!(firstCol instanceof TENormalColumn) || ((TENormalColumn)firstCol).getFlag() != 2) continue;
            changedRows.add(new Integer(i));
        }
        return changedRows;
    }

    public ArrayList getChangedTableRows() {
        ArrayList<Integer> changedRows = new ArrayList<Integer>();
        Vector<Vector> dataVector = this.getDataVector();
        int size = dataVector.size();
        for (int i = 0; i < size; ++i) {
            Vector rowData = dataVector.get(i);
            Object firstCol = rowData.get(0);
            if (!(firstCol instanceof TENormalColumn) || ((TENormalColumn)firstCol).getFlag() != 2) continue;
            int viewRow = this.convertModelRowIndexToTable(i);
            changedRows.add(new Integer(viewRow));
        }
        return changedRows;
    }

    public void removeRows(int[] rows) {
        int i;
        int[] modelRows = new int[rows.length];
        for (i = 0; i < rows.length; ++i) {
            int modelRow;
            modelRows[i] = modelRow = this.convertTableRowIndexToModel(rows[i]);
        }
        Arrays.sort(modelRows);
        for (i = modelRows.length - 1; i >= 0; --i) {
            this.dataVector.remove(modelRows[i]);
        }
        if (this.sortCol > -1) {
            this.sortByColumn(this.sortCol, this.isAssentSort);
        } else {
            this.fireTableDataChanged();
        }
    }

    public void resetSortFlag() {
        this.sortCol = -1;
        this.isAssentSort = false;
    }

    public ArrayList getNewRows() {
        ArrayList<Integer> newRows = new ArrayList<Integer>();
        Vector<Vector> dataVector = this.getDataVector();
        int size = dataVector.size();
        for (int i = 0; i < size; ++i) {
            Vector rowData = dataVector.get(i);
            Object firstCol = rowData.get(0);
            if (!(firstCol instanceof TENormalColumn) || ((TENormalColumn)firstCol).getFlag() != 1) continue;
            newRows.add(new Integer(i));
        }
        return newRows;
    }

    private boolean initCellEditor() {
        if (this.fileName == null || this.fileName.equals("") || this.areaName == null || this.areaName.equals("")) {
            return false;
        }
        ArrayList colIfCtrlList = new ArrayList();
        InmFileDescObject file = InmProfileFactory.getFileDescObject(this.fileName);
        TEModelUtility.parseINI(this.areaName, colIfCtrlList, file);
        this.setColumnIdentifiers(new Vector(colIfCtrlList));
        int size = this.columnIdentifiers.size();
        for (int i = 0; i < size; ++i) {
            IfCtrl ctrl = (IfCtrl)this.columnIdentifiers.elementAt(i);
            this.colNames.add(ctrl.name);
        }
        return true;
    }

    public Vector getColumnIdentifierList() {
        return this.columnIdentifiers;
    }

    public IfCtrl getColumnIdentifiers(int col) {
        return (IfCtrl)this.columnIdentifiers.elementAt(col);
    }

    public TableCellEditor getCellEditor(int row, int col) {
        return this.getColumnIdentifiers((int)col).editor;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return !this.getColumnIdentifiers((int)col).bReadOnly;
    }

    public void setCellEditor(int col, TableCellEditor cellEditor) {
        this.getColumnIdentifiers((int)col).editor = cellEditor;
    }

    public ArrayList getChangedCells() {
        return this.changedCells;
    }

    public ArrayList getModelChangedCells() {
        return this.changedModelCells;
    }

    public int getModelChangedRow(int changedModelCell) {
        return changedModelCell & 0xFFFF;
    }

    public int getModelChangedCol(int changedModelCell) {
        return changedModelCell >> 16;
    }

    public int transitionToModelCell(int row, int col) {
        return (col << 16) + row;
    }

    public boolean isChangedAt(int row, int col) {
        return this.changedCells.contains(new Integer((col << 16) + row));
    }

    public void clearChangeFlag(int row, int col) {
        Integer cell = new Integer((col << 16) + row);
        if (this.changedCells.contains(cell)) {
            this.changedCells.remove(cell);
        }
    }

    public void clearModelChangeFlag(int row, int col) {
        Integer cell = new Integer((col << 16) + row);
        if (this.changedModelCells.contains(cell)) {
            this.changedModelCells.remove(cell);
        }
    }

    public void clearChangeFlag() {
        this.changedCells.clear();
        this.changedModelCells.clear();
    }

    public int[] getChangeCellRowCol(int cell, boolean model) {
        int[] changeRowAndCol = new int[2];
        int tempRow = cell & 0xFFFF;
        changeRowAndCol[0] = model ? this.convertTableRowIndexToModel(tempRow) : tempRow;
        changeRowAndCol[1] = (int)(((long)cell & 0xFFFF0000L) >> 16);
        return changeRowAndCol;
    }

    public TENameValuePair getValuePair(int col, int value) {
        IfCtrl ctrl = this.getColumnIdentifiers(col);
        if (null == ctrl || ctrl.type != 0) {
            return INVALID_PAIR;
        }
        for (int i = 0; i < ctrl.itemData.length; ++i) {
            TENameValuePair valuePair = (TENameValuePair)ctrl.itemData[i];
            if (valuePair.getValue() != value) continue;
            return valuePair;
        }
        return INVALID_PAIR;
    }

    public int getSortCol() {
        return this.sortCol;
    }

    public void setSortCol(int sortCol) {
        this.sortCol = sortCol;
    }
}

