/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.table;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmAreaDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmFileDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmProfileFactory;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmTable;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.HeaderListener;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.SortButtonRenderer;
import com.huawei.nglct.otdr.appletgraph.core.util.model.IfCtrl;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TECheckBoxTableRenderer;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TECustomable;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalCellRenderer;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalColumn;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalColumnCellRenderer;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TENormalTableModel;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TENormalTable
extends InmTable {
    protected TENormalTableModel tableModel = null;
    public TENormalCellRenderer cellrender = new TENormalCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!table.isCellEditable(row, column)) {
                this.setBackground(TENormalColumnCellRenderer.READONLYBACKCOLOR);
            } else {
                this.setBackground(table.getBackground());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    };
    private SortButtonRenderer headRenderer = new SortButtonRenderer();
    private boolean type = true;
    public static final int DEFAULT_HIDE = 0;
    public HashMap allColumns = new HashMap();
    private boolean bResize = true;

    public TENormalTable(TENormalTableModel model) {
        this(model, true);
    }

    public TENormalTable(TENormalTableModel model, boolean type) {
        super(model);
        this.type = type;
        this.tableModel = model;
        this.initialize();
    }

    private void initialize() {
        int inVisColSize;
        ArrayList<Object> inVisibleCol = new ArrayList<Object>();
        boolean bSortable = false;
        TableColumnModel columnModel = this.getColumnModel();
        HashMap<Integer, TableColumn> showColumns = new HashMap<Integer, TableColumn>();
        HashMap<String, IfCtrl> allColumnsKeyname = new HashMap<String, IfCtrl>();
        int size = columnModel.getColumnCount();
        for (int i = 0; i < size; ++i) {
            TableColumn tableColumn = columnModel.getColumn(i);
            IfCtrl columnCtrl = this.tableModel.getColumnIdentifiers(i);
            this.allColumns.put(columnCtrl.identifier, tableColumn);
            allColumnsKeyname.put(columnCtrl.identifier, columnCtrl);
            tableColumn.setIdentifier(columnCtrl.identifier);
            if (columnCtrl.filter >= 0) {
                showColumns.put(new Integer(columnCtrl.position), tableColumn);
            }
            if (columnCtrl.filter != 0) continue;
            inVisibleCol.add(tableColumn.getIdentifier());
        }
        Iterator it = this.allColumns.values().iterator();
        while (it.hasNext()) {
            columnModel.removeColumn((TableColumn)it.next());
        }
        size = showColumns.size();
        for (int i = 0; i < size; ++i) {
            Object obj = showColumns.get(new Integer(i));
            if (obj == null) continue;
            TableColumn tableColumn = (TableColumn)obj;
            IfCtrl ifctrl = (IfCtrl)allColumnsKeyname.get(tableColumn.getIdentifier());
            columnModel.addColumn(tableColumn);
            if (ifctrl.bSortable) {
                bSortable = true;
            } else {
                this.removeSortAction(tableColumn);
            }
            if (ifctrl.width > 0) {
                tableColumn.setPreferredWidth(ifctrl.width);
                this.bResize = false;
            }
            if (columnModel.getColumnCount() == 1) {
                tableColumn.setCellRenderer(new TENormalColumnCellRenderer(ifctrl.bReadOnly));
                continue;
            }
            if (ifctrl.type == 8) {
                tableColumn.setCellRenderer(new TECheckBoxTableRenderer());
                continue;
            }
            tableColumn.setCellRenderer(this.cellrender);
        }
        if (!this.bResize) {
            this.setAutoResizeMode(0);
        }
        if (bSortable) {
            this.setSortable(true);
            this.setTableHeaderListener();
        }
        if ((inVisColSize = inVisibleCol.size()) > 0) {
            String[] inVisCol = new String[inVisColSize];
            System.arraycopy(inVisibleCol.toArray(), 0, inVisCol, 0, inVisColSize);
        }
    }

    public void setTableHeaderListener() {
        JTableHeader header = this.getTableHeader();
        header.addMouseListener(new HeaderListener(header, this.headRenderer, this.tableModel));
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (this.type && this.tableModel != null) {
            int col = this.convertColumnIndexToModel(column);
            return this.tableModel.getCellEditor(row, col);
        }
        return super.getCellEditor(row, column);
    }

    protected SortButtonRenderer getRenderer() {
        return this.headRenderer;
    }

    public void repaintAll() {
        this.resizeAndRepaint();
    }

    protected TECustomable getCustomable() {
        TECustomable customI = new TECustomable(){

            @Override
            public void customShow(Vector visibleColumns) {
                TableColumnModel columnModel = TENormalTable.this.getColumnModel();
                Iterator e = TENormalTable.this.allColumns.values().iterator();
                while (e.hasNext()) {
                    columnModel.removeColumn((TableColumn)e.next());
                }
                int colNum = 0;
                int size = visibleColumns.size();
                for (int i = 0; i < size; ++i) {
                    Object obj = TENormalTable.this.allColumns.get(visibleColumns.get(i).toString().trim());
                    if (obj == null) continue;
                    TableColumn tableColumn = (TableColumn)obj;
                    columnModel.addColumn(tableColumn);
                    int colModel = TENormalTable.this.convertColumnIndexToModel(colNum);
                    IfCtrl columnCtrl = TENormalTable.this.tableModel.getColumnIdentifiers(colModel);
                    if (colNum == 0) {
                        tableColumn.setCellRenderer(new TENormalColumnCellRenderer(columnCtrl.bReadOnly));
                    } else {
                        tableColumn.setCellRenderer(TENormalTable.this.cellrender);
                    }
                    ++colNum;
                }
                TENormalTable.this.repaintAll();
            }

            @Override
            public String getConfigFile() {
                return TENormalTable.this.tableModel.getConfigFile();
            }

            @Override
            public String getConfigArea() {
                return TENormalTable.this.tableModel.getConfigArea();
            }

            @Override
            public Vector getColumnNames() {
                return TENormalTable.this.tableModel.getColumnNames();
            }
        };
        return customI;
    }

    public static void saveHeadWidth(String profile, String areaName, JTable table) {
        try {
            InmFileDescObject file = InmProfileFactory.getFileDescObject(profile);
            InmAreaDescObject areaObject = file.getAreaDescObject(areaName);
            TableColumnModel tableColumnModel = table.getColumnModel();
            int size = areaObject.getDescObjectCount();
            for (int i = 0; i < size; ++i) {
                int index = table.convertColumnIndexToView(i);
                if (index < 0) continue;
                InmDescObject descObject = areaObject.getDescObject(i);
                TableColumn tableColumn = tableColumnModel.getColumn(index);
                int width = tableColumn.getWidth();
                descObject.setPropertyValue("Width", String.valueOf(width));
                file.writeDescObject(descObject, true);
            }
        }
        catch (Exception ex) {
            TEAppletLogMgr.error("TENormalTable.saveHeadWidth() fail!", ex);
        }
    }

    public void saveHeadWidth() {
        TENormalTable.saveHeadWidth(this.tableModel.getConfigFile(), this.tableModel.getConfigArea(), this);
    }

    public static void refreshColumns(JTable table, Vector visibleColumns, HashMap columns) {
        TableColumnModel columnModel = table.getColumnModel();
        Iterator e = columns.values().iterator();
        while (e.hasNext()) {
            columnModel.removeColumn((TableColumn)e.next());
        }
        int size = visibleColumns.size();
        for (int i = 0; i < size; ++i) {
            String data = visibleColumns.get(i).toString().trim();
            Object obj = columns.get(data);
            if (obj == null) continue;
            TableColumn column = (TableColumn)obj;
            columnModel.addColumn(column);
        }
        table.getTableHeader().repaint();
    }

    public void setAllRowsNormalFlag() {
        int size = this.tableModel.getRowCount();
        for (int i = 0; i < size; ++i) {
            Object obj = this.tableModel.getValueAt(i, 0);
            if (!(obj instanceof TENormalColumn)) continue;
            ((TENormalColumn)obj).setFlag((byte)0);
        }
        this.repaint();
    }

    public void setRowsNormalFlag(int[] rowList) {
        int size = rowList.length;
        for (int i = 0; i < size; ++i) {
            Object obj = this.tableModel.getValueAt(rowList[i], 0);
            if (!(obj instanceof TENormalColumn)) continue;
            ((TENormalColumn)obj).setFlag((byte)0);
        }
        this.repaint();
    }

    @Override
    public boolean isUseAdapdation() {
        return this.bResize;
    }

    public void setBResize(boolean model) {
        this.bResize = model;
    }

    public void clearUp() {
        JTableHeader tableHeader = this.getTableHeader();
        EventListener[] listeners = tableHeader.getListeners(MouseListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            tableHeader.removeMouseListener((MouseListener)listeners[i]);
        }
        this.allColumns.clear();
        if (this.tableModel != null) {
            this.tableModel.getColumnIdentifierList().removeAllElements();
            this.tableModel.getColumnNames().removeAllElements();
        }
    }

    public static void showTableHeader(InmTable table, HashMap columns, Vector colIfCtrlList, SortButtonRenderer renderer) {
        TableColumn tableColumn;
        ArrayList<Object> inVisibleCol = new ArrayList<Object>();
        TableColumnModel columnModel = table.getColumnModel();
        HashMap<Integer, TableColumn> showColumns = new HashMap<Integer, TableColumn>();
        HashMap<String, IfCtrl> allColumnsKeyname = new HashMap<String, IfCtrl>();
        int size = columnModel.getColumnCount();
        for (int i = 0; i < size; ++i) {
            tableColumn = columnModel.getColumn(i);
            IfCtrl columnCtrl = (IfCtrl)colIfCtrlList.get(i);
            columns.put(columnCtrl.identifier, tableColumn);
            allColumnsKeyname.put(columnCtrl.identifier, columnCtrl);
            if (columnCtrl.filter >= 0) {
                showColumns.put(new Integer(columnCtrl.position), tableColumn);
            }
            if (columnCtrl.filter == 0) {
                inVisibleCol.add(tableColumn.getIdentifier());
            }
            if (columnCtrl.width <= 0) continue;
            tableColumn.setPreferredWidth(columnCtrl.width);
        }
        Iterator it = columns.values().iterator();
        while (it.hasNext()) {
            columnModel.removeColumn((TableColumn)it.next());
        }
        ArrayList colPositionList = new ArrayList(showColumns.keySet());
        Collections.sort(colPositionList);
        Object colPosObj = null;
        tableColumn = null;
        IfCtrl ifctrl = null;
        Iterator iter = colPositionList.iterator();
        while (iter.hasNext()) {
            colPosObj = showColumns.get(iter.next());
            tableColumn = colPosObj;
            ifctrl = (IfCtrl)allColumnsKeyname.get(tableColumn.getIdentifier());
            columnModel.addColumn(tableColumn);
            if (ifctrl.bSortable) {
                if (table instanceof InmTable) continue;
                tableColumn.setHeaderRenderer(renderer);
                continue;
            }
            if (!(table instanceof InmTable)) continue;
            table.removeSortAction(tableColumn);
        }
        int inVisColSize = inVisibleCol.size();
        if (inVisColSize > 0) {
            String[] inVisCol = new String[inVisColSize];
            System.arraycopy(inVisibleCol.toArray(), 0, inVisCol, 0, inVisColSize);
        }
    }
}

