/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.table;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmOptionPane;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmUtilResourceManager;
import com.huawei.nglct.otdr.appletgraph.core.imap.ui.HwTextField;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.zip.DataFormatException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TELongTextField
extends HwTextField {
    boolean bAlarm = true;
    int nLimit = 20;
    long min = 0L;
    long max = Long.MAX_VALUE;
    int ct = 0;
    int radix = -1;
    private boolean acceptNull = false;
    boolean isDirectInsert = false;
    FocusListener listener = new FocusListener(){

        @Override
        public synchronized void focusLost(FocusEvent e) {
            TELongTextField.this.doFocusOperation();
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }
    };

    public void setAcceptNull(boolean acceptNull) {
        this.acceptNull = acceptNull;
    }

    public TELongTextField() {
        this(0L, Long.MAX_VALUE, 10);
    }

    public TELongTextField(long minN) {
        this(minN, Long.MAX_VALUE, 10);
    }

    public TELongTextField(long minN, long maxN) {
        this(minN, maxN, 10);
    }

    public TELongTextField(long minN, long maxN, int radix) {
        this.setDocument(new LongDocument(this));
        this.min = minN;
        this.max = maxN;
        this.radix = radix;
        this.nLimit = this.min >= 0L ? 19 : 20;
        this.addFocusListener(this.listener);
    }

    public void removeFocusListener() {
        this.removeFocusListener(this.listener);
    }

    public long getValue() {
        String s = this.getText();
        if (s.length() == 0) {
            return this.min;
        }
        long value = s.equals("-") ? 0L : Long.parseLong(s, this.radix);
        if (value < this.min || value > this.max) {
            value = this.min;
        }
        return value;
    }

    public void setRange(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public void setAlarm(boolean bAlarm) {
        this.bAlarm = bAlarm;
    }

    @Override
    public String getText() {
        long value;
        try {
            value = Long.parseLong(super.getText(), this.radix);
        }
        catch (Exception e) {
            return super.getText();
        }
        if (this.max < value) {
            super.setText(Long.toString(this.max, this.radix));
            if (this.bAlarm && this.ct == 0) {
                Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                ++this.ct;
                Toolkit.getDefaultToolkit().beep();
                InmOptionPane.showMessageDialog(window, (Object)(InmUtilResourceManager.getString("KEY1") + Long.toString(this.min, this.radix) + InmUtilResourceManager.getString("KEY2") + Long.toString(this.max, this.radix) + InmUtilResourceManager.getString("KEY3")), InmUtilResourceManager.getString("KEY4"), 1);
                --this.ct;
            }
        }
        return super.getText();
    }

    public String getTextEx() {
        return super.getText();
    }

    public boolean getAcceptNull() {
        return this.acceptNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFocusOperation() {
        String text = this.getText();
        if (this.acceptNull && (text == null || text.equals(""))) {
            return;
        }
        try {
            if (text.length() == 0) {
                throw new DataFormatException();
            }
            long value = Long.parseLong(text, this.radix);
            if (value < this.min || value > this.max) {
                throw new DataFormatException();
            }
        }
        catch (DataFormatException ex) {
            if (this.bAlarm && this.ct == 0) {
                Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                ++this.ct;
                Toolkit.getDefaultToolkit().beep();
                InmOptionPane.showMessageDialog(window, (Object)(InmUtilResourceManager.getString("KEY1") + Long.toString(this.min, this.radix) + InmUtilResourceManager.getString("KEY2") + Long.toString(this.max, this.radix) + InmUtilResourceManager.getString("KEY3")), InmUtilResourceManager.getString("KEY4"), this.ct--);
            }
            this.isDirectInsert = true;
            this.setText(Long.toString(this.min, this.radix));
            this.isDirectInsert = false;
        }
        finally {
            this.doOperation();
        }
    }

    public void doOperation() {
    }

    class LongDocument
    extends PlainDocument {
        private JTextComponent textComponent;

        public LongDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            if (TELongTextField.this.isDirectInsert) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            String prevStr = this.textComponent.getText();
            String dbgStr = "";
            if (s.equals("-") && TELongTextField.this.min >= 0L) {
                return;
            }
            if (prevStr.trim().length() + s.trim().length() > TELongTextField.this.nLimit) {
                return;
            }
            try {
                if (offset > 0 && offset < prevStr.length()) {
                    dbgStr = prevStr.substring(0, offset) + s + prevStr.substring(offset, prevStr.length());
                    Long.parseLong(dbgStr, TELongTextField.this.radix);
                } else if (offset == 0) {
                    if (!s.equals("-") || this.textComponent.getText().length() != 0) {
                        dbgStr = s + prevStr;
                        Long.parseLong(dbgStr, TELongTextField.this.radix);
                    }
                } else {
                    dbgStr = prevStr + s;
                    Long.parseLong(dbgStr, TELongTextField.this.radix);
                }
            }
            catch (Exception ex) {
                return;
            }
            if (dbgStr.startsWith("00")) {
                return;
            }
            super.insertString(offset, s, attributeSet);
            long value = s.equals("-") && this.textComponent.getText().length() == 1 ? 0L : Long.parseLong(this.textComponent.getText(), TELongTextField.this.radix);
            if (TELongTextField.this.min >= 0L && (value > TELongTextField.this.max || value < 0L) || TELongTextField.this.max > 0L && TELongTextField.this.min < 0L && (value > TELongTextField.this.max || value < TELongTextField.this.min) || TELongTextField.this.max <= 0L && (value < TELongTextField.this.min || value > 0L)) {
                TELongTextField.this.setText(Long.toString(TELongTextField.this.max, TELongTextField.this.radix));
                if (TELongTextField.this.bAlarm && TELongTextField.this.ct == 0) {
                    Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
                    ++TELongTextField.this.ct;
                    this.textComponent.removeFocusListener(((TELongTextField)this.textComponent).listener);
                    Toolkit.getDefaultToolkit().beep();
                    InmOptionPane.showMessageDialog(window, (Object)(InmUtilResourceManager.getString("KEY1") + Long.toString(TELongTextField.this.min, TELongTextField.this.radix) + InmUtilResourceManager.getString("KEY2") + Long.toString(TELongTextField.this.max, TELongTextField.this.radix) + InmUtilResourceManager.getString("KEY3")), InmUtilResourceManager.getString("KEY4"), 1);
                    --TELongTextField.this.ct;
                    this.textComponent.addFocusListener(((TELongTextField)this.textComponent).listener);
                }
            }
        }
    }
}

