/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.table;

import com.huawei.nglct.otdr.appletgraph.core.util.TEIPTextField;
import com.huawei.nglct.otdr.appletgraph.core.util.TEIPValue;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class TEIPTextCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected TEIPTextField ipText = new TEIPTextField();
    protected int clickCountToStart = 2;

    @Override
    public Object getCellEditorValue() {
        return new TEIPValue(this.ipText.getValue());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof TEIPValue) {
            TEIPValue ip = (TEIPValue)value;
            this.ipText.setValue(ip.getValue());
        } else {
            this.ipText.setValue(0L);
        }
        return this.ipText;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }
}

