/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.table;

import com.huawei.nglct.otdr.appletgraph.core.util.table.TEFreeComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class TEFreeComponentEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    private static final long serialVersionUID = -4298017126912025663L;
    protected TEFreeComponent editorComponent;
    protected EditorDelegate delegate = new EditorDelegate();
    protected int clickCountToStart = 1;

    public TEFreeComponentEditor(TEFreeComponent editorComponent) {
        this.editorComponent = editorComponent;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.delegate.setValue(value);
        return this.editorComponent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getValue();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, false);
        this.delegate.setValue(stringValue);
        return this.editorComponent;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.editorComponent.shouldSelectCell(anEvent);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        private static final long serialVersionUID = -7850469254062655714L;

        protected EditorDelegate() {
        }

        Object getValue() {
            return TEFreeComponentEditor.this.editorComponent.getValue();
        }

        void setValue(Object value) {
            TEFreeComponentEditor.this.editorComponent.setValue(value);
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= TEFreeComponentEditor.this.clickCountToStart;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TEFreeComponentEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            TEFreeComponentEditor.this.stopCellEditing();
        }
    }
}

