/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.table;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmCellEditor;
import com.huawei.nglct.otdr.appletgraph.core.util.TEFloatTextField;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class TEFloatTableCellEditor
extends InmCellEditor
implements TableCellEditor {
    protected TEFloatTextField floatText;
    protected int textLen = 0;

    public TEFloatTableCellEditor() {
        this.floatText = new TEFloatTextField();
    }

    public TEFloatTableCellEditor(float min, float max, int textCol) {
        this.floatText = new TEFloatTextField(min, max);
        if (textCol > 0) {
            this.floatText.setColumns(textCol);
        }
    }

    public TEFloatTableCellEditor(float min) {
        this.floatText = new TEFloatTextField(min);
    }

    public TEFloatTableCellEditor(float min, float max) {
        this.floatText = new TEFloatTextField(min, max);
    }

    public void setTextColumn(int n) {
        if (n > 0) {
            this.textLen = n;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this.textLen > 0) {
            this.floatText.setColumns(this.textLen);
        }
        this.floatText.setText(value.toString());
        return this.floatText;
    }

    @Override
    public Object getCellEditorValue() {
        Float f = new Float(this.floatText.getValue());
        return f;
    }

    public void setCellEditorValue(Object value) {
        Float f = (Float)value;
        this.floatText.setText(f.toString());
    }

    public void setDecBitlen(int decBitlen) {
        this.floatText.setDecBitLen(decBitlen);
    }
}

