/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class TEComboBoxTableCellRenderer
extends JComboBox
implements TableCellRenderer {
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;

    public TEComboBoxTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    public TEComboBoxTableCellRenderer(JComboBox box) {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        for (int i = 0; i < box.getItemCount(); ++i) {
            this.addItem(box.getItemAt(i));
        }
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        super.setFont(table.getFont());
        if (hasFocus) {
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setSelectedItem(value);
        Color back = this.getBackground();
        boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        return this;
    }
}

