/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.table;

import com.huawei.nglct.otdr.appletgraph.core.util.table.PropertyInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class EditorRenderer
implements TableCellRenderer {
    private Hashtable controlMap;
    private Vector propertyList;
    private HashMap rendererMap;

    public EditorRenderer(Hashtable controlMap, Vector propertyList) {
        this.controlMap = controlMap;
        this.propertyList = propertyList;
        this.buildRendererMap();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (row < this.propertyList.size()) {
            Color uneditableColor = this.getUnEditableColor(table);
            Color editableColor = table.getBackground();
            PropertyInfo proInfo = (PropertyInfo)this.propertyList.get(row);
            Component retComponent = (Component)this.controlMap.get(proInfo.propertyName);
            Component rendererComponent = (Component)this.rendererMap.get(proInfo.propertyName);
            if (rendererComponent == null) {
                this.buildRendererMap(proInfo.propertyName, retComponent);
            }
            rendererComponent = (Component)this.rendererMap.get(proInfo.propertyName);
            if (retComponent instanceof JPasswordField) {
                JPasswordField passwordFieldRenderer = (JPasswordField)rendererComponent;
                JPasswordField passwordFieldEditor = (JPasswordField)retComponent;
                passwordFieldRenderer.setText(new String(passwordFieldEditor.getPassword()));
            } else if (retComponent instanceof JTextField) {
                JTextField textFieldRenderer = (JTextField)rendererComponent;
                JTextField textFieldEditor = (JTextField)retComponent;
                textFieldRenderer.setText(textFieldEditor.getText());
            } else if (retComponent instanceof JComboBox) {
                JComboBox comboBoxRenderer = (JComboBox)rendererComponent;
                JComboBox comboBoxEditor = (JComboBox)retComponent;
                comboBoxRenderer.removeAllItems();
                comboBoxRenderer.insertItemAt(comboBoxEditor.getSelectedItem(), 0);
                comboBoxRenderer.setSelectedIndex(0);
            } else if (retComponent instanceof JCheckBox) {
                JCheckBox checkBoxRenderer = (JCheckBox)rendererComponent;
                JCheckBox checkBoxEditor = (JCheckBox)retComponent;
                checkBoxRenderer.setSelected(checkBoxEditor.isSelected());
                checkBoxRenderer.setText(checkBoxEditor.getText());
            } else {
                if (retComponent instanceof Container) {
                    Component[] components = ((Container)retComponent).getComponents();
                    int size = components.length;
                    for (int i = 0; i < size; ++i) {
                        if (!(components[i] instanceof JTextField)) continue;
                        JTextField comp = (JTextField)components[i];
                        comp.getCaret().setVisible(false);
                        comp.select(0, 0);
                    }
                    return retComponent;
                }
                return retComponent;
            }
            if (proInfo.rw) {
                rendererComponent.setBackground(editableColor);
            } else {
                rendererComponent.setBackground(uneditableColor);
            }
            return rendererComponent;
        }
        return null;
    }

    public Color getUnEditableColor(JTable table) {
        return table.getTableHeader().getBackground();
    }

    public void buildRendererMap() {
        this.rendererMap = new HashMap();
        int size = this.propertyList.size();
        for (int i = 0; i < size; ++i) {
            String propertyName = ((PropertyInfo)this.propertyList.get((int)i)).propertyName;
            Component retComponent = (Component)this.controlMap.get(propertyName);
            this.buildRendererMap(propertyName, retComponent);
        }
    }

    public void buildRendererMap(String propertyName, Component retComponent) {
        if (retComponent instanceof JPasswordField) {
            this.rendererMap.put(propertyName, new JPasswordField());
        } else if (retComponent instanceof JTextField) {
            this.rendererMap.put(propertyName, new JTextField());
        } else if (retComponent instanceof JComboBox) {
            this.rendererMap.put(propertyName, new JComboBox());
        } else if (retComponent instanceof JCheckBox) {
            this.rendererMap.put(propertyName, new JCheckBox());
        } else {
            this.rendererMap.put(propertyName, retComponent);
        }
    }
}

