/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util.model;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmAreaDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmFileDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmIntegerCellEditor;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmIntegerTextField;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmLengthLimitTextField;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmLongCellEditor;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmLongTextField;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmProfileFactory;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.NameValuePair;
import com.huawei.nglct.otdr.appletgraph.core.util.TEFloatTextField;
import com.huawei.nglct.otdr.appletgraph.core.util.TENameValuePair;
import com.huawei.nglct.otdr.appletgraph.core.util.model.IfCtrl;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TEComboCellEditor;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TEFloatCellEditor;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TEFloatTableCellEditor;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TEIntegerCellEditor;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TELongCellEditor;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TELongTextField;
import com.huawei.nglct.otdr.appletgraph.core.util.table.TETextCellEditor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class TEModelUtility {
    public static final int INVALID = 0;
    public static final int READ_ONLY = 1;
    public static final int READWRITE = 2;
    public static final int FLOATMIN = -9999999;
    public static final int FLOATMAX = 9999999;

    public static void writeFromModelFile(InmFileDescObject file, String areaName, String modelFileName) {
        InmFileDescObject newFile = InmProfileFactory.getFileDescObject(modelFileName);
        InmAreaDescObject areaDesc = newFile.getAreaDescObject(areaName);
        int size = areaDesc.getDescObjectCount();
        for (int i = 0; i < size; ++i) {
            InmDescObject descObject = areaDesc.getDescObject(i);
            file.writeDescObject(descObject, true);
        }
    }

    public static void parseINI1(String areaName, ArrayList list, InmFileDescObject file) {
        ArrayList<TENameValuePair> ar = new ArrayList<TENameValuePair>(10);
        InmAreaDescObject area = file.getAreaDescObject(areaName);
        int num = 0;
        InmDescObject desc = area.getDescObject(0);
        while (desc != null) {
            String sReadOnly;
            IfCtrl ifCtrl;
            String propertyName = desc.getObjectName();
            String typeName = desc.getStringPropertyValue("type");
            String name = desc.getStringPropertyValue("name");
            if (name == null) {
                name = propertyName;
            }
            if (typeName == null) {
                typeName = "";
            }
            int attrID = -1;
            String attrString = desc.getStringPropertyValue("attrID");
            if (attrString != null) {
                attrID = Integer.parseInt(attrString);
            }
            attrString = null;
            if (typeName.equals("combobox")) {
                JComboBox<TENameValuePair> combo = new JComboBox<TENameValuePair>();
                TEComboCellEditor editor = new TEComboCellEditor(attrID, combo);
                editor.setClickCountToStart(2);
                int j = 1;
                ar.clear();
                String itemName = "";
                while ((itemName = desc.getStringPropertyValue("item" + j)) != null) {
                    TENameValuePair item = TEModelUtility.praseString(itemName);
                    ar.add(item);
                    combo.addItem(item);
                    ++j;
                }
                IfCtrl ifCtrl2 = new IfCtrl(name, (DefaultCellEditor)editor, ar);
                ifCtrl2.identifier = propertyName;
                ifCtrl2.type = 0;
                ifCtrl2.attrID = attrID;
                String sReadOnly2 = desc.getStringPropertyValue("readonly");
                if (sReadOnly2 != null && sReadOnly2.equals("1")) {
                    ifCtrl2.bReadOnly = true;
                }
                list.add(ifCtrl2);
            } else if (typeName.equals("integer")) {
                int min = Integer.parseInt(desc.getStringPropertyValue("min"));
                int max = Integer.parseInt(desc.getStringPropertyValue("max"));
                TEIntegerCellEditor editor = new TEIntegerCellEditor(attrID, new InmIntegerTextField(min, max));
                ifCtrl = new IfCtrl(name, editor);
                ifCtrl.identifier = propertyName;
                ifCtrl.type = 1;
                ifCtrl.attrID = attrID;
                sReadOnly = desc.getStringPropertyValue("readonly");
                if (sReadOnly != null && sReadOnly.equals("1")) {
                    ifCtrl.bReadOnly = true;
                }
                list.add(ifCtrl);
            } else if (typeName.equals("long")) {
                long min = Long.parseLong(desc.getStringPropertyValue("min"));
                long max = Long.parseLong(desc.getStringPropertyValue("max"));
                TELongCellEditor editor = new TELongCellEditor(attrID, new TELongTextField(min, max));
                IfCtrl ifCtrl3 = new IfCtrl(name, editor);
                ifCtrl3.identifier = propertyName;
                ifCtrl3.type = 7;
                ifCtrl3.attrID = attrID;
                String sReadOnly3 = desc.getStringPropertyValue("readonly");
                if (sReadOnly3 != null && sReadOnly3.equals("1")) {
                    ifCtrl3.bReadOnly = true;
                }
                list.add(ifCtrl3);
            } else if (typeName.equals("float")) {
                float min = -9999999.0f;
                float max = 9999999.0f;
                if (desc.getStringPropertyValue("min") != null) {
                    min = Float.parseFloat(desc.getStringPropertyValue("min"));
                }
                if (desc.getStringPropertyValue("max") != null) {
                    max = Float.parseFloat(desc.getStringPropertyValue("max"));
                }
                TEFloatCellEditor editor = new TEFloatCellEditor(attrID, new TEFloatTextField(min, max));
                ifCtrl = new IfCtrl(name, editor);
                ifCtrl.identifier = propertyName;
                ifCtrl.type = 2;
                ifCtrl.attrID = attrID;
                sReadOnly = desc.getStringPropertyValue("readonly");
                if (sReadOnly != null && sReadOnly.equals("1")) {
                    ifCtrl.bReadOnly = true;
                }
                list.add(ifCtrl);
            } else if (typeName.equals("text")) {
                String lengthString = desc.getStringPropertyValue("length");
                int length = 15;
                if (lengthString != null) {
                    length = Integer.parseInt(lengthString);
                }
                TETextCellEditor editor = new TETextCellEditor(attrID, new InmLengthLimitTextField(length));
                ifCtrl = new IfCtrl(name, editor);
                ifCtrl.identifier = propertyName;
                ifCtrl.attrID = attrID;
                ifCtrl.type = 3;
                sReadOnly = desc.getStringPropertyValue("readonly");
                if (sReadOnly != null && sReadOnly.equals("1")) {
                    ifCtrl.bReadOnly = true;
                }
                list.add(ifCtrl);
            } else {
                DefaultCellEditor editor = new DefaultCellEditor(new JTextField());
                IfCtrl ifCtrl4 = new IfCtrl(name, editor);
                ifCtrl4.identifier = propertyName;
                String sReadOnly4 = desc.getStringPropertyValue("readonly");
                if (sReadOnly4 != null && sReadOnly4.equals("1")) {
                    ifCtrl4.bReadOnly = true;
                }
                list.add(ifCtrl4);
            }
            desc = area.getDescObject(++num);
        }
    }

    public static void parseINI(String areaName, List list, InmFileDescObject file) {
        ArrayList ar = new ArrayList(10);
        InmAreaDescObject area = file.getAreaDescObject(areaName);
        int num = 0;
        InmDescObject desc = null;
        if (area != null) {
            desc = area.getDescObject(0);
        }
        while (desc != null) {
            String propertyName = desc.getObjectName().trim();
            String typeName = desc.getStringPropertyValue("type");
            String name = desc.getStringPropertyValue("name");
            if (name == null) {
                name = propertyName;
            }
            if (typeName == null) {
                typeName = "";
            }
            int attrID = -1;
            String attrString = desc.getStringPropertyValue("attrID");
            if (attrString != null) {
                attrID = Integer.parseInt(attrString);
            }
            attrString = null;
            if (typeName.equals("combobox")) {
                TEModelUtility.processComboBoxType(list, ar, desc, propertyName, name, attrID);
            } else if (typeName.equals("comboboxEx")) {
                TEModelUtility.processComboBoxExType(list, ar, desc, propertyName, name, attrID);
            } else if (typeName.equals("integer")) {
                TEModelUtility.processIntegerType(list, desc, propertyName, name, attrID);
            } else if (typeName.equals("long")) {
                TEModelUtility.processLongType(list, desc, propertyName, name, attrID);
            } else if (typeName.equals("float")) {
                TEModelUtility.processFloatType(list, desc, propertyName, name, attrID);
            } else if (typeName.equals("text")) {
                TEModelUtility.processTextType(list, desc, propertyName, name, attrID);
            } else if (typeName.equals("checkbox")) {
                TEModelUtility.processCheckBoxType(list, desc, propertyName, name, attrID);
            } else {
                TEModelUtility.processDefaultType(list, desc, propertyName, name);
            }
            desc = area.getDescObject(++num);
        }
    }

    private static void processDefaultType(List ifCtrlList, InmDescObject desc, String propertyName, String ifCtrlName) {
        String position;
        int columnwidth;
        String width;
        String sSortable;
        String sGenAttr;
        DefaultCellEditor editor = new DefaultCellEditor(new JTextField());
        IfCtrl ifCtrl = new IfCtrl(ifCtrlName, editor);
        ifCtrl.identifier = propertyName;
        String sReadOnly = desc.getStringPropertyValue("readonly");
        if (sReadOnly != null && sReadOnly.equals("1")) {
            ifCtrl.bReadOnly = true;
        }
        if ((sGenAttr = desc.getStringPropertyValue("GenAttr")) != null && sGenAttr.equals("1")) {
            ifCtrl.useAsGenAttribute = true;
        }
        if ((sSortable = desc.getStringPropertyValue("sortable")) != null && sSortable.equals("1")) {
            ifCtrl.bSortable = true;
        }
        ifCtrlList.add(ifCtrl);
        String filter = desc.getStringPropertyValue("Filter");
        if (filter != null) {
            ifCtrl.filter = Integer.parseInt(filter);
        }
        if ((width = desc.getStringPropertyValue("Width")) != null && (columnwidth = Integer.parseInt(width)) > 0) {
            ifCtrl.width = columnwidth;
        }
        if ((position = desc.getStringPropertyValue("Position")) != null) {
            ifCtrl.position = Integer.parseInt(position);
        }
    }

    private static void processCheckBoxType(List ifCtrlList, InmDescObject desc, String propertyName, String ifCtrlName, int attrID) {
        String position;
        int columnwidth;
        String width;
        String filter;
        String sSortable;
        String sGenAttr;
        JCheckBox checkBox = new JCheckBox();
        checkBox.setHorizontalAlignment(0);
        DefaultCellEditor editor = new DefaultCellEditor(checkBox);
        IfCtrl ifCtrl = new IfCtrl(ifCtrlName, editor);
        ifCtrl.identifier = propertyName;
        ifCtrl.type = 8;
        ifCtrl.attrID = attrID;
        String sReadOnly = desc.getStringPropertyValue("readonly");
        if (sReadOnly != null && sReadOnly.equals("1")) {
            ifCtrl.bReadOnly = true;
        }
        if ((sGenAttr = desc.getStringPropertyValue("GenAttr")) != null && sGenAttr.equals("1")) {
            ifCtrl.useAsGenAttribute = true;
        }
        if ((sSortable = desc.getStringPropertyValue("sortable")) != null && sSortable.equals("1")) {
            ifCtrl.bSortable = true;
        }
        if ((filter = desc.getStringPropertyValue("Filter")) != null) {
            ifCtrl.filter = Integer.parseInt(filter);
        }
        if ((width = desc.getStringPropertyValue("Width")) != null && (columnwidth = Integer.parseInt(width)) > 0) {
            ifCtrl.width = columnwidth;
        }
        if ((position = desc.getStringPropertyValue("Position")) != null) {
            ifCtrl.position = Integer.parseInt(position);
        }
        ifCtrlList.add(ifCtrl);
    }

    private static void processTextType(List ifCtrlList, InmDescObject desc, String propertyName, String ifCtrlName, int attrID) {
        String position;
        int columnwidth;
        String width;
        String filter;
        String sSortable;
        String sGenAttr;
        String lengthString = desc.getStringPropertyValue("length");
        int length = 15;
        if (lengthString != null) {
            length = Integer.parseInt(lengthString);
        }
        DefaultCellEditor editor = new DefaultCellEditor(new InmLengthLimitTextField(length));
        IfCtrl ifCtrl = new IfCtrl(ifCtrlName, editor);
        ifCtrl.identifier = propertyName;
        ifCtrl.attrID = attrID;
        ifCtrl.type = 3;
        String sReadOnly = desc.getStringPropertyValue("readonly");
        if (sReadOnly != null && sReadOnly.equals("1")) {
            ifCtrl.bReadOnly = true;
        }
        if ((sGenAttr = desc.getStringPropertyValue("GenAttr")) != null && sGenAttr.equals("1")) {
            ifCtrl.useAsGenAttribute = true;
        }
        if ((sSortable = desc.getStringPropertyValue("sortable")) != null && sSortable.equals("1")) {
            ifCtrl.bSortable = true;
        }
        if ((filter = desc.getStringPropertyValue("Filter")) != null) {
            ifCtrl.filter = Integer.parseInt(filter);
        }
        if ((width = desc.getStringPropertyValue("Width")) != null && (columnwidth = Integer.parseInt(width)) > 0) {
            ifCtrl.width = columnwidth;
        }
        if ((position = desc.getStringPropertyValue("Position")) != null) {
            ifCtrl.position = Integer.parseInt(position);
        }
        ifCtrlList.add(ifCtrl);
    }

    private static void processFloatType(List ifCtrlList, InmDescObject desc, String propertyName, String ifCtrlName, int attrID) {
        String position;
        int columnwidth;
        String width;
        String filter;
        String sSortable;
        String sGenAttr;
        float min = -9999999.0f;
        float max = 9999999.0f;
        if (desc.getStringPropertyValue("min") != null) {
            min = Float.parseFloat(desc.getStringPropertyValue("min"));
        }
        if (desc.getStringPropertyValue("max") != null) {
            max = Float.parseFloat(desc.getStringPropertyValue("max"));
        }
        TEFloatTableCellEditor editor = new TEFloatTableCellEditor(min, max);
        IfCtrl ifCtrl = new IfCtrl(ifCtrlName, editor);
        ifCtrl.identifier = propertyName;
        ifCtrl.type = 2;
        ifCtrl.attrID = attrID;
        String sReadOnly = desc.getStringPropertyValue("readonly");
        if (sReadOnly != null && sReadOnly.equals("1")) {
            ifCtrl.bReadOnly = true;
        }
        if ((sGenAttr = desc.getStringPropertyValue("GenAttr")) != null && sGenAttr.equals("1")) {
            ifCtrl.useAsGenAttribute = true;
        }
        if ((sSortable = desc.getStringPropertyValue("sortable")) != null && sSortable.equals("1")) {
            ifCtrl.bSortable = true;
        }
        if ((filter = desc.getStringPropertyValue("Filter")) != null) {
            ifCtrl.filter = Integer.parseInt(filter);
        }
        if ((width = desc.getStringPropertyValue("Width")) != null && (columnwidth = Integer.parseInt(width)) > 0) {
            ifCtrl.width = columnwidth;
        }
        if ((position = desc.getStringPropertyValue("Position")) != null) {
            ifCtrl.position = Integer.parseInt(position);
        }
        ifCtrlList.add(ifCtrl);
    }

    private static void processLongType(List ifCtrlList, InmDescObject desc, String propertyName, String ifCtrlName, int attrID) {
        String position;
        int columnwidth;
        String width;
        String filter;
        String sSortable;
        String sGenAttr;
        String sMax;
        long min = -1L;
        long max = Long.MAX_VALUE;
        String sMin = desc.getStringPropertyValue("min");
        if (null != sMin) {
            min = Long.parseLong(sMin);
        }
        if (null != (sMax = desc.getStringPropertyValue("max"))) {
            max = Long.parseLong(sMax);
        }
        InmLongCellEditor editor = new InmLongCellEditor(new InmLongTextField(min, max));
        IfCtrl ifCtrl = new IfCtrl(ifCtrlName, editor);
        ifCtrl.identifier = propertyName;
        ifCtrl.type = 7;
        ifCtrl.attrID = attrID;
        String sReadOnly = desc.getStringPropertyValue("readonly");
        if (sReadOnly != null && sReadOnly.equals("1")) {
            ifCtrl.bReadOnly = true;
        }
        if ((sGenAttr = desc.getStringPropertyValue("GenAttr")) != null && sGenAttr.equals("1")) {
            ifCtrl.useAsGenAttribute = true;
        }
        if ((sSortable = desc.getStringPropertyValue("sortable")) != null && sSortable.equals("1")) {
            ifCtrl.bSortable = true;
        }
        if ((filter = desc.getStringPropertyValue("Filter")) != null) {
            ifCtrl.filter = Integer.parseInt(filter);
        }
        if ((width = desc.getStringPropertyValue("Width")) != null && (columnwidth = Integer.parseInt(width)) > 0) {
            ifCtrl.width = columnwidth;
        }
        if ((position = desc.getStringPropertyValue("Position")) != null) {
            ifCtrl.position = Integer.parseInt(position);
        }
        ifCtrlList.add(ifCtrl);
    }

    private static void processIntegerType(List ifCtrlList, InmDescObject desc, String propertyName, String ifCtrlName, int attrID) {
        String position;
        int columnwidth;
        String width;
        String filter;
        String sSortable;
        String sGenAttr;
        String sMax;
        int min = -1;
        int max = Integer.MAX_VALUE;
        String sMin = desc.getStringPropertyValue("min");
        if (null != sMin) {
            min = Integer.parseInt(sMin);
        }
        if (null != (sMax = desc.getStringPropertyValue("max"))) {
            max = Integer.parseInt(sMax);
        }
        InmIntegerCellEditor editor = new InmIntegerCellEditor(new InmIntegerTextField(min, max));
        IfCtrl ifCtrl = new IfCtrl(ifCtrlName, editor);
        ifCtrl.identifier = propertyName;
        ifCtrl.type = 1;
        ifCtrl.attrID = attrID;
        String sReadOnly = desc.getStringPropertyValue("readonly");
        if (sReadOnly != null && sReadOnly.equals("1")) {
            ifCtrl.bReadOnly = true;
        }
        if ((sGenAttr = desc.getStringPropertyValue("GenAttr")) != null && sGenAttr.equals("1")) {
            ifCtrl.useAsGenAttribute = true;
        }
        if ((sSortable = desc.getStringPropertyValue("sortable")) != null && sSortable.equals("1")) {
            ifCtrl.bSortable = true;
        }
        if ((filter = desc.getStringPropertyValue("Filter")) != null) {
            ifCtrl.filter = new Integer(filter);
        }
        if ((width = desc.getStringPropertyValue("Width")) != null && (columnwidth = new Integer(width).intValue()) > 0) {
            ifCtrl.width = columnwidth;
        }
        if ((position = desc.getStringPropertyValue("Position")) != null) {
            ifCtrl.position = new Integer(position);
        }
        ifCtrlList.add(ifCtrl);
    }

    private static void processComboBoxExType(List ifCtrlList, ArrayList itemList, InmDescObject desc, String propertyName, String ifCtrlName, int attrID) {
        String position;
        int columnwidth;
        String width;
        String filter;
        String sSortable;
        String sGenAttr;
        JComboBox<NameValuePair> combo = new JComboBox<NameValuePair>();
        DefaultCellEditor editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(2);
        int j = 1;
        itemList.clear();
        String itemName = "";
        while ((itemName = desc.getStringPropertyValue("item" + j)) != null) {
            NameValuePair item = TEModelUtility.praseExString(itemName);
            itemList.add(item);
            combo.addItem(item);
            ++j;
        }
        IfCtrl ifCtrl = new IfCtrl(ifCtrlName, editor, itemList);
        ifCtrl.identifier = propertyName;
        ifCtrl.type = 6;
        ifCtrl.attrID = attrID;
        String sReadOnly = desc.getStringPropertyValue("readonly");
        if (sReadOnly != null && sReadOnly.equals("1")) {
            ifCtrl.bReadOnly = true;
        }
        if ((sGenAttr = desc.getStringPropertyValue("GenAttr")) != null && sGenAttr.equals("1")) {
            ifCtrl.useAsGenAttribute = true;
        }
        if ((sSortable = desc.getStringPropertyValue("sortable")) != null && sSortable.equals("1")) {
            ifCtrl.bSortable = true;
        }
        if ((filter = desc.getStringPropertyValue("Filter")) != null) {
            ifCtrl.filter = new Integer(filter);
        }
        if ((width = desc.getStringPropertyValue("Width")) != null && (columnwidth = new Integer(width).intValue()) > 0) {
            ifCtrl.width = columnwidth;
        }
        if ((position = desc.getStringPropertyValue("Position")) != null) {
            ifCtrl.position = new Integer(position);
        }
        ifCtrlList.add(ifCtrl);
    }

    private static void processComboBoxType(List ifCtrlList, ArrayList itemList, InmDescObject desc, String propertyName, String ifCtrlName, int attrID) {
        String position;
        int columnwidth;
        String width;
        String filter;
        String sSortable;
        String sGenAttr;
        JComboBox<TENameValuePair> combo = new JComboBox<TENameValuePair>();
        DefaultCellEditor editor = new DefaultCellEditor(combo);
        editor.setClickCountToStart(2);
        int j = 1;
        itemList.clear();
        String itemName = "";
        while ((itemName = desc.getStringPropertyValue("item" + j)) != null) {
            TENameValuePair item = TEModelUtility.praseString(itemName);
            itemList.add(item);
            combo.addItem(item);
            ++j;
        }
        IfCtrl ifCtrl = new IfCtrl(ifCtrlName, editor, itemList);
        ifCtrl.identifier = propertyName;
        ifCtrl.type = 0;
        ifCtrl.attrID = attrID;
        String sReadOnly = desc.getStringPropertyValue("readonly");
        if (sReadOnly != null && sReadOnly.equals("1")) {
            ifCtrl.bReadOnly = true;
        }
        if ((sGenAttr = desc.getStringPropertyValue("GenAttr")) != null && sGenAttr.equals("1")) {
            ifCtrl.useAsGenAttribute = true;
        }
        if ((sSortable = desc.getStringPropertyValue("sortable")) != null && sSortable.equals("1")) {
            ifCtrl.bSortable = true;
        }
        if ((filter = desc.getStringPropertyValue("Filter")) != null) {
            ifCtrl.filter = Integer.parseInt(filter);
        }
        if ((width = desc.getStringPropertyValue("Width")) != null && (columnwidth = Integer.parseInt(width)) > 0) {
            ifCtrl.width = columnwidth;
        }
        if ((position = desc.getStringPropertyValue("Position")) != null) {
            ifCtrl.position = Integer.parseInt(position);
        }
        ifCtrlList.add(ifCtrl);
    }

    public static TENameValuePair praseString(String itemName) {
        TENameValuePair result = new TENameValuePair();
        int pos = -1;
        for (int i = itemName.length() - 1; i >= 0; --i) {
            if (itemName.charAt(i) != ':') continue;
            pos = i;
            break;
        }
        if (pos > 0) {
            result.name = itemName.substring(0, pos);
            result.value = Integer.parseInt(itemName.substring(pos + 1).trim());
        } else {
            result.name = itemName;
            result.value = -1;
        }
        return result;
    }

    public static NameValuePair praseExString(String itemName) {
        NameValuePair result = new NameValuePair();
        int pos = -1;
        for (int i = itemName.length() - 1; i >= 0; --i) {
            if (itemName.charAt(i) != ':') continue;
            pos = i;
            break;
        }
        if (pos > 0) {
            result.setName(itemName.substring(0, pos));
            result.setValue(itemName.substring(pos + 1));
        } else {
            result.setName(itemName);
            result.setValue("");
        }
        return result;
    }

    public static void addTableGenAttr(JTable table, ArrayList list) {
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        int colCount = model.getColumnCount();
        TableColumnModel tableColumnModel = table.getColumnModel();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            IfCtrl ifCtrl = (IfCtrl)list.get(i);
            if (!ifCtrl.useAsGenAttribute) continue;
            model.addColumn(ifCtrl.name);
            tableColumnModel.getColumn(colCount + i).setCellEditor(ifCtrl.editor);
        }
    }
}

