/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util;

import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TENameTextField
extends JTextField {
    public static final int NORMAL_CHAR = 1;
    public static final int NET_CHAR = 2;
    public static final int SUBNET_CHAR = 3;
    public static final int NO_CHAR = 4;
    public static final int FILE_CHAR = 5;
    public static final int SONET_CHAR = 6;
    public static final int CUSTOMER_CHAR = 7;
    public static final int NeAndSubNetName_CHAR = 8;
    public static final int NET_LINKNAME_CHAR = 9;
    public static final int SONET_NENAME_CHAR = 10;
    private int maxLength = 32;
    private int cType = 1;
    private boolean isDirectInput = false;
    private ArrayList cNormalChar = new ArrayList();
    private char CN_BLANK = (char)12288;
    private char CN_LEFT_TRACKET = (char)65288;
    private char CN_RIGHT_TRACKET = (char)65289;

    public TENameTextField() {
        this.initNormalList();
        this.setDocument(new NameDocument(this));
    }

    public TENameTextField(int maxLength) {
        this();
        this.maxLength = maxLength;
    }

    public TENameTextField(int maxLength, int type) {
        this.cType = type;
        if (type == 2) {
            this.initNetList();
        } else if (type == 3) {
            this.initSubNetList();
        } else if (type == 4) {
            this.initNoSpecialChar();
        } else if (type == 5) {
            this.initFileCharList();
        } else if (type == 6) {
            this.initSONETCircuitCharList();
        } else if (type == 7) {
            this.initCustomerCharList();
        } else if (type == 8) {
            this.initNeAndSubNetNameList();
        } else if (type == 9) {
            this.initNetLinkNameList();
        } else {
            this.initNormalList();
        }
        this.setDocument(new NameDocument(this));
        if (maxLength > 0) {
            this.maxLength = maxLength;
        }
    }

    private void initNormalList() {
        this.cNormalChar.add(String.valueOf('/'));
        this.cNormalChar.add(String.valueOf('\\'));
        this.cNormalChar.add(String.valueOf('('));
        this.cNormalChar.add(String.valueOf(')'));
        this.cNormalChar.add(String.valueOf('-'));
        this.cNormalChar.add(String.valueOf('_'));
        this.cNormalChar.add(String.valueOf('.'));
        this.cNormalChar.add(String.valueOf('&'));
        this.cNormalChar.add(String.valueOf(' '));
    }

    private void initNetList() {
        this.cNormalChar.add(String.valueOf('\\'));
        this.cNormalChar.add(String.valueOf('/'));
        this.cNormalChar.add(String.valueOf('('));
        this.cNormalChar.add(String.valueOf(')'));
        this.cNormalChar.add(String.valueOf('-'));
        this.cNormalChar.add(String.valueOf('_'));
        this.cNormalChar.add(String.valueOf('.'));
        this.cNormalChar.add(String.valueOf(":"));
        this.cNormalChar.add(String.valueOf('+'));
        this.cNormalChar.add(String.valueOf(' '));
        this.cNormalChar.add(String.valueOf('&'));
        this.cNormalChar.add(String.valueOf('='));
    }

    private void initNetLinkNameList() {
        this.initNetList();
    }

    private void initCustomerCharList() {
        this.cNormalChar.add(String.valueOf('/'));
        this.cNormalChar.add(String.valueOf('('));
        this.cNormalChar.add(String.valueOf(')'));
        this.cNormalChar.add(String.valueOf('-'));
        this.cNormalChar.add(String.valueOf('_'));
        this.cNormalChar.add(String.valueOf('.'));
        this.cNormalChar.add(String.valueOf(":"));
        this.cNormalChar.add(String.valueOf('+'));
        this.cNormalChar.add(String.valueOf(' '));
    }

    private void initNeAndSubNetNameList() {
        this.initNormalList();
    }

    private void initSubNetList() {
        this.cNormalChar.add(String.valueOf('/'));
        this.cNormalChar.add(String.valueOf('\\'));
        this.cNormalChar.add(String.valueOf('('));
        this.cNormalChar.add(String.valueOf(')'));
        this.cNormalChar.add(String.valueOf('-'));
        this.cNormalChar.add(String.valueOf('_'));
        this.cNormalChar.add(String.valueOf('.'));
        this.cNormalChar.add(String.valueOf(':'));
        this.cNormalChar.add(String.valueOf('+'));
        this.cNormalChar.add(String.valueOf('&'));
        this.cNormalChar.add(String.valueOf(' '));
        this.cNormalChar.add(String.valueOf('/'));
    }

    private void initFileCharList() {
        this.cNormalChar.add(String.valueOf('/'));
        this.cNormalChar.add(String.valueOf('\\'));
        this.cNormalChar.add(String.valueOf('*'));
        this.cNormalChar.add(String.valueOf('?'));
        this.cNormalChar.add(String.valueOf('\"'));
        this.cNormalChar.add(String.valueOf('<'));
        this.cNormalChar.add(String.valueOf('>'));
        this.cNormalChar.add(String.valueOf('|'));
        this.cNormalChar.add(String.valueOf(':'));
        this.cNormalChar.add(String.valueOf(' '));
    }

    private void initSONETCircuitCharList() {
        this.cNormalChar.add(String.valueOf('/'));
        this.cNormalChar.add(String.valueOf('('));
        this.cNormalChar.add(String.valueOf(')'));
        this.cNormalChar.add(String.valueOf('-'));
        this.cNormalChar.add(String.valueOf('_'));
        this.cNormalChar.add(String.valueOf(' '));
    }

    private void initSONETNECharList() {
        this.cNormalChar.add(String.valueOf('-'));
        this.cNormalChar.add(String.valueOf('_'));
        this.cNormalChar.add(String.valueOf('.'));
        this.cNormalChar.add(String.valueOf('&'));
        this.cNormalChar.add(String.valueOf(' '));
    }

    private void initNoSpecialChar() {
        this.cNormalChar = null;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    public void setTextEx(String str) {
        this.isDirectInput = true;
        super.setText(str);
        this.isDirectInput = false;
    }

    public String makeTextValid(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        if (this.cNormalChar == null) {
            return text;
        }
        String lastChar = text.substring(text.length() - 1);
        int length = this.cNormalChar.size();
        boolean isLastCharValid = true;
        for (int i = 0; i < length; ++i) {
            if (!lastChar.equals(this.cNormalChar.get(i))) continue;
            text = text.substring(0, text.length() - 1);
            isLastCharValid = false;
        }
        if (!isLastCharValid) {
            text = this.makeTextValid(text);
        }
        return text;
    }

    public String parseName(String s) {
        char[] temp = s.toCharArray();
        String one = null;
        for (int i = 0; i < temp.length; ++i) {
            if (this.cType == 8 || this.cType == 9) {
                if (this.isLatinByte(temp[i]) && (this.isDigit(temp[i]) || this.isLetter(temp[i]) || this.isValidByte(temp[i])) || this.isChinaByte(temp[i]) || this.isSpecialChar(temp[i]) || this.isOccidentByte(temp[i])) {
                    one = s;
                    continue;
                }
                System.out.println("invalid char: " + temp[i] + "(" + temp[i] + ")= " + Character.UnicodeBlock.of(temp[i]));
                return null;
            }
            if (this.isLatinByte(temp[i]) && (this.isDigit(temp[i]) || this.isLetter(temp[i]) || this.isValidByte(temp[i])) || this.isChinaByte(temp[i]) || this.isSpecialChar(temp[i])) {
                one = s;
                continue;
            }
            System.out.println("invalid char: " + temp[i] + "(" + temp[i] + ")= " + Character.UnicodeBlock.of(temp[i]));
            return null;
        }
        one = s;
        return one;
    }

    boolean isOccidentByte(char c) {
        return Character.UnicodeBlock.of(c) == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || Character.UnicodeBlock.of(c) == Character.UnicodeBlock.LATIN_EXTENDED_A;
    }

    boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    boolean isValidByte(char c) {
        if (this.cType == 5) {
            return this.isValidFileByte(c);
        }
        return this.isValidNameByte(c);
    }

    boolean isValidNameByte(char c) {
        if (this.cNormalChar == null) {
            return false;
        }
        int length = this.cNormalChar.size();
        for (int i = 0; i < length; ++i) {
            if (!this.cNormalChar.get(i).equals(String.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    boolean isSpecialChar(char c) {
        return c == this.CN_BLANK || c == this.CN_LEFT_TRACKET || c == this.CN_RIGHT_TRACKET;
    }

    boolean isValidFileByte(char c) {
        if (this.cNormalChar == null) {
            return false;
        }
        int length = this.cNormalChar.size();
        for (int i = 0; i < length; ++i) {
            if (!this.cNormalChar.get(i).equals(String.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    boolean isChinaByte(char c) {
        return Character.UnicodeBlock.of(c) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS;
    }

    boolean isLatinByte(char c) {
        return Character.UnicodeBlock.of(c) == Character.UnicodeBlock.BASIC_LATIN;
    }

    class NameDocument
    extends PlainDocument {
        private static final long serialVersionUID = -6408451671413390215L;
        private JTextComponent textComponent;

        public NameDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            if (TENameTextField.this.isDirectInput) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            try {
                if (TENameTextField.this.parseName(s) == null) {
                    return;
                }
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int length = this.textComponent.getText().getBytes().length + s.getBytes().length;
            if (length > TENameTextField.this.maxLength) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                super.insertString(offset, s, attributeSet);
            }
        }
    }
}

