/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TEIntegerTextField
extends JTextField {
    boolean minAlarm = true;
    boolean maxAlarm = true;
    int min = 0;
    int max = Integer.MAX_VALUE;
    int defaultValue = 0;
    int[] excludeValue = null;
    boolean isLocked = false;
    boolean isDirectInsert = false;
    IntegerDocument document = new IntegerDocument(this);
    private int ct = 0;
    private boolean isNULL = false;
    private boolean allowNull = false;

    public TEIntegerTextField() {
        this(0, Integer.MAX_VALUE);
    }

    public TEIntegerTextField(int minN) {
        this(minN, Integer.MAX_VALUE);
    }

    public TEIntegerTextField(int minN, int maxN, int defaultN) {
        this.setDocument(this.document);
        this.min = minN;
        this.max = maxN;
        this.defaultValue = defaultN;
        this.addFocusListener(new FocusListener(){

            @Override
            public synchronized void focusLost(FocusEvent e) {
                if (TEIntegerTextField.this.isLocked) {
                    return;
                }
                String text = TEIntegerTextField.this.getText();
                try {
                    if ((text.length() == 0 || TEIntegerTextField.this.isNULL) && !TEIntegerTextField.this.allowNull) {
                        TEIntegerTextField.this.confirm();
                        return;
                    }
                    int value = Integer.parseInt(text);
                    if (!(value >= TEIntegerTextField.this.min && value <= TEIntegerTextField.this.max || TEIntegerTextField.this.isExcludeValue(value))) {
                        TEIntegerTextField.this.confirm();
                    }
                }
                catch (Exception ex) {
                    TEAppletLogMgr.error("TEIntegerTextField.focusLost() fail!", ex);
                }
            }

            @Override
            public void focusGained(FocusEvent evt) {
                TEIntegerTextField.this.isLocked = false;
            }
        });
    }

    public TEIntegerTextField(int minN, int maxN) {
        this(minN, maxN, minN);
    }

    public void setAllowNull(boolean b) {
        this.allowNull = b;
    }

    public void confirm() {
        this.isLocked = true;
        if (this.minAlarm && this.ct == 0) {
            ++this.ct;
            Toolkit.getDefaultToolkit().beep();
            this.document.isMsgWillDisplayed = false;
            --this.ct;
        }
        this.isDirectInsert = true;
        this.setText(new Integer(this.defaultValue).toString());
        this.isDirectInsert = false;
    }

    @Override
    public String getText() {
        String s = super.getText();
        if (s == null || s.equals("")) {
            if (this.allowNull) {
                return "";
            }
            this.isNULL = true;
            return "0";
        }
        this.isNULL = false;
        try {
            Integer.parseInt(s);
            return s;
        }
        catch (Exception e) {
            this.isNULL = true;
            return "0";
        }
    }

    public void reSetRange(int _min, int _max, int _default) {
        this.max = _max;
        this.min = _min;
        this.defaultValue = _default;
    }

    public void reSetRange(int _min, int _max) {
        this.reSetRange(_min, _max, _min);
    }

    public void setExcludeValue(int[] excludeValue) {
        this.excludeValue = excludeValue;
    }

    private boolean isExcludeValue(int value) {
        if (this.excludeValue == null || this.excludeValue.length <= 0) {
            return false;
        }
        for (int i = 0; i < this.excludeValue.length; ++i) {
            if (value != this.excludeValue[i]) continue;
            return true;
        }
        return false;
    }

    public void setTextDirect(String str) {
        this.isDirectInsert = true;
        super.setText(str);
        this.isDirectInsert = false;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getValue() {
        String s = this.getText();
        if (s.length() == 0) {
            return this.min;
        }
        int value = s.equals("-") ? 0 : Integer.parseInt(s);
        if (!(value >= this.min && value <= this.max || this.isExcludeValue(value))) {
            value = this.min;
        }
        return value;
    }

    public void setAlarm(boolean bAlarm) {
        this.minAlarm = bAlarm;
        this.maxAlarm = bAlarm;
    }

    public void setMinAlarm(boolean bAlarm) {
        this.minAlarm = bAlarm;
    }

    public void setMaxAlarm(boolean bAlarm) {
        this.maxAlarm = bAlarm;
    }

    class IntegerDocument
    extends PlainDocument {
        private JTextComponent textComponent;
        public boolean isMsgWillDisplayed = false;

        public IntegerDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            if (TEIntegerTextField.this.isDirectInsert) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            String prevStr = this.textComponent.getText();
            String dbgStr = "";
            if (prevStr.equals("0") && s.equals("0") && offset != 0) {
                return;
            }
            if (s.equals("-") && TEIntegerTextField.this.min >= 0) {
                return;
            }
            try {
                if (offset > 0 && offset < prevStr.length()) {
                    dbgStr = prevStr.substring(0, offset) + s + prevStr.substring(offset, prevStr.length());
                    Integer.parseInt(dbgStr);
                } else if (offset == 0) {
                    if (!s.equals("-") || this.textComponent.getText().length() != 0) {
                        dbgStr = s + prevStr;
                        Integer.parseInt(dbgStr);
                    }
                } else {
                    dbgStr = prevStr + s;
                    Integer.parseInt(dbgStr);
                }
            }
            catch (Exception ex) {
                return;
            }
            if (dbgStr.startsWith("00") && !TEIntegerTextField.this.isNULL) {
                return;
            }
            super.insertString(offset, s, attributeSet);
            int value = s.equals("-") && this.textComponent.getText().length() == 1 ? 0 : Integer.parseInt(this.textComponent.getText());
            if (TEIntegerTextField.this.min >= 0 && (value > TEIntegerTextField.this.max || value < 0) || TEIntegerTextField.this.max > 0 && TEIntegerTextField.this.min < 0 && (value > TEIntegerTextField.this.max || value < TEIntegerTextField.this.min) || TEIntegerTextField.this.max <= 0 && (value < TEIntegerTextField.this.min || value > 0)) {
                super.remove(offset, 1);
                if (TEIntegerTextField.this.maxAlarm && TEIntegerTextField.this.ct == 0) {
                    TEIntegerTextField.this.ct++;
                    this.isMsgWillDisplayed = true;
                    Toolkit.getDefaultToolkit().beep();
                    this.isMsgWillDisplayed = false;
                    TEIntegerTextField.this.ct--;
                }
                this.textComponent.setText(new Integer(TEIntegerTextField.this.max).toString());
            }
        }
    }
}

