/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmIntegerTextField;
import com.huawei.nglct.otdr.appletgraph.core.util.TENameValuePair;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class TEIntegerComboBoxEditor
extends BasicComboBoxEditor {
    private Object oldValue;
    private int minValue;

    public TEIntegerComboBoxEditor(int min, int max) {
        this(min, max, false);
    }

    public TEIntegerComboBoxEditor(int min, int max, boolean withBorder) {
        this.minValue = min;
        this.editor = new IntegerTextField(min, max);
        if (withBorder) {
            this.editor.setBorder(BorderFactory.createEtchedBorder());
        } else {
            this.editor.setBorder(null);
        }
    }

    public JTextField getEditor() {
        return this.editor;
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject != null) {
            if (anObject instanceof TENameValuePair) {
                this.editor.setText(String.valueOf(((TENameValuePair)anObject).value));
            } else {
                this.editor.setText(anObject.toString());
            }
            this.oldValue = anObject;
        } else {
            this.editor.setText(String.valueOf(this.minValue));
        }
    }

    @Override
    public Object getItem() {
        Object newValue = this.editor.getText();
        if (this.oldValue != null && !(this.oldValue instanceof String)) {
            if (newValue.equals(this.oldValue.toString())) {
                return this.oldValue;
            }
            if (this.oldValue instanceof TENameValuePair && newValue.equals(String.valueOf(((TENameValuePair)this.oldValue).value))) {
                return newValue;
            }
            Class<?> clazz = this.oldValue.getClass();
            try {
                Method method = clazz.getMethod("valueOf", String.class);
                newValue = method.invoke(this.oldValue, this.editor.getText());
            }
            catch (Exception ex) {
                TEAppletLogMgr.error("TEIntegerComboBoxEditor.getItem() Exception!", ex);
            }
        }
        return newValue;
    }

    static class IntegerTextField
    extends InmIntegerTextField {
        public IntegerTextField(int min, int max) {
            super(min, max);
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        public void setBorder(Border b) {
            super.setBorder(b);
        }
    }
}

