/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TEFloatTextField
extends JTextField {
    boolean bAlarm = true;
    boolean isDirectInsert = false;
    int ct = 0;
    int decBitLen = 0;
    float min = Float.MIN_VALUE;
    float max = Float.MAX_VALUE;
    private static final int ZEROLEN = 4;
    FocusListener listener = new FocusListener(){

        @Override
        public synchronized void focusLost(FocusEvent e) {
            try {
                float value;
                String text = TEFloatTextField.this.getText();
                if ("-".equals(text)) {
                    TEFloatTextField.this.setText(Float.toString(TEFloatTextField.this.getMin()));
                } else if (null != text && text.length() > 0 && ((value = Float.parseFloat(text)) < TEFloatTextField.this.min || value > TEFloatTextField.this.max)) {
                    this.confirm();
                }
            }
            catch (Exception ex) {
                TEAppletLogMgr.error("TEFloatTextField.focusLost() fail!", ex);
            }
        }

        private void confirm() {
            if (TEFloatTextField.this.ct == 0 && TEFloatTextField.this.bAlarm) {
                ++TEFloatTextField.this.ct;
                TEFloatTextField.this.removeFocusListener(this);
                Toolkit.getDefaultToolkit().beep();
                TEFloatTextField.this.isDirectInsert = true;
                TEFloatTextField.this.setText(new Float(TEFloatTextField.this.min).toString());
                TEFloatTextField.this.isDirectInsert = false;
                TEFloatTextField.this.requestFocus();
                TEFloatTextField.this.addFocusListener(TEFloatTextField.this.listener);
                --TEFloatTextField.this.ct;
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }
    };
    private String prevStr;

    public TEFloatTextField(float minf, float maxf) {
        this.setDocument(new FloatDocument(this));
        this.min = minf;
        this.max = maxf;
        this.addFocusListener(this.listener);
    }

    public TEFloatTextField() {
        this(Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public TEFloatTextField(float minf) {
        this(minf, Float.MAX_VALUE);
    }

    public float getValue() {
        float value;
        String s = this.getText();
        if (s.length() == 0) {
            return this.min;
        }
        char c = s.charAt(s.length() - 1);
        if (s.equals("+") || s.equals("-")) {
            float f = 0.0f;
        }
        try {
            value = c == 'e' || c == 'E' || c == '+' || c == '-' ? Float.parseFloat(this.getText() + "0") : Float.parseFloat(this.getText());
        }
        catch (Exception e) {
            value = 0.0f;
        }
        if (value < this.min || value > this.max) {
            value = this.min;
        }
        return value;
    }

    public void setRange(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public void setAlarm(boolean bAlarm) {
        this.bAlarm = bAlarm;
    }

    public void setDecBitLen(int decBitLen) {
        this.decBitLen = decBitLen;
    }

    private int getBitLen() {
        int maxLen;
        int minLen = this.getFloatLen(this.min);
        if (minLen > (maxLen = this.getFloatLen(this.max))) {
            return minLen + 1;
        }
        return maxLen + 1;
    }

    private int getFloatLen(float value) {
        float temp = value;
        int len = 0;
        if (value == 0.0f) {
            len = 1;
        }
        if (value < 0.0f) {
            value = -value;
            len = 1;
        }
        if (value > 0.0f) {
            String str = String.valueOf(temp);
            len += str.length();
        }
        return len;
    }

    @Override
    public String getText() {
        String s = super.getText();
        if (s == null || s.equals("")) {
            return "0.0";
        }
        return s;
    }

    public void removeFocusListeners() {
        this.removeFocusListener(this.listener);
    }

    class FloatDocument
    extends PlainDocument {
        private JTextComponent textComponent;

        public FloatDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            float value;
            int insertCount = s.length();
            if (TEFloatTextField.this.isDirectInsert) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            TEFloatTextField.this.prevStr = this.textComponent.getText();
            int decBitAt = TEFloatTextField.this.prevStr.lastIndexOf(".");
            if (decBitAt != -1 && decBitAt < offset) {
                int decLen = TEFloatTextField.this.prevStr.length() - decBitAt - 1 + insertCount;
                if (TEFloatTextField.this.decBitLen > 0 && decLen > TEFloatTextField.this.decBitLen) {
                    return;
                }
            }
            if (s.equals(".") && offset + TEFloatTextField.this.decBitLen < TEFloatTextField.this.prevStr.length()) {
                return;
            }
            int textLen = TEFloatTextField.this.getBitLen();
            if (TEFloatTextField.this.prevStr.length() > textLen) {
                return;
            }
            String dbgStr = "";
            try {
                if (offset > 0 && offset < TEFloatTextField.this.prevStr.length()) {
                    dbgStr = TEFloatTextField.this.prevStr.substring(0, offset) + s + TEFloatTextField.this.prevStr.substring(offset, TEFloatTextField.this.prevStr.length());
                    Float.parseFloat(dbgStr);
                } else if (offset == 0) {
                    if (TEFloatTextField.this.prevStr.equals("0.0")) {
                        TEFloatTextField.this.prevStr = "0";
                    }
                    if (!s.equals("+") && !s.equals("-")) {
                        dbgStr = s + TEFloatTextField.this.prevStr;
                        Float.parseFloat(dbgStr);
                    }
                } else {
                    if (s.equalsIgnoreCase("f") || s.equalsIgnoreCase("d")) {
                        return;
                    }
                    if (s.equalsIgnoreCase("e") || s.equals("+") || s.equals("-")) {
                        dbgStr = TEFloatTextField.this.prevStr + s + "0";
                        Float.parseFloat(dbgStr);
                    } else {
                        dbgStr = TEFloatTextField.this.prevStr + s;
                        Float.parseFloat(dbgStr);
                    }
                }
            }
            catch (Exception ex) {
                return;
            }
            if (TEFloatTextField.this.prevStr.equals("0") && s.equals("0") && offset != 0) {
                return;
            }
            if ((dbgStr.startsWith("00") || dbgStr.startsWith("+00") || dbgStr.startsWith("-00")) && (TEFloatTextField.this.prevStr.startsWith("00") || TEFloatTextField.this.prevStr.startsWith("+00") || TEFloatTextField.this.prevStr.startsWith("-00")) && s.equals("0") && offset < 4) {
                return;
            }
            super.insertString(offset, s, attributeSet);
            try {
                value = (s.equalsIgnoreCase("e") || s.equals("+") || s.equals("-")) && offset == TEFloatTextField.this.prevStr.length() ? Float.parseFloat(this.textComponent.getText() + "0") : Float.parseFloat(this.textComponent.getText());
            }
            catch (Exception e) {
                return;
            }
            if (TEFloatTextField.this.min >= 0.0f && (value > TEFloatTextField.this.max || value < 0.0f) || TEFloatTextField.this.max > 0.0f && TEFloatTextField.this.min < 0.0f && (value > TEFloatTextField.this.max || value < TEFloatTextField.this.min) || TEFloatTextField.this.max <= 0.0f && (value < TEFloatTextField.this.min || value > 0.0f)) {
                super.remove(offset, insertCount);
                if (TEFloatTextField.this.bAlarm && TEFloatTextField.this.ct == 0) {
                    ++TEFloatTextField.this.ct;
                    TEFloatTextField.this.removeFocusListener(TEFloatTextField.this.listener);
                    Toolkit.getDefaultToolkit().beep();
                    TEFloatTextField.this.requestFocus();
                    TEFloatTextField.this.addFocusListener(TEFloatTextField.this.listener);
                    --TEFloatTextField.this.ct;
                }
            }
        }
    }
}

