/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmAreaDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmFileDescObject;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmProfileFactory;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.NameValuePair;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.InmEntry;
import com.huawei.nglct.otdr.appletgraph.core.util.TENameValuePair;
import com.huawei.nglct.otdr.appletgraph.core.util.ValueInterface;
import java.util.List;
import javax.swing.JComboBox;

public class TEEnumUtility {
    public InmFileDescObject file;
    public String fileName;

    public TEEnumUtility(String fileName) {
        this.fileName = fileName;
        this.file = InmProfileFactory.getFileDescObject(fileName);
    }

    protected void finalized() {
        InmProfileFactory.removeFileDescObject(this.fileName);
    }

    public JComboBox getComboBox(String desc) {
        JComboBox box = new JComboBox();
        this.fillComboBox(box, desc);
        return box;
    }

    public JComboBox getComboBox(String desc, int limit) {
        JComboBox box = new JComboBox();
        this.fillComboBox(box, desc, limit);
        return box;
    }

    public void fillComboBox(JComboBox box, String desc) {
        Object obj = box.getSelectedItem();
        box.removeAllItems();
        try {
            InmAreaDescObject areaObject = this.file.getAreaDescObject(desc);
            for (int i = 0; i < areaObject.getDescObjectCount(); ++i) {
                InmDescObject descObject = areaObject.getDescObject(i);
                Integer type = new Integer(descObject.getStringPropertyValue("type"));
                String name = descObject.getStringPropertyValue("name");
                TEIntEnum enumer = new TEIntEnum(type, name, desc);
                box.addItem(enumer);
                if (obj == null || !obj.toString().trim().equals(name.trim())) continue;
                box.setSelectedItem(enumer);
            }
        }
        catch (NumberFormatException e) {
            TEAppletLogMgr.error("TEEnumUtility.fillComboBox() fail!", e);
        }
    }

    public void fillComboBox(JComboBox box, String desc, int limit) {
        Object obj = box.getSelectedItem();
        box.removeAllItems();
        try {
            InmAreaDescObject areaObject = this.file.getAreaDescObject(desc);
            for (int i = 0; i < areaObject.getDescObjectCount(); ++i) {
                InmDescObject descObject = areaObject.getDescObject(i);
                Integer type = new Integer(descObject.getStringPropertyValue("type"));
                String name = descObject.getStringPropertyValue("name");
                if (type > limit) continue;
                TEIntEnum enumer = new TEIntEnum(type, name, desc);
                box.addItem(enumer);
                if (obj == null || !obj.toString().trim().equals(name.trim())) continue;
                box.setSelectedItem(enumer);
            }
        }
        catch (NumberFormatException e) {
            TEAppletLogMgr.error("TEEnumUtility.fillComboBox() fail!", e);
        }
    }

    public void fillStr2StrComboBox(JComboBox box, String desc) {
        Object obj = box.getSelectedItem();
        box.removeAllItems();
        try {
            InmAreaDescObject areaObject = this.file.getAreaDescObject(desc);
            for (int i = 0; i < areaObject.getDescObjectCount(); ++i) {
                InmDescObject descObject = areaObject.getDescObject(i);
                String type = descObject.getStringPropertyValue("type");
                String name = descObject.getStringPropertyValue("name");
                NameValuePair enumer = new NameValuePair(name, type);
                box.addItem(enumer);
                if (obj == null || !obj.toString().trim().equals(name.trim())) continue;
                box.setSelectedItem(enumer);
            }
        }
        catch (NumberFormatException e) {
            TEAppletLogMgr.error("TEEnumUtility.fillStr2StrComboBox() fail!", e);
        }
    }

    public String getEnumName(int value, String enumName) {
        TEIntEnum intEnum = new TEIntEnum(value, enumName);
        return intEnum.toString();
    }

    public TEIntEnum getIntEnum(int value, String areaName) {
        TEIntEnum intEnum = new TEIntEnum(value, areaName);
        return intEnum;
    }

    public TEIntEnum getIntEnum(int value, String name, String areaName) {
        TEIntEnum intEnum = new TEIntEnum(value, name, areaName);
        return intEnum;
    }

    public static TEIntEnum getComboBoxItem(JComboBox combo, int value) {
        TEIntEnum item = null;
        int itemCount = combo.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            item = (TEIntEnum)combo.getItemAt(i);
            if (item.getValue() != value) continue;
            return item;
        }
        return null;
    }

    public static NameValuePair getComboBoxItem(JComboBox combo, String value) {
        NameValuePair item = null;
        int itemCount = combo.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            item = (NameValuePair)combo.getItemAt(i);
            if (!item.getValue().equals(value)) continue;
            return item;
        }
        return null;
    }

    public void fillDataList(List dataList, String desc) {
        try {
            InmAreaDescObject areaObject = this.file.getAreaDescObject(desc);
            for (int i = 0; i < areaObject.getDescObjectCount(); ++i) {
                InmDescObject descObject = areaObject.getDescObject(i);
                Integer type = new Integer(descObject.getStringPropertyValue("type"));
                String name = descObject.getStringPropertyValue("name");
                TEIntEnum enumer = new TEIntEnum(type, name, desc);
                dataList.add(enumer);
            }
        }
        catch (NumberFormatException e) {
            TEAppletLogMgr.error("TEEnumUtility.fillDataList() fail!", e);
        }
    }

    public class TEBooleanEnum
    extends ValueInterface {
        private boolean value;
        private String name;
        private String desc;

        public TEBooleanEnum(boolean value, String description) {
            this.value = value;
            this.name = null;
            this.desc = description;
        }

        public TEBooleanEnum(boolean value, String name, String description) {
            this.value = value;
            this.name = name;
            this.desc = description;
        }

        public String toString() {
            try {
                if (this.name != null) {
                    return this.name;
                }
                InmAreaDescObject areaObject = TEEnumUtility.this.file.getAreaDescObject(this.desc);
                for (int i = 0; i < areaObject.getDescObjectCount(); ++i) {
                    InmDescObject descObject = areaObject.getDescObject(i);
                    Integer type = new Integer(descObject.getStringPropertyValue("type"));
                    if ((!this.value || type != 1) && (this.value || type != 0)) continue;
                    return descObject.getStringPropertyValue("name");
                }
            }
            catch (NumberFormatException e) {
                TEAppletLogMgr.error("TEEnumUtility.toString() fail!", e);
            }
            return String.valueOf(this.value);
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        public boolean getBooleanValue() {
            return this.getValue();
        }

        public void setValue(boolean value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TEBooleanEnum) {
                return this.value == ((TEBooleanEnum)obj).getBooleanValue();
            }
            return false;
        }

        public int hashCode() {
            return (this.value ? 1 : 0) + this.name.hashCode();
        }
    }

    public class TEIntEnum
    extends ValueInterface
    implements InmEntry,
    Comparable {
        private int value;
        private String desc;
        private String name;

        public TEIntEnum(int value, String description) {
            this.value = value;
            this.name = null;
            this.desc = description;
        }

        public TEIntEnum(int value, String name, String description) {
            this.value = value;
            this.name = name;
            this.desc = description;
        }

        @Override
        public int getIntValue() {
            return this.getValue();
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setValue(int _value) {
            if (this.value != _value) {
                this.value = _value;
                this.name = null;
            }
        }

        public void setName(String _name) {
            this.name = _name;
        }

        public String toString() {
            try {
                if (this.name != null) {
                    return this.name;
                }
                InmAreaDescObject areaObject = TEEnumUtility.this.file.getAreaDescObject(this.desc);
                if (areaObject == null) {
                    return String.valueOf(this.value);
                }
                for (int i = 0; i < areaObject.getDescObjectCount(); ++i) {
                    InmDescObject descObject = areaObject.getDescObject(i);
                    Integer type = new Integer(descObject.getStringPropertyValue("type"));
                    if (this.value != type) continue;
                    this.name = descObject.getStringPropertyValue("name");
                    return this.name;
                }
            }
            catch (NumberFormatException e) {
                TEAppletLogMgr.error("TEEnumUtility.toString() fail!", e);
            }
            return String.valueOf(this.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TEIntEnum) {
                return ((TEIntEnum)obj).value == this.value && ((TEIntEnum)obj).desc.equals(this.desc);
            }
            if (obj instanceof TENameValuePair) {
                TENameValuePair nameValuePair = (TENameValuePair)obj;
                return nameValuePair.value == this.value && nameValuePair.name != null && nameValuePair.name.equals(this.toString());
            }
            return false;
        }

        public int hashCode() {
            int hashCode = 17;
            hashCode = 37 * hashCode + this.value;
            hashCode = 37 * hashCode + this.desc.hashCode();
            return hashCode;
        }

        @Override
        public int compare(Object o) {
            if (o instanceof TEIntEnum) {
                return this.value - ((TEIntEnum)o).value;
            }
            return 1;
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                return 1;
            }
            try {
                TEIntEnum objData = (TEIntEnum)obj;
                return this.getValue() - objData.getValue();
            }
            catch (Exception e) {
                return 1;
            }
        }
    }
}

