/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util;

import com.huawei.nglct.otdr.appletgraph.common.TEAppletLogMgr;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TEDigitFloatTextField
extends JTextField {
    boolean bAlarm = true;
    boolean isDirectInsert = false;
    int ct = 0;
    int decBitLen = 0;
    float min = Float.MIN_VALUE;
    float max = Float.MAX_VALUE;
    FocusListener listener = new FocusListener(){

        @Override
        public synchronized void focusLost(FocusEvent e) {
            try {
                String text = TEDigitFloatTextField.this.getText();
                float value = Float.parseFloat(text);
                if (value < TEDigitFloatTextField.this.min || value > TEDigitFloatTextField.this.max) {
                    this.confirm();
                }
            }
            catch (Exception ex) {
                TEAppletLogMgr.error("TEDigitFloatTextField.focusLost() fail!", ex);
            }
        }

        private void confirm() {
            if (TEDigitFloatTextField.this.ct == 0 && TEDigitFloatTextField.this.bAlarm) {
                ++TEDigitFloatTextField.this.ct;
                TEDigitFloatTextField.this.removeFocusListener(this);
                Toolkit.getDefaultToolkit().beep();
                TEDigitFloatTextField.this.isDirectInsert = true;
                TEDigitFloatTextField.this.setText(new Float(TEDigitFloatTextField.this.min).toString());
                TEDigitFloatTextField.this.isDirectInsert = false;
                TEDigitFloatTextField.this.requestFocus();
                TEDigitFloatTextField.this.addFocusListener(TEDigitFloatTextField.this.listener);
                --TEDigitFloatTextField.this.ct;
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }
    };
    private String prevStr;

    public TEDigitFloatTextField(float minf, float maxf) {
        this.setDocument(new FloatDocument(this));
        this.min = minf;
        this.max = maxf;
        this.addFocusListener(this.listener);
    }

    public TEDigitFloatTextField() {
        this(Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public TEDigitFloatTextField(float minf) {
        this(minf, Float.MAX_VALUE);
    }

    public float getValue() {
        float value;
        String s = this.getText();
        if (s.length() == 0) {
            return this.min;
        }
        char c = s.charAt(s.length() - 1);
        if (s.equals("+") || s.equals("-") || s.equals("e")) {
            float f = 0.0f;
        }
        try {
            value = c == 'e' || c == 'E' || c == '+' || c == '-' ? Float.parseFloat(this.getText() + "0") : Float.parseFloat(this.getText());
        }
        catch (Exception e) {
            value = 0.0f;
        }
        if (value < this.min || value > this.max) {
            value = this.min;
        }
        return value;
    }

    public void setRange(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public void setAlarm(boolean bAlarm) {
        this.bAlarm = bAlarm;
    }

    public void setDecBitLen(int decBitLen) {
        this.decBitLen = decBitLen;
    }

    private int getBitLen() {
        int maxLen;
        int minLen = this.getFloatLen(this.min);
        if (minLen > (maxLen = this.getFloatLen(this.max))) {
            return minLen + 1;
        }
        return maxLen + 1;
    }

    private int getFloatLen(float value) {
        float temp = value;
        int len = 0;
        if (value == 0.0f) {
            len = 1;
        }
        if (value < 0.0f) {
            value = -value;
            len = 1;
        }
        if (value > 0.0f) {
            String str = String.valueOf(temp);
            len += str.length();
        }
        return len;
    }

    @Override
    public String getText() {
        String s = super.getText();
        if (s == null || s.equals("")) {
            return "0.0";
        }
        return s;
    }

    public static void main(String[] args) {
        JDialog dialog = new JDialog();
        TEDigitFloatTextField nameTextField = new TEDigitFloatTextField(50.0f, 100.0f);
        dialog.getContentPane().setLayout(new GridBagLayout());
        dialog.setBounds(100, 100, 800, 600);
        dialog.getContentPane().add((Component)nameTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        dialog.setVisible(true);
    }

    class FloatDocument
    extends PlainDocument {
        private JTextComponent textComponent;

        public FloatDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            float value;
            int insertCount = s.length();
            if (TEDigitFloatTextField.this.isDirectInsert) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            TEDigitFloatTextField.this.prevStr = this.textComponent.getText();
            int decBitAt = TEDigitFloatTextField.this.prevStr.lastIndexOf(".");
            if (decBitAt != -1 && decBitAt < offset) {
                int decLen = TEDigitFloatTextField.this.prevStr.length() - decBitAt - 1 + insertCount;
                if (TEDigitFloatTextField.this.decBitLen > 0 && decLen > TEDigitFloatTextField.this.decBitLen) {
                    return;
                }
            }
            int textLen = TEDigitFloatTextField.this.getBitLen();
            if (TEDigitFloatTextField.this.prevStr.length() > textLen) {
                return;
            }
            String dbgStr = "";
            try {
                if (offset > 0 && offset < TEDigitFloatTextField.this.prevStr.length()) {
                    dbgStr = TEDigitFloatTextField.this.prevStr.substring(0, offset) + s + TEDigitFloatTextField.this.prevStr.substring(offset, TEDigitFloatTextField.this.prevStr.length());
                    Float.parseFloat(dbgStr);
                } else if (offset == 0) {
                    if (TEDigitFloatTextField.this.prevStr.equals("0.0")) {
                        TEDigitFloatTextField.this.prevStr = "0";
                    }
                    if (!s.equals("+") && !s.equals("-")) {
                        dbgStr = s + TEDigitFloatTextField.this.prevStr;
                        Float.parseFloat(dbgStr);
                    }
                } else if (s.equalsIgnoreCase("+") || s.equals("-") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("d")) {
                    dbgStr = TEDigitFloatTextField.this.prevStr + s + "0";
                    Float.parseFloat(dbgStr);
                } else {
                    dbgStr = TEDigitFloatTextField.this.prevStr + s;
                    Float.parseFloat(dbgStr);
                }
            }
            catch (Exception ex) {
                return;
            }
            super.insertString(offset, s, attributeSet);
            try {
                value = (s.equals("+") || s.equals("-") || s.equals("f") || s.equals("d")) && offset == TEDigitFloatTextField.this.prevStr.length() ? Float.parseFloat(this.textComponent.getText() + "0") : Float.parseFloat(this.textComponent.getText());
            }
            catch (Exception e) {
                return;
            }
            if (value > TEDigitFloatTextField.this.max) {
                super.remove(offset, insertCount);
                if (TEDigitFloatTextField.this.bAlarm && TEDigitFloatTextField.this.ct == 0) {
                    ++TEDigitFloatTextField.this.ct;
                    TEDigitFloatTextField.this.removeFocusListener(TEDigitFloatTextField.this.listener);
                    Toolkit.getDefaultToolkit().beep();
                    TEDigitFloatTextField.this.requestFocus();
                    TEDigitFloatTextField.this.addFocusListener(TEDigitFloatTextField.this.listener);
                    --TEDigitFloatTextField.this.ct;
                }
            }
        }
    }
}

