/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util;

import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TEDigitEnglishLimitDocument
extends PlainDocument {
    protected int iMaxLength = 10;
    protected Vector spupportedSymbols = new Vector();

    public TEDigitEnglishLimitDocument() {
        this.initSpupportedSymbols();
    }

    public TEDigitEnglishLimitDocument(int iMaxLength) {
        this.iMaxLength = iMaxLength;
        this.initSpupportedSymbols();
    }

    protected void initSpupportedSymbols() {
        this.spupportedSymbols.clear();
        this.spupportedSymbols.add("`");
        this.spupportedSymbols.add("~");
        this.spupportedSymbols.add("!");
        this.spupportedSymbols.add("@");
        this.spupportedSymbols.add("#");
        this.spupportedSymbols.add("$");
        this.spupportedSymbols.add("%");
        this.spupportedSymbols.add("^");
        this.spupportedSymbols.add("&");
        this.spupportedSymbols.add("*");
        this.spupportedSymbols.add("(");
        this.spupportedSymbols.add(")");
        this.spupportedSymbols.add("_");
        this.spupportedSymbols.add("-");
        this.spupportedSymbols.add("+");
        this.spupportedSymbols.add("{");
        this.spupportedSymbols.add("[");
        this.spupportedSymbols.add("}");
        this.spupportedSymbols.add("]");
        this.spupportedSymbols.add("|");
        this.spupportedSymbols.add("'");
        this.spupportedSymbols.add("<");
        this.spupportedSymbols.add(",");
        this.spupportedSymbols.add(">");
        this.spupportedSymbols.add(".");
        this.spupportedSymbols.add("/");
    }

    @Override
    public synchronized void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        String sOld = this.getText(0, this.getLength());
        int tempSize = sOld.getBytes().length + s.getBytes().length;
        if (tempSize > this.iMaxLength) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (!this.accept(s)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        super.insertString(offset, s, attributeSet);
    }

    public boolean accept(String s) {
        char[] temp = s.toCharArray();
        for (int i = 0; i < temp.length; ++i) {
            char c = temp[i];
            if (this.spupportedSymbols.contains(String.valueOf(c)) || this.isDigitEnglishChar(c)) continue;
            return false;
        }
        return true;
    }

    public synchronized void addFilterSymbolList(Vector v) {
        this.spupportedSymbols.removeAll(v);
    }

    public synchronized void setSupportedSymbolList(Vector v) {
        this.spupportedSymbols = v;
    }

    public synchronized Vector getSupportedSymboList() {
        return this.spupportedSymbols;
    }

    public synchronized void setLengthLimit(int nMaxLength) {
        if (1 < nMaxLength) {
            this.iMaxLength = nMaxLength;
        }
    }

    public boolean isDigitEnglishChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }
}

