/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.util;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmButton;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.InmUtilResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class TEAbstractJPanel
extends JPanel {
    private String print_String = InmButton.PRINT_TEXT_PROPERTY;
    private String save_String = InmButton.SAVETOFILE_TEXT_PROPERTY;
    private JButton printBtnToBind = null;
    private JButton saveToFileBtnToBind = null;
    protected static final KeyStroke CTRL_P_KEYSTROKE = KeyStroke.getKeyStroke(80, 2, false);
    protected static final KeyStroke CTRL_S_KEYSTROKE = KeyStroke.getKeyStroke(83, 2, false);
    protected static final String CTRL_P_PRESSED_STR = "ctrl_p.pressed";
    protected static final String CTRL_S_PRESSED_STR = "ctrl_s.pressed";
    private final AbstractAction ctrl_P_PressedAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TEAbstractJPanel.this.doPrintOperation(e);
        }
    };
    private final AbstractAction ctrl_S_PressedAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TEAbstractJPanel.this.doSaveOperation(e);
        }
    };

    public TEAbstractJPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public TEAbstractJPanel(LayoutManager layout) {
        super(layout, true);
    }

    public TEAbstractJPanel(boolean isDoubleBuffered) {
        super(new FlowLayout(), isDoubleBuffered);
    }

    public TEAbstractJPanel() {
        super(true);
    }

    public void initBind() {
        this.doSomethingForKeyBind();
    }

    private void doSomethingForKeyBind() {
        this.initializeData();
        this.lookForComponentsToBind(this);
        this.doKeyboardBind();
    }

    private void initializeData() {
        if (this.printBtnToBind != null) {
            this.unRegisterKeyBind(this.printBtnToBind);
        }
        this.printBtnToBind = null;
        if (this.saveToFileBtnToBind != null) {
            this.unRegisterKeyBind(this.saveToFileBtnToBind);
        }
        this.saveToFileBtnToBind = null;
    }

    private void unRegisterKeyBind(JButton jBtn) {
        if (jBtn != null) {
            jBtn.getInputMap().clear();
            jBtn.getActionMap().clear();
        }
    }

    private void lookForComponentsToBind(Container container) {
        for (int i = 0; i < container.getComponents().length; ++i) {
            Component subComponent = container.getComponent(i);
            if (subComponent instanceof JButton) {
                this.setButtonsToBind((JButton)subComponent);
                continue;
            }
            if (!(subComponent instanceof Container)) continue;
            this.lookForComponentsToBind((Container)subComponent);
        }
    }

    private void doKeyboardBind() {
        if (this.printBtnToBind != null) {
            InputMap btnPrintInputMap = this.printBtnToBind.getInputMap(2);
            btnPrintInputMap.put(CTRL_P_KEYSTROKE, CTRL_P_PRESSED_STR);
            ActionMap btnPrintActionMap = this.printBtnToBind.getActionMap();
            btnPrintActionMap.put(CTRL_P_PRESSED_STR, this.ctrl_P_PressedAction);
        }
        if (this.saveToFileBtnToBind != null) {
            InputMap saveBtnInputMap = this.saveToFileBtnToBind.getInputMap(2);
            saveBtnInputMap.put(CTRL_S_KEYSTROKE, CTRL_S_PRESSED_STR);
            ActionMap saveBtnActionMap = this.saveToFileBtnToBind.getActionMap();
            saveBtnActionMap.put(CTRL_S_PRESSED_STR, this.ctrl_S_PressedAction);
        }
    }

    private void setButtonsToBind(JButton jButton) {
        String btnText2;
        String btnText1 = jButton.getText().trim();
        if (this.isBtnMatched(btnText1, btnText2 = jButton.getActionCommand().trim(), this.getPrintBtnText()) || this.isBtnMatched(btnText1, btnText2, this.getPrintBtnText1())) {
            if (this.printBtnToBind == null) {
                this.setPrintBtn_To_Bind(jButton);
            }
        } else if ((this.isBtnMatched(btnText1, btnText2, this.getSaveBtnText()) || this.isBtnMatched(btnText1, btnText2, this.getSaveBtnText1())) && this.saveToFileBtnToBind == null) {
            this.setSaveBtn_To_Bind(jButton);
        }
    }

    private void setPrintBtn_To_Bind(JButton jButton) {
        this.printBtnToBind = jButton;
    }

    private void setSaveBtn_To_Bind(JButton jButton) {
        this.saveToFileBtnToBind = jButton;
    }

    private String getPrintBtnText() {
        return this.print_String;
    }

    private String getPrintBtnText1() {
        return InmUtilResourceManager.getString("button_Print1");
    }

    private String getSaveBtnText() {
        return this.save_String;
    }

    private String getSaveBtnText1() {
        return InmUtilResourceManager.getString("button_SaveToFile1");
    }

    private boolean isBtnMatched(String text1, String text2, String consultStr) {
        return this.delStrSpace(consultStr).equalsIgnoreCase(this.delStrSpace(text1.trim())) || this.delStrSpace(consultStr).equalsIgnoreCase(this.delStrSpace(text2.trim()));
    }

    private void doPrintOperation(ActionEvent e) {
        if (this.printBtnToBind != null && this.printBtnToBind.isEnabled()) {
            this.printBtnToBind.doClick();
        }
    }

    private void doSaveOperation(ActionEvent e) {
        if (this.saveToFileBtnToBind != null && this.saveToFileBtnToBind.isEnabled()) {
            this.saveToFileBtnToBind.doClick();
        }
    }

    public String delStrSpace(String sourceStr) {
        return sourceStr.replaceAll(" ", "");
    }
}

