/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxIcon;

public class InmHwComboBoxUI
extends BasicComboBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new InmHwComboBoxUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    @Override
    protected ComboPopup createPopup() {
        MetalComboPopup popup = new MetalComboPopup(this.comboBox);
        popup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return popup;
    }

    @Override
    protected JButton createArrowButton() {
        MetalComboBoxButton button = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.setMargin(new Insets(0, 1, 1, 3));
        return button;
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    protected void editablePropertyChanged(PropertyChangeEvent e) {
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    public void layoutComboBox(Container parent, MetalComboBoxLayoutManager manager) {
        if (this.comboBox.isEditable()) {
            manager.superLayout(parent);
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            int width = this.comboBox.getWidth();
            int height = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
        }
    }

    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public void configureEditor() {
        super.configureEditor();
    }

    @Override
    public void unconfigureEditor() {
        super.unconfigureEditor();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton button = (MetalComboBoxButton)this.arrowButton;
            Insets buttonInsets = button.getInsets();
            Insets insets = this.comboBox.getInsets();
            size = this.getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += buttonInsets.right + button.getComboIcon().getIconWidth();
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            size = super.getMinimumSize(c);
            Insets margin = this.arrowButton.getMargin();
            size.height += margin.top + margin.bottom;
        } else {
            size = super.getMinimumSize(c);
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public class MetalComboPopup
    extends BasicComboPopup {
        public MetalComboPopup(JComboBox cBox) {
            super(cBox);
        }

        @Override
        public void delegateFocus(MouseEvent e) {
            super.delegateFocus(e);
        }

        @Override
        public void show() {
            int offset;
            Dimension popupSize = this.comboBox.getSize();
            int width = popupSize.width;
            int maxElementWidth = 0;
            ListModel listModel = this.list.getModel();
            FontMetrics fm = this.list.getFontMetrics(this.list.getFont());
            int size = listModel.getSize();
            for (int i = 0; i < size; ++i) {
                try {
                    String str = listModel.getElementAt(i).toString();
                    int temp = SwingUtilities.computeStringWidth(fm, str);
                    if (temp <= maxElementWidth) continue;
                    maxElementWidth = temp;
                    continue;
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
            if (listModel.getSize() > this.list.getVisibleRowCount()) {
                maxElementWidth += 25;
            }
            if (width < maxElementWidth) {
                width = maxElementWidth;
            }
            popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, width, popupSize.height);
            this.scroller.setMaximumSize(popupBounds.getSize());
            this.scroller.setPreferredSize(popupBounds.getSize());
            this.scroller.setMinimumSize(popupBounds.getSize());
            this.list.invalidate();
            this.syncListSelectionWithComboBoxSelection();
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
            this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
            Point comboBoxPosition = this.comboBox.getLocationOnScreen();
            int taskBarHeight = 50;
            int x = popupBounds.x;
            int y = popupBounds.y;
            int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
            int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
            if (comboBoxPosition.y + popupBounds.y + popupSize.height + taskBarHeight > screenHeight) {
                y = -popupSize.height;
            }
            if ((offset = screenWidth - (comboBoxPosition.x + popupBounds.x + popupSize.width)) < 0) {
                x += offset;
            }
            this.setTableAutoScroll();
            this.show(this.comboBox, x, y);
        }

        void setTableAutoScroll() {
            Container o;
            for (o = this.comboBox.getParent(); !(o instanceof JTable) && null != o; o = o.getParent()) {
            }
            if (o instanceof JTable) {
                JTable table = (JTable)o;
                table.setAutoscrolls(false);
            }
        }

        void syncListSelectionWithComboBoxSelection() {
            int selectedIndex = this.comboBox.getSelectedIndex();
            if (selectedIndex == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(selectedIndex);
            }
        }
    }

    public class MetalComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public MetalComboBoxLayoutManager() {
            super(InmHwComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            InmHwComboBoxUI.this.layoutComboBox(parent, this);
        }

        public void superLayout(Container parent) {
            super.layoutContainer(parent);
        }
    }

    public class MetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public MetalPropertyChangeListener() {
            super(InmHwComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if ("editable".equals(propertyName.toLowerCase())) {
                MetalComboBoxButton button = (MetalComboBoxButton)InmHwComboBoxUI.this.arrowButton;
                button.setIconOnly(InmHwComboBoxUI.this.comboBox.isEditable());
                InmHwComboBoxUI.this.comboBox.repaint();
            } else if ("background".equals(propertyName.toLowerCase())) {
                Color color = (Color)e.getNewValue();
                InmHwComboBoxUI.this.arrowButton.setBackground(color);
                InmHwComboBoxUI.this.listBox.setBackground(color);
            } else if ("foreground".equals(propertyName.toLowerCase())) {
                Color color = (Color)e.getNewValue();
                InmHwComboBoxUI.this.arrowButton.setForeground(color);
                InmHwComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }
}

