/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable;

import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.AbstractEntry;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.InmEntry;
import com.huawei.nglct.otdr.appletgraph.core.imap.imap12.utility.sortTable.SorterInterface;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class TableSorter {
    private SorterInterface sortDelegator;
    private Comparator delegateComp = null;
    private int oldCol = -1;
    private int swapNum = 0;

    public TableSorter(SorterInterface model) {
        this.sortDelegator = model;
    }

    public void sort(int column, boolean isAscent) {
        int[] indexes = this.sortDelegator.getIndexes();
        int len = indexes.length;
        Entry[] table = new Entry[len];
        for (int i = 0; i < len; ++i) {
            table[i] = new Entry();
        }
        for (int index = 0; index < len; ++index) {
            table[index].key = index;
            table[index].value = this.sortDelegator.getModelValueAt(index, column);
        }
        this.initComp(column);
        Object[] aux = new Entry[len];
        System.arraycopy(table, 0, aux, 0, len);
        this.mergeSort((Entry[])aux, table, 0, len);
        Arrays.fill(aux, null);
        if (this.swapNum == 0 && len > 0) {
            if (null != table[0].value && null != table[table.length - 1].value && table[0].value.equals(table[table.length - 1].value)) {
                return;
            }
            if (null == table[0].value && null == table[table.length - 1].value) {
                return;
            }
        }
        if (isAscent) {
            for (int i = 0; i < len; ++i) {
                indexes[i] = table[i].key;
            }
            this.swapNum = 0;
        } else {
            for (int i = 0; i < len; ++i) {
                indexes[i] = table[len - i - 1].key;
            }
            this.swapNum = 0;
        }
    }

    private void mergeSort(Entry[] src, Entry[] dest, int low, int high) {
        if (high - low < 7) {
            int i = 0;
            for (i = low; i < high; ++i) {
                for (int j = i; j > low && this.compare1(dest[j - 1].value, dest[j].value) > 0; --j) {
                    TableSorter.swap(dest, j, j - 1);
                    ++this.swapNum;
                }
            }
            return;
        }
        int mid = low + high >>> 1;
        this.mergeSort(dest, src, low, mid);
        this.mergeSort(dest, src, mid, high);
        if (this.compare1(src[mid - 1].value, src[mid].value) <= 0) {
            System.arraycopy(src, low, dest, low, high - low);
            return;
        }
        int i = 0;
        int p = 0;
        int q = 0;
        p = low;
        q = mid;
        for (i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && this.compare1(src[p].value, src[q].value) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void swap(Entry[] x, int a, int b) {
        int key = x[a].key;
        Object value = x[a].value;
        x[a].key = x[b].key;
        x[a].value = x[b].value;
        x[b].key = key;
        x[b].value = value;
    }

    private void initComp(int col) {
        if (this.oldCol != col || this.delegateComp == null) {
            this.oldCol = col;
            this.delegateComp = null;
            Class type = this.sortDelegator.getColumnClass(col);
            this.delegateComp = type.getSuperclass() == AbstractEntry.class || this.isInmEntryClass(type) ? new Comparator(){

                public int compare(Object a, Object b) {
                    return TableSorter.this.compare((InmEntry)a, (InmEntry)b);
                }
            } : (type == Boolean.class ? new Comparator(){

                public int compare(Object a, Object b) {
                    return TableSorter.this.compare((Boolean)a, (Boolean)b);
                }
            } : new Comparator(){

                public int compare(Object a, Object b) {
                    return TableSorter.this.compare(a, b);
                }
            });
        }
    }

    private boolean isInmEntryClass(Class type) {
        Class<?>[] c = type.getInterfaces();
        List<Class<?>> list = Arrays.asList(c);
        return list.contains(InmEntry.class);
    }

    private int compare1(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return this.delegateComp.compare(o1, o2);
    }

    public int compare(Boolean o1, Boolean o2) {
        boolean b2;
        boolean b1 = o1;
        if (b1 == (b2 = o2.booleanValue())) {
            return 0;
        }
        if (b1) {
            return 1;
        }
        return -1;
    }

    public int compare(InmEntry o1, InmEntry o2) {
        return o1.compare(o2);
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return this.compare((Comparable)o1, (Comparable)o2);
        }
        String o1str = o1.toString();
        String o2str = o2.toString();
        return o1str.compareTo(o2str);
    }

    public int compare(Comparable o1, Comparable o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    private static class Entry
    implements InmEntry {
        int key;
        Object value;

        public Entry() {
        }

        protected Entry(int _key, Object _value) {
            this.key = _key;
            this.value = _value;
        }

        @Override
        public int compare(Object o) {
            if (!(o instanceof Entry)) {
                return -1;
            }
            Entry data = (Entry)o;
            return this.key - data.key;
        }
    }
}

